package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseUmcReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 标题：类名称:UocAfterOrderCreateReqBo
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/1 14:22
 * 作者 @author 尹栋梁
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class UocAfterOrderCreateReqBo extends BaseUmcReqBo {
    private static final long serialVersionUID = -7070282953681938211L;

    @DocField(value = "发货单ID")
    private Long shipOrderId;

    @DocField(value = "订单ID")
    private Long orderId;

    @DocField(value = "销售单ID")
    private Long saleOrderId;

    @DocField(value = "订单来源")
    private Integer orderSource;

    @DocField(value = "外部售后单Id")
    private String serviceId;

    @DocField(value = "服务类型 退货(10)、换货(20)、维修(30)")
    private Integer servType;

    @DocField(value = "售后原因")
    private Integer afsReason;

    @DocField(value = "取货服务类型  1： 上门取件 2：客户发货 3： 客户送货")
    private Integer pickwareType;

    @DocField(value = "取件地址 pickwareType=1必填")
    private UocAfterOrderCreateReqAddressBo takeAddress;

    @DocField(value = "返件地址 servType=20/30必填")
    private UocAfterOrderCreateReqAddressBo returnAddress;

    @DocField(value = "问题描述")
    private String questionDesc;

    @DocField(value = "售后明细")
    private List<UocAfterOrderCreateReqItemBo> shipItemList;

    @DocField(value = "纵向扩展数据")
    private List<UocBaseExtParallelBo> extParallelBoList;

    @DocField(value = "附件")
    private List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList;

    @DocField(value = "取货开始时间")
    private Date pickupStartTime;

    @DocField(value = "取货结束时间")
    private Date pickupEndTime;
    
    @DocField(value = "京东售后申请批次号")
    private String thirdApplyId;
}
