package com.tydic.dyc.oc.service.domainservice.bo;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.bo.BaseUmcReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 标题:UocArrvalAcceptanceReqBo
 * 说明:验收单到货验收
 * 时间:2022/2/22 17:17
 * 作者:罗有
 */

@EqualsAndHashCode(callSuper = true)
@Data
public class UocArrvalAcceptanceReqBo extends BaseUmcReqBo {
    private static final long serialVersionUID = 6089201864274947760L;

    @DocField(value = "订单id", required = true)
    private Long orderId;

    @DocField(value = "销售单ID", required = true)
    private Long saleOrderId;

    @DocField(value = "备注")
    private String remark;

    @DocField(value = "其它备注")
    private String otherRemark;

    @DocField(value = "任务ID")
    private String taskId;

    @DocField(value = "环节编码")
    private String stepId;

    @DocField(value = "关闭尾差 true是 false否", required = true)
    private Boolean closePennyDiff;

    @DocField(value = "验收完结 true是 false否", required = true)
    private Boolean inspFinish;

    @DocField(value = "纵向扩展数据")
    private List<UocBaseExtParallelBo> extParallelBoList;

    @DocField(value = "发货信息", required = true)
    private List<UocCreateInspOrderReqShipBo> shipOrderList;

    @DocField(value = "附件")
    private List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList;

    @DocField(value = "业务外参数", required = true)
    private JSONObject jsonObj;

    @DocField(value = "账期天数")
    private Integer payAccountDay;
}
