package com.tydic.dyc.oc.service.saleorder.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 标题:UocResoveEsPreOrderServiceReqBo
 * 说明:
 * 时间:2022/4/12 21:02
 * 作者:田桂银
 */
@Data
public class UocResoveEsPreOrderServiceReqBo extends BaseReqBo {

    private static final long serialVersionUID = 8364246181333270833L;

    @DocField(value = "订单id",required = true)
    private Long orderId;

    @DocField(value = "销售单id",required = true)
    private Long saleOrderId;

    @DocField(value = "外部订单id",required = true)
    private String outOrderId;

    @DocField("总运费; 这个是订单总运费 = 基础运费 + 总的超重偏远附加运费")
    private BigDecimal freight;

    @DocField("商品总价格")
    private BigDecimal orderPrice;

    @DocField("订单裸价")
    private BigDecimal orderNakedPrice;

    @DocField("订单税额")
    private BigDecimal orderTaxPrice;

    @DocField("京东订单号")
    private String jdOrderId;

    @DocField("sku列表")
    private List<UocResoveEsPreOrderServiceReqSkuBo> sku;

    @DocField(value = "订单创建结果 0创建中，1成功，2失败")
    private Integer createdResult;

    @DocField(value = "撤单原因")
    private String cancelReason;

}


