package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 标题:UocImplShipOrderReqItemBo
 * 说明:发货单明细
 * 时间:2022/2/22 14:33
 * 作者:罗有
 */

@Data
public class UocSaleShipOrderReqItemBo implements Serializable {
    private static final long serialVersionUID = 4162608036444938276L;

    @DocField(value = "销售单明细ID", required = true)
    private Long saleOrderItemId;
    
    @DocField(value = "发货数量", required = true)
    private BigDecimal sendCount;

    @DocField(value = "备注")
    private String remark;

    @DocField(value = "纵向扩展数据")
    private List<UocBaseExtParallelBo> itemExtParallelBoList;

    /**
     * 租户id
     */
    private Long sysTenantId;
    private String sysTenantName;
}
