package com.tydic.dyc.oc.service.order.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 标题：UocOrderRelUpdateReqBo
 * 说明：订单关联更新入参
 * 时间：2022/4/1 14:52
 *
 * @author 文乐
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class UocOrderRelUpdateReqBo extends BaseReqBo {
    private static final long serialVersionUID = 2559543926041399980L;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 对象ID
     */
    private Long objId;

    /**
     * 对象类型 1.订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单  8验收单  9审批单 10变更单   99.其他
     */
    private Integer objType;

    /**
     * 关联类型 0普通开票 1上游开票 2服务费
     */
    private Integer relType;

    /**
     * 关联状态 0未提交 1已提交 2挂起
     */
    private Integer relState;

    /**
     * 关联ID
     */
    private String relId;

    /**
     * 租户id
     */
    private Long sysTenantId;
    private String sysTenantName;

}
