package com.tydic.dyc.oc.service.saleorder.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocGetSaleOrderDetailServiceRspInspOrderItemInfoBo
 * 说明:验收明细
 * 时间:2022-02-21 19:09
 * 作者:tkl
 **/
@Data
public class UocGetSaleOrderDetailServiceRspInspOrderItemInfoBo implements Serializable {
	private static final long serialVersionUID = 1171614207898025545L;

	/**验收明细id*/
	private Long inspOrderItemId;

	/**订单id*/
	private Long orderId;

	/**销售单id*/
	private Long saleOrderId;

	/**执行明细id*/
	private Long implOrderItemId;

	/**销售明细id*/
	private Long saleOrderItemId;

	/**验收单id*/
	private Long inspOrderId;

	/**发货明细ID*/
	private Long shipOrderItemId;

	/**状态1 已验收 2 退货申请中             3 退货完成*/
	private String inspItemStatus;

	/**状态翻译*/
	private String inspItemStatusStr;

	/**计量单位*/
	private String unitName;

	/**验收数量*/
	private BigDecimal inspCount;

	/**退货中数量*/
	private BigDecimal returnCount;

	/**已退货数量*/
	private BigDecimal alreadyReturnCount;

	/**
	 * 变更数量
	 */
	private BigDecimal chngingCount;

	/**创建时间*/
	private Date createTime;

	/**创建工号*/
	private String createOperId;

	/**更新时间*/
	private Date updateTime;

	/**更新工号*/
	private String updateOperId;

	/**备注*/
	private String remark;

	/**纵向扩展*/
	private List<UocGetSaleOrderDetailServiceRspInspOrderItemExtParallelBo> itemExtParallelBoList;

	/**
	 * 租户id
	 */
	private Long sysTenantId;
	private String sysTenantName;
}
