package com.tydic.dyc.oc.service.implorder.bo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocGetImplOrderDetailsServiceRspItemBo
 * 说明:执行单明细信息
 * 时间:2022/2/14 14:24
 * 作者:罗有
 */

@Data
public class UocGetImplOrderDetailsServiceRspItemBo implements Serializable {
    private static final long serialVersionUID = -8009710685725649658L;

    @DocField(value = "订单id")
    private Long orderId;

    @DocField(value = "销售单id")
    private Long saleOrderId;

    @DocField(value = "执行明细id")
    private Long implOrderItemId;

    @DocField(value = "销售明细id")
    private Long saleOrderItemId;


	@DocField(value = "明细状态")
    private String implItemState;

    @DocField(value = "明细状态翻译")
    private String implItemStateStr;

    @DocField(value = "明细类型             1 商品sku             2 物资             3 项目")
    private Integer itemType;

    @DocField(value = "明细类型翻译")
    private String itemTypeStr;

    @DocField(value = "单品ID")
    private String skuId;

    @DocField(value = "单品名称")
    private String skuName;

    @DocField(value = "商品名称")
    private String commodityName;

    @DocField(value = "商品ID")
    private String commodityId;

    @DocField(value = "供应商ID")
    private String supplierId;

    @DocField(value = "店铺ID")
    private String supplierShopId;

    @DocField(value = "计量单位")
    private String unitName;

    @DocField(value = "结算计量单位")
    private String settleUnit;

    @DocField(value = "采购金额")
    private BigDecimal purchaseFee;

    @DocField(value = "销售金额")
    private BigDecimal saleFee;

    @DocField(value = "应付金额")
    private BigDecimal payFee;

    @DocField(value = "运费")
    private BigDecimal transFee;

    @DocField(value = "积分优惠金额")
    private BigDecimal integralDisFee;

    @DocField(value = "活动优惠金额")
    private BigDecimal actDisFee;

    @DocField(value = "其它优惠金额")
    private BigDecimal otherDisFee;

    @DocField(value = "实付金额")
    private BigDecimal usedFee;

    @DocField(value = "实付积分")
    private BigDecimal usedIntegral;

    @DocField(value = "币种")
    private String currencyType;

    @DocField(value = "税金")
    private String taxPrice;

    @DocField(value = "税率")
    private String tax;

    @DocField(value = "税务编码")
    private String taxId;

    @DocField(value = "采购数量")
    private BigDecimal purchaseCount;

    @DocField(value = "发货数量")
    private BigDecimal sendCount;

    @DocField(value = "到货数量")
    private BigDecimal arriveCount;

    @DocField(value = "拒收数量")
    private BigDecimal refuseCount;

    @DocField(value = "退货数量")
    private BigDecimal returnCount;

    @DocField(value = "验收数量")
    private BigDecimal acceptanceCount;

    @DocField(value = "售后在途数量")
    private BigDecimal afterServingCount;

    @DocField(value = "超验百分比，下单时保存（协议、无协议）")
    private Integer inspectionExcessPercent;

    @DocField(value = "采购金额")
    private BigDecimal purchasePrice;

    @DocField(value = "采购金额")
    private BigDecimal salePrice;

    @DocField(value = "sku物料编码")
    private String skuMaterialId;

    @DocField(value = "sku外部单品id")
    private String skuExtSkuId;

    @DocField(value = "sku品牌id")
    private Long skuBrandId;

    @DocField(value = "单品品牌名称")
    private String skuBrandName;

    @DocField(value = "sku明细id")
    private String skuItemId;

    @DocField(value = "sku物料名称")
    private String skuMaterialName;

    @DocField(value = "sku物料类型名称")
    private String skuMaterialTypeName;

    @DocField(value = "sku物料类型id")
    private String skuMaterialTypeId;

    @DocField(value = "型号")
    private String model;

    @DocField(value = "规格")
    private String spec;

    @DocField(value = "材质")
    private String texture;

    @DocField(value = "图号")
    private String figure;

    @DocField(value = "一级类目")
    private Long l1Catalog;

    @DocField(value = "二级类目")
    private Long l2Catalog;

    @DocField(value = "三级类目")
    private Long l3Catalog;

    @DocField(value = "一级类目名称")
    private String l1CatalogName;

    @DocField(value = "二级类目名称")
    private String l2CatalogName;

    @DocField(value = "三级类目名称")
    private String l3CatalogName;

    @DocField(value = "sku单品主图url")
    private String skuMainPicUrl;

    @DocField(value = "创建时间")
    private Date createTime;

    @DocField(value = "创建工号")
    private String createOperId;

    @DocField(value = "更新时间")
    private Date updateTime;

    @DocField(value = "更新工号")
    private String updateOperId;

    @DocField(value = "备注")
    private String remark;

    @DocField(value = "执行单明细拓展信息")
    private List<UocGetImplOrderDetailsServiceRspItemExtBo> implOrderDetailsServiceRspItemExtBoList;
}
