package com.tydic.dyc.oc.service.domainservice.bo;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.bo.BaseUmcReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：
 *
 * @author tgy
 * @date 2022/2/13 20:54
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocCreateOrderServiceReqBo extends BaseUmcReqBo {

    private static final long serialVersionUID = 7344454593346320509L;

    @DocField(value = "销售总金额", required = true)
    private BigDecimal totalSaleFee;

    @DocField(value = "采购总金额", required = true)
    private BigDecimal totalPurchaseFee;

    @DocField(value = "运费")
    private BigDecimal totalTransFee;

    @DocField(value = "备注")
    private String remark;

    @DocField(value = "采购方账套id", required = true)
    private String purAccount;

    @DocField(value = "采购方账套名称", required = true)
    private String purAccountName;

    @DocField("采购方联系人")
    private String purContactName;

    @DocField(value = "采购方联系人电话")
    private String purMobile;

    @DocField(value = "需方联系人名称")
    private String purNeedName;

    @DocField(value = "需方联系电话")
    private String purNeedMobile;

    @DocField("送货时间")
    private Date sendTime;

    @DocField("订单级别 1 个人订单  2 企业订单，默认个人订单")
    private Integer orderLevel;

    @DocField("是否同步创建销售单及其相关信息，默认false")
    private Boolean createSaleOrder;

    @DocField(value = "订单名称")
    private String orderName;

    @DocField(value = "下单系统")
    private String orderSystem;

    @DocField(value = "订单类型 :1.采购电商")
    private Integer orderType;

    @DocField(value = "订单说明")
    private String orderDesc;

    @DocField(value = "实付金额")
    private BigDecimal usedFee;

    @DocField(value = "实付积分")
    private BigDecimal usedIntegral;

//    @DocField(value = "租户ID")
//    private String tenantId;

    @DocField(value = "商品信息", required = true)
    private List<UocCreateOrderServiceReqCommodityBo> commodityBos;

    @DocField(value = "发票信息")
    private UocCreateOrderServiceReqInvoiceBo invoiceBO;

    @DocField(value = "运营方信息", required = true)
    private UocCreateOrderServiceReqProfessionalBo professionalBo;

    @DocField("支付配置，当需要同步创建销售单时(createSaleOrder为true)，必传（从结算基于采购方和运营方查询）")
    private List<UocCreateOrderServiceReqPayConfSupBo> payConfigList;

    @DocField(value = "协议支付配置")
    private List<UocCreateOrderServiceReqArgPayConfSupBo> agrPayConfigList;

    @DocField(value = "收货人地址信息", required = true)
    private UocCreateOrderServiceReqAddressBo addressBo;

    @DocField(value = "发票邮寄信息")
    private UocCreateOrderServiceReqAddressBo invoiceAddressBo;

    @DocField(value = "订单附件信息")
    private List<UocCreateOrderServiceReqAccessoryBo> accessoryList;

    @DocField("订单纵向扩展数据")
    private List<UocBaseExtParallelBo> orderParallelExtList;

    @DocField(value = "业务外参数（签约单信息或其他）")
    private JSONObject jsonObj;

    @DocField(value = "订单创建结果 0创建中，1成功，2失败")
    private Integer createdResult;
}


