package com.tydic.dyc.oc.service.domainservice.bo;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：
 *
 * @author tgy
 * @date 2022/2/13 20:54
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocCreateOrderServiceReqBo extends BaseReqBo {

    private static final long serialVersionUID = 7344454593346320509L;

    /**
     * 销售总金额
     */
    private BigDecimal totalSaleFee;

    /**
     * 采购总金额
     */
    private BigDecimal totalPurchaseFee;

    /**
     * 运费
     */
    private BigDecimal totalTransFee;

    /**
     * 备注
     */
    private String remark;

    /**
     * 采购方账套id
     */
    private String purAccount;

    /**
     * 采购方账套名称
     */
    private String purAccountName;

    /**
     * 采购方联系人
     */
    private String purContactName;

    /**
     * 采购方联系人电话
     */
    private String purMobile;

    /**
     * 需方联系人名称
     */
    private String purNeedName;

    /**
     * 需方联系电话
     */
    private String purNeedMobile;

    /**
     * 送货时间
     */
    private Date sendTime;

    /**
     * 订单级别 1 个人订单  2 企业订单，默认个人订单
     */
    private Integer orderLevel;

    /**
     * 是否同步创建销售单及其相关信息，默认false
     */
    private Boolean createSaleOrder;

    /**
     * 订单名称
     */
    private String orderName;

    /**
     * 下单系统
     */
    private String orderSystem;

    /**
     * 订单类型 :1.采购电商
     */
    private Integer orderType;

    /**
     * 订单说明
     */
    private String orderDesc;

    /**
     * 实付金额
     */
    private BigDecimal usedFee;

    /**
     * 实付积分
     */
    private BigDecimal usedIntegral;

//    租户ID
//    private String tenantId;

    /**
     * 商品信息
     */
    private List<UocCreateOrderServiceReqCommodityBo> commodityBos;

    /**
     * 发票信息
     */
    private UocCreateOrderServiceReqInvoiceBo invoiceBO;

    /**
     * 运营方信息
     */
    private UocCreateOrderServiceReqProfessionalBo professionalBo;

    /**
     * 支付配置，当需要同步创建销售单时(createSaleOrder为true)，必传（从结算基于采购方和运营方查询）
     */
    private List<UocCreateOrderServiceReqPayConfSupBo> payConfigList;

    /**
     * 协议支付配置
     */
    private List<UocCreateOrderServiceReqArgPayConfSupBo> agrPayConfigList;

    /**
     * 收货人地址信息
     */
    private UocCreateOrderServiceReqAddressBo addressBo;

    /**
     * 发票邮寄信息
     */
    private UocCreateOrderServiceReqAddressBo invoiceAddressBo;

    /**
     * 订单附件信息
     */
    private List<UocCreateOrderServiceReqAccessoryBo> accessoryList;

    /**
     * 订单纵向扩展数据
     */
    private List<UocBaseExtParallelBo> orderParallelExtList;

    /**
     * 业务外参数（签约单信息或其他）
     */
    private JSONObject jsonObj;

    /**
     * 订单创建结果 0创建中，1成功，2失败
     */
    private Integer createdResult;

    private Long userId;

    /**
     * 用户名称
     */
    private String name;

    /**
     * 用户登陆名称
     */
    private String username;

    private Long orgId;

    private String orgName;

    private Long companyId;

    private String companyName;

    private String orgPath;

}


