package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 标题:UocImplShipOrderReqBo
 * 说明:执行单发货 入参
 * 时间:2022/2/22 14:23
 * 作者:罗有
 */

@EqualsAndHashCode(callSuper = true)
@Data
public class UocSaleShipOrderReqBo extends BaseReqBo {
    private static final long serialVersionUID = -5637207939037461261L;

    /*
    * 订单ID
    * */
    private Long orderId;

    /*
    * 销售单ID
    * */
    private Long saleOrderId;

    /*
    * 环节编码
    * */
    private String tacheCode;

    /*
    * 发货单类型
    * */
    private Integer shipOrderType;

    /*
    * 物流公司id
    * */
    private String shipCompanyId;

    /*
    * 物流公司名称
    * */
    private String shipCompanyName;

    /*
    * 物流单号
    * */
    private String shipCompanyNo;

    /*
    * 车牌号
    * */
    private String carNo;

    /*
    * 运输方式
    * */
    private Integer transportMode;

    /*
    * 发货时间
    * */
    private Date shipTime;

    /*
    * 发货联系人姓名
    * */
    private String shipName;

    /*
    * 发货联系人电话
    * */
    private String shipPhone;

    /*
    * 预计到货时间
    * */
    private Date estimateArrivalTime;

    /*
    * 发货备注
    * */
    private String shipRemark;

    /*
    * 纵向扩展数据
    * */
    private List<UocBaseExtParallelBo> extParallelBoList;

    /*
    * 发货明细
    * */
    private List<UocSaleShipOrderReqItemBo> shipOrderItemBoList;
    
    /*
    * 附件
    * */
    private List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList;

    /*
    * 会员信息：用户id
    * */
    private Long userId;

    /*
    * 会员信息：供应商ID
    * */
    private Long supId;
}
