package com.tydic.dyc.oc.service.saleorder.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 描述: 〈领域服务-电商预定单下单成功处理服务 入参〉
 * @author : yuhao
 * @date : 2022/8/1 11:05
 */
@Data
public class UocResoveEsPreOrderServiceReqBo extends BaseReqBo {

    private static final long serialVersionUID = 8364246181333270833L;

    /**订单id*/
    private Long orderId;

    /**销售单id*/
    private Long saleOrderId;

    /**外部订单id*/
    private String outOrderId;

    /**总运费; 这个是订单总运费 = 基础运费 + 总的超重偏远附加运费*/
    private BigDecimal freight;

    /**商品总价格*/
    private BigDecimal orderPrice;

    /**订单裸价*/
    private BigDecimal orderNakedPrice;

    /**订单税额*/
    private BigDecimal orderTaxPrice;

    /**京东订单号*/
    private String jdOrderId;

    /**sku列表*/
    private List<UocResoveEsPreOrderServiceReqSkuBo> sku;

    /**订单创建结果 0创建中，1成功，2失败*/
    private Integer createdResult;

}


