package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 描述：
 *
 * @author tgy
 * @date 2022/2/14 21:55
 */
@Data
public class UocCreateOrderServiceReqCommodityBo implements Serializable {

    private static final long serialVersionUID = 6454961344338211931L;

    /**
     * 单品ID
     */
    private String skuId;

    /**
     * 单品code
     */
    private String skuCode;

    /**
     * 单品名称
     */
    private String skuName;

    /**
     * 商品id
     */
    private String commodityId;

    /**
     * 商品名称
     */
    private String commodityName;

    /**
     * 商品类型ID
     */
    private String commodityTypeId;

    /**
     * 商品类型名称
     */
    private String commodityTypeName;

    /**
     * 供应商id
     */
    private String supplierId;

    /**
     * 供应商编码
     */
    private String supNo;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 供应商联系人
     */
    private String supRelaName;

    /**
     * 供应商联系电话
     */
    private String supRelaMobile;

    /**
     * 店铺ID
     */
    private String supplierShopId;

    /**
     * 店铺名称
     */
    private String supplierShopName;

    /**
     * 采购单价
     */
    private BigDecimal purchasePrice;

    /**
     * 销售单价
     */
    private BigDecimal salePrice;

    /**
     * 采购数量
     */
    private BigDecimal purchaseCount;

    /**
     * 商品来源，区分电商、协议、无协议
     */
    private Integer skuSource;

    /**
     * 运费
     */
    private BigDecimal transFee;

    /**
     * 计量单位
     */
    private String unitName;

    /**
     * 结算计量单位
     */
    private String settleUnit;

    /**
     * 加价率
     */
    private Double markUpRate;

    /**
     * 计划id
     */
    private String planId;

    /**
     * 计划明细id
     */
    private String planItemId;

    /**
     * 计划编号
     */
    private String planNo;

    /**
     * 计划明细编号
     */
    private String planItemNo;

    /**
     * 税金
     */
    private String taxPrice;

    /**
     * 税率
     */
    private String tax;

    /**
     * 协议经办人id（配送专责），协议商品必传
     */
    private String proDeliveryId;

    /**
     * 协议经办人名字（配送专责），协议商品必传
     */
    private String proDeliveryName;

    /**
     * 协议id
     */
    private String agreementId;

    /**
     * 协议编号
     */
    private String agreementNo;

    /**
     * 协议模式 1：平台协议 2：单位协议
     */
    private String agreementCode;

    /**
     * 协议bo）
     */
    private UocCreateOrderServiceReqAgrBo agrBo;

    /**
     * sku物料id
     */
    private String skuMaterialId;

    /**
     * sku物料编码
     */
    private String skuMaterialCode;

    /**
     * sku外部单品id
     */
    private String skuExtSkuId;

    /**
     * sku品牌id
     */
    private Long skuBrandId;

    /**
     * 单品品牌名称
     */
    private String skuBrandName;

    /**
     * sku明细id
     */
    private String skuItemId;

    /**
     * sku物料名称
     */
    private String skuMaterialName;

    /**
     * sku物料类型名称
     */
    private String skuMaterialTypeName;

    /**
     * sku物料类型id
     */
    private String skuMaterialTypeId;

    /**
     * 型号
     */
    private String model;

    /**
     * 规格
     */
    private String spec;

    /**
     * 材质
     */
    private String texture;

    /**
     * 图号
     */
    private String figure;

    /**
     * 一级类目
     */
    private Long l1catalog;

    /**
     * 二级类目
     */
    private Long l2catalog;

    /**
     * 三级类目
     */
    private Long l3catalog;

    /**
     * 一级类目名称
     */
    private String l1catalogName;

    /**
     * 二级类目名称
     */
    private String l2catalogName;

    /**
     * 三级类目名称
     */
    private String l3catalogName;

    /**
     * 退货时间，空代表不支持
     */
    private Integer rejectAllowDate;

    /**
     * 换货时间，空代表不支持
     */
    private Integer exchangeAllowDate;

    /**
     * 维修时间，空代表不支持
     */
    private Integer maintainAllowDate;

    /**
     * sku单品主图url
     */
    private String skuMainPicUrl;

    /**
     * 商品json字符串，商品查询回原样数据，订单保存，以备未来使用
     */
    private String commJsonStr;

    /**
     * 商品延保信息
     */
    private List<UocCreateOrderServiceReqItemEwBo> ewList;

    /**
     * 订单明细纵向扩展数据
     */
    private List<UocBaseExtParallelBo> saleItemParallelExtList;

    /**
     * 商品编码
     */
    private String commodityCode;

    /**
     * 比选单号
     */
    private String cmpOrderNo;

    /**
     * 比选备注
     */
    private String cmpRemark;

    /**
     * 未比选原因
     */
    private String noCmpReason;
    /**
     * 明细类型:1 商品sku ;2 物资 ;3 项目
     */
    private Integer itemType = 1;

}


