package com.tydic.dyc.oc.service.common.bo;


/**
 * 描述：出参对象工具类
 *
 * @author tgy
 * @date 2021/3/5 16:37
 */
public class UocProRspBoUtil {


    /**
     * 描述:生成一个继承于UocProBaseRspBo的对象
     *
     * @param code   code
     * @param desc   描述
     * @param tClass Class对象
     * @return T
     * @author tgy
     * @date 2021/3/5 16:43
     */
    private static <T extends UocProBaseRspBo> T generate(String code, String desc, Class<T> tClass) {
        try {
            T t = tClass.newInstance();
            t.setRespCode(code);
            t.setRespDesc(desc);
            return t;
        } catch (Exception e) {
            throw new IllegalArgumentException("UocProRspBoUtil创建rsp对象异常：" + e.getMessage());
        }
    }

    /**
     * 描述:生成一个继承于UocProBaseRspBo的失败对象
     *
     * @param code   code
     * @param desc   描述
     * @param tClass Class对象
     * @return T
     * @author tgy
     * @date 2021/3/5 16:43
     */
    public static <T extends UocProBaseRspBo> T failed(String code,String desc,Class<T> tClass) {
        return generate(code, desc, tClass);
    }

    /**
     * 描述:生成默认编码(8888)的失败对象
     * @param desc 描述
     * @param tClass Class对象
     * @return T
     * @author tgy
     * @date 2021/3/5 16:44
     */
    public static <T extends UocProBaseRspBo> T failed(String desc,Class<T> tClass) {
        return generate(UocProRspConstants.RSP_CODE_FAILUR, desc, tClass);
    }



    /**
     * 描述:生成默认描述的成功对象
     *
     * @param tClass Class对象
     * @return T
     * @author tgy
     * @date 2021/3/5 16:40
     */
    public static <T extends UocProBaseRspBo> T success(Class<T> tClass) {
        return success(UocProRspConstants.RSP_DESC_SUCCESS, tClass);
    }


    /**
     * 描述:生成一个指定成功描述的对象
     *
     * @param desc   成功描述
     * @param tClass Class对象
     * @return T
     * @author tgy
     * @date 2021/3/5 16:42
     */
    public static <T extends UocProBaseRspBo> T success(String desc, Class<T> tClass) {
        return generate(UocProRspConstants.RSP_CODE_SUCCESS, desc, tClass);
    }

}


