package com.tydic.dyc.oc.service.shiporder.bo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 标题:UocShipOrderBo
 * 说明:TODO
 * 时间:2022/5/16 16:03
 * 作者:代愿愿
 */
@Data
public class UocShipOrderBo implements Serializable {
    private static final long serialVersionUID = -5377934283386223958L;

    /**
     * 发货单id
     */
    private Long shipOrderId;


    /**
     * 销售单id
     */
    private Long saleOrderId;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 发货单编码
     */
    private String shipOrderNo;

    /**
     * 外部发货单编码
     */
    private String shipOrderNoExt;

    /**
     * 发货单名称
     */
    private String shipOrderName;

    /**
     * 发货单类型
     */
    private Integer shipOrderType;

    /**
     * 发货单状态
     */
    private String shipOrderState;

    /**
     * 供应商编码
     */
    private String supNo;

    /**
     * 是否可以异常变更：1：不允许；其他情况都可以
     */
    private Integer isAbnormal;

    /**
     * 环节编码
     */
    private String procState;

    /**
     * 竣工标志  1 竣工   0 在途
     */
    private Integer finishFlag;
    
    /**
     * 发货单明细
     */
    private List<UocShipOrderItemBo> shipOrderItemBoList;
    
    @DocField("到货金额")
    private BigDecimal arrivePrice;
    
    @DocField("拒收金额")
    private BigDecimal rejectPrice;


}
