package com.tydic.dyc.oc.service.saleorder.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocGetSaleOrderDetailServiceRspShipOrderItemBo
 * 说明:发货单明细信息
 * 时间:2022/2/14 13:46
 * 作者:tkl
 */

@Data
public class UocGetSaleOrderDetailServiceRspShipOrderItemBo implements Serializable {
    private static final long serialVersionUID = -5079885548417364290L;

    /**发货明细id*/
    private Long shipOrderItemId;

    /**订单id*/
    private Long orderId;

    /**销售单id*/
    private Long saleOrderId;

    /**执行明细id*/
    private Long implOrderItemId;

    /**销售明细id*/
    private Long saleOrderItemId;

    /**发货单id*/
    private Long shipOrderId;

    /**明细状态*/
    private String shipItemState;

    /**明细状态翻译*/
    private String shipItemStateStr;

    /**计量单位*/
    private String unitName;

    /**发货数量*/
    private BigDecimal sendCount;

    /**到货数量             供应商到货登记时预留字段*/
    private BigDecimal arriveCount;

    /**拒收数量*/
    private BigDecimal refuseCount;

    /**退货数量*/
    private BigDecimal returnCount;

    /**验收数量*/
    private BigDecimal inspCount;

    /**异常变更在途数量，表示异常供应商确认之前的记录数量*/
    private BigDecimal chngingCount;

    /**创建时间*/
    private Date createTime;

    /**创建工号*/
    private String createOperId;

    /**更新时间*/
    private Date updateTime;

    /**更新工号*/
    private String updateOperId;

    /**备注*/
    private String remark;

    /**明细拓展*/
    private List<UocGetSaleOrderExpandListServiceShipOrderExtParallelBo> itemExtParallelBoList;

    /**超验数量*/
    private BigDecimal inspSuperCount;
}
