package com.tydic.dyc.oc.service.saleorder.bo;

import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelDetailBo;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述: 〈销售单信息〉
 * @author : yuhao
 * @date : 2022/7/20 13:31
 */
@Data
public class UocSaleOrderSingleQryServiceRspDetailBo implements Serializable {

    private static final long serialVersionUID = 5071733204046456067L;

    /**
     * 销售单id
     */
    private Long saleOrderId;
    /**
     * 订单id
     */
    private Long orderId;
    /**
     * 三方信息id
     */
    private Long stakeholderId;
    /**
     * 销售单编码
     */
    private String saleOrderNo;
    /**
     * 外部销售单编码
     */
    private String saleOrderNoExt;
    /**
     * 销售单名称
     */
    private String saleOrderName;
    /**
     * 销售单类型
     */
    private Integer saleOrderType;
    /**
     * 订单状态
     */
    private String saleOrderState;
    /**
     * 销售单单说明
     */
    private String saleOrderDesc;
    /**
     * 订单来源  1 自营单品   2 电商导入   3 协议生成
     */
    private Integer orderSource;
    /**
     * 支付类型
     */
    private Integer payMod;
    /**
     * 支付方式
     */
    private String payType;
    /**
     * 销售金额
     */
    private BigDecimal totalSaleFee;
    /**
     * 采购金额
     */
    private BigDecimal totalPurchaseFee;
    /**
     * 优惠金额
     */
    private BigDecimal totalActShareFee;
    /**
     * 运费
     */
    private BigDecimal totalTransFee;
    /**
     * 实付金额
     */
    private BigDecimal usedFee;
    /**
     * 实付积分
     */
    private BigDecimal usedIntegral;
    /**
     * 协议编号
     */
    private String agreementNo;
    /**
     * 合同编号
     */
    private String contractNo;
    /**
     * 支付状态
     */
    private Integer payState;
    /**
     * 流转状态
     */
    private String procState;
    /**
     * 税率
     */
    private String taxRate;
    /**
     * 竣工标志             1 竣工             0 在途
     */
    private Integer finishFlag;
    /**
     * 租户ID
     */
    private String tenantId;
    /**
     * 送货时间
     */
    private Date sendTime;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 创建工号
     */
    private String createOperId;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 更新工号
     */
    private String updateOperId;
    /**
     * 撤单时间
     */
    private Date cancelTime;
    /**
     * 撤单工号
     */
    private String cancelOperId;
    /**
     * 撤单原因
     */
    private String cancelReason;
    /**
     * 撤单标志:1 已撤单 0 未撤单
     */
    private Integer cancelFlag;
    /**
     * 竣工时间
     */
    private Date finishTime;
    /**
     * 逾期时间
     */
    private Date expTime;
    /**
     * 结算模式 2:撮合 1:贸易
     */
    private Integer modelSettle;
    /**
     * 采购类别  1 物资  2 施工 3 服务
     */
    private Integer purchaseType;
    /**
     * 销售单扩展信息
     */
    private List<UocBaseExtParallelDetailBo> saleOrderExtList;

}


