/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.model.implorder.IUocImplOrderModel;
import com.tydic.dyc.oc.model.implorder.UocImplOrderDo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplItemMapQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderItemQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderMapQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderQryBo;
import com.tydic.dyc.oc.model.implorder.sub.UocImplItemMap;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UocEsSyncImpl
implements IUocEsSync {
    @Autowired
    private IUocImplOrderModel iUocImplOrderModel;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    public static final String UOC_IMPL_ORDER_ITEM = "uocImplOrderItemList";

    @Override
    public String indexName() {
        return this.uocIndexConfig.getImplOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
        rspBo.setObjId(reqBo.getObjId());
        UocImplOrderDo implOrderSubject = this.getImplOrderSubject(reqBo);
        if (Objects.isNull(implOrderSubject)) {
            return rspBo;
        }
        List<UocImplOrderMap> implOrderMapList = this.getImplOrderMapList(reqBo);
        List<UocImplOrderItem> implOrderItemList = this.getImplOrderItemList(reqBo);
        List<UocImplItemMap> implOrderItemMapList = this.getImplOrderItemMapList(reqBo);
        Map<Object, Object> implItemMap = new HashMap();
        if (ObjectUtil.isNotEmpty(implOrderItemMapList)) {
            implItemMap = implOrderItemMapList.stream().collect(Collectors.groupingBy(UocImplItemMap::getImplOrderItemId));
        }
        JSONObject implObj = JSON.parseObject((String)JSON.toJSONString((Object)implOrderSubject));
        if (ObjectUtil.isNotEmpty(implOrderMapList)) {
            implOrderMapList.forEach(each -> implObj.put(each.getFieldCode(), (Object)each.getFieldValue()));
        }
        if (ObjectUtil.isNotEmpty(implOrderItemList)) {
            JSONArray implOrdeItemArray = new JSONArray();
            for (UocImplOrderItem item : implOrderItemList) {
                List uocImplItemMapList;
                JSONObject itemObj = JSON.parseObject((String)JSON.toJSONString((Object)item));
                if (ObjectUtil.isNotEmpty(implItemMap) && implItemMap.containsKey(item.getImplOrderItemId()) && ObjectUtil.isNotEmpty((Object)(uocImplItemMapList = (List)implItemMap.get(item.getImplOrderItemId())))) {
                    uocImplItemMapList.forEach(each -> itemObj.put(each.getFieldCode(), (Object)each.getFieldValue()));
                }
                implOrdeItemArray.add((Object)itemObj);
            }
            implObj.put(UOC_IMPL_ORDER_ITEM, (Object)implOrdeItemArray);
        }
        rspBo.setJsonObj(implObj);
        return rspBo;
    }

    private UocImplOrderDo getImplOrderSubject(IUocEsSyncQryReqBo reqBo) {
        UocImplOrderQryBo uocImplOrderQryBo = new UocImplOrderQryBo();
        uocImplOrderQryBo.setOrderId(reqBo.getOrderId());
        uocImplOrderQryBo.setImplOrderId(reqBo.getObjId());
        return this.iUocImplOrderModel.getImplOrderMain(uocImplOrderQryBo);
    }

    private List<UocImplOrderMap> getImplOrderMapList(IUocEsSyncQryReqBo reqBo) {
        UocImplOrderMapQryBo uocImplOrderMapQryBo = new UocImplOrderMapQryBo();
        uocImplOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocImplOrderMapQryBo.setImplOrderId(reqBo.getObjId());
        return this.iUocImplOrderModel.getImplOrderMapList(uocImplOrderMapQryBo);
    }

    private List<UocImplOrderItem> getImplOrderItemList(IUocEsSyncQryReqBo reqBo) {
        UocImplOrderItemQryBo uocImplOrderItemQryBo = new UocImplOrderItemQryBo();
        uocImplOrderItemQryBo.setImplOrderId(reqBo.getObjId());
        uocImplOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocImplOrderModel.getListImplOrderItem(uocImplOrderItemQryBo).getUocImplOrderItemList();
    }

    private List<UocImplItemMap> getImplOrderItemMapList(IUocEsSyncQryReqBo reqBo) {
        UocImplItemMapQryBo uocImplItemMapQryBo = new UocImplItemMapQryBo();
        uocImplItemMapQryBo.setImplOrderId(reqBo.getObjId());
        uocImplItemMapQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocImplOrderModel.getImpOrderItemMapList(uocImplItemMapQryBo);
    }
}

