/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.implorder.IUocImplOrderModel;
import com.tydic.dyc.oc.model.implorder.UocImplOrderDo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UocEsSyncShip
implements IUocEsSync {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncShip.class);
    private static final String SHIP_ORDER_ITEM_KEY = "shipOrderItemBoList";
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocImplOrderModel iUocImplOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public String indexName() {
        return this.uocIndexConfig.getShipOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
        iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
        UocShipOrderDo uocShipOrderDo = this.getShipOrderMain(reqBo);
        if (null == uocShipOrderDo) {
            return iUocEsSyncQryRspBo;
        }
        JSONObject shipOrder = JSON.parseObject((String)JSON.toJSONString((Object)uocShipOrderDo));
        if (!CollectionUtils.isEmpty(uocShipOrderDo.getExtParallelBoList())) {
            uocShipOrderDo.getExtParallelBoList().forEach(uocShipOrderMap -> shipOrder.put(uocShipOrderMap.getFieldCode(), (Object)uocShipOrderMap.getFieldValue()));
        }
        UocShipOrderDo uocShipOrderDoItem = this.getShipOrderItem(uocShipOrderDo);
        uocShipOrderDo.setShipOrderItemBoList(uocShipOrderDoItem.getShipOrderItemBoList());
        if (!CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
            Map<Long, UocSaleOrderItem> saleItemMap = this.getSaleItem(uocShipOrderDo);
            JSONArray shipOrdeItemArray = new JSONArray();
            BigDecimal[] saleFee = new BigDecimal[]{BigDecimal.ZERO};
            BigDecimal[] purFee = new BigDecimal[]{BigDecimal.ZERO};
            uocShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
                JSONObject shipOrderItemJson = JSON.parseObject((String)JSON.toJSONString((Object)uocShipOrderItem));
                if (!CollectionUtils.isEmpty(uocShipOrderItem.getItemExtParallelBoList())) {
                    uocShipOrderItem.getItemExtParallelBoList().forEach(uocShipItemMap -> shipOrderItemJson.put(uocShipItemMap.getFieldCode(), (Object)uocShipItemMap.getFieldValue()));
                }
                this.putSaleItem(shipOrderItemJson, (UocSaleOrderItem)saleItemMap.get(uocShipOrderItem.getSaleOrderItemId()), (UocShipOrderItem)uocShipOrderItem);
                saleFee[0] = saleFee[0].add(shipOrderItemJson.getBigDecimal("purFee"));
                purFee[0] = purFee[0].add(shipOrderItemJson.getBigDecimal("saleFee"));
                shipOrdeItemArray.add((Object)shipOrderItemJson);
            });
            shipOrder.put(SHIP_ORDER_ITEM_KEY, (Object)shipOrdeItemArray);
            shipOrder.put("saleFee", (Object)saleFee[0]);
            shipOrder.put("purFee", (Object)purFee[0]);
        }
        this.putSaleOrder(uocShipOrderDo, shipOrder);
        this.putImplOrder(uocShipOrderDo, shipOrder);
        this.putTask(reqBo, shipOrder);
        this.putStr(shipOrder, uocShipOrderDo);
        iUocEsSyncQryRspBo.setJsonObj(shipOrder);
        log.info("\u53d1\u8d27\u5355ES\u6570\u636e:{}", (Object)shipOrder.toJSONString());
        return iUocEsSyncQryRspBo;
    }

    private void putImplOrder(UocShipOrderDo uocShipOrderDo, JSONObject shipOrder) {
        UocImplOrderDo uocImplOrderDo = this.getImplOrderMain(uocShipOrderDo);
        shipOrder.put("implOrderNo", (Object)(null == uocImplOrderDo ? "" : uocImplOrderDo.getImplOrderNo()));
    }

    private void putTask(IUocEsSyncQryReqBo reqBo, JSONObject shipOrder) {
        UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = this.getProcInst(reqBo, false);
        shipOrder.put("busiTaskList", (Object)busiProcInst.getTaskList());
    }

    private void putSaleOrder(UocShipOrderDo uocShipOrderDo, JSONObject shipOrder) {
        UocSaleOrderDo uocSaleOrderDo = this.getSaleOrder(uocShipOrderDo);
        if (null != uocSaleOrderDo) {
            shipOrder.put("saleOrderNo", (Object)uocSaleOrderDo.getSaleOrderNo());
            UocSaleStakeholder stakeholder = uocSaleOrderDo.getStakeholder();
            if (null != stakeholder) {
                shipOrder.put("purCompanyId", (Object)stakeholder.getPurCompanyId());
                shipOrder.put("purCompanyName", (Object)stakeholder.getPurCompanyName());
                shipOrder.put("purCompanyNo", (Object)stakeholder.getPurCompanyNo());
                shipOrder.put("purOrgId", (Object)stakeholder.getPurOrgId());
                shipOrder.put("purOrgName", (Object)stakeholder.getPurOrgName());
                shipOrder.put("purOrgNo", (Object)stakeholder.getPurOrgNo());
            }
        }
    }

    private void putStr(JSONObject shipOrder, UocShipOrderDo uocShipOrderDo) {
        Map<String, Map<String, String>> dicMap = this.getDic();
        Map<String, String> stateMap = dicMap.get("SHIP_ORDER_STATE");
        shipOrder.put("shipOrderStateStr", (Object)(ObjectUtil.isNotEmpty(stateMap) ? stateMap.get(uocShipOrderDo.getShipOrderState()) : ""));
    }

    private void putSaleItem(JSONObject shipOrderItemJson, UocSaleOrderItem uocSaleOrderItem, UocShipOrderItem uocShipOrderItem) {
        if (null != uocSaleOrderItem) {
            shipOrderItemJson.put("commodityId", (Object)uocSaleOrderItem.getSkuName());
            shipOrderItemJson.put("commodityName", (Object)uocSaleOrderItem.getSkuName());
            shipOrderItemJson.put("skuName", (Object)uocSaleOrderItem.getSkuName());
            shipOrderItemJson.put("skuId", (Object)uocSaleOrderItem.getSkuId());
            shipOrderItemJson.put("skuMaterialId", (Object)uocSaleOrderItem.getSkuName());
            shipOrderItemJson.put("skuMainPicUrl", (Object)uocSaleOrderItem.getSkuName());
            shipOrderItemJson.put("skuMaterialName", (Object)uocSaleOrderItem.getSkuMaterialName());
            shipOrderItemJson.put("skuMaterialTypeId", (Object)uocSaleOrderItem.getSkuMaterialTypeId());
            shipOrderItemJson.put("skuMaterialTypeName", (Object)uocSaleOrderItem.getSkuMaterialTypeName());
            shipOrderItemJson.put("model", (Object)uocSaleOrderItem.getModel());
            shipOrderItemJson.put("spec", (Object)uocSaleOrderItem.getSpec());
            shipOrderItemJson.put("tax", (Object)uocSaleOrderItem.getTax());
            shipOrderItemJson.put("taxId", (Object)uocSaleOrderItem.getTaxId());
            shipOrderItemJson.put("taxPrice", (Object)uocSaleOrderItem.getTaxPrice());
            shipOrderItemJson.put("l1Catalog", (Object)uocSaleOrderItem.getL1Catalog());
            shipOrderItemJson.put("l1CatalogName", (Object)uocSaleOrderItem.getL1CatalogName());
            shipOrderItemJson.put("l2Catalog", (Object)uocSaleOrderItem.getL2Catalog());
            shipOrderItemJson.put("l2CatalogName", (Object)uocSaleOrderItem.getL2CatalogName());
            shipOrderItemJson.put("l3Catalog", (Object)uocSaleOrderItem.getL3Catalog());
            shipOrderItemJson.put("l3CatalogName", (Object)uocSaleOrderItem.getL3CatalogName());
            shipOrderItemJson.put("salePrice", (Object)uocSaleOrderItem.getSalePrice());
            shipOrderItemJson.put("saleFee", (Object)uocSaleOrderItem.getSalePrice().multiply(uocShipOrderItem.getSendCount()));
            shipOrderItemJson.put("purFee", (Object)uocSaleOrderItem.getPurchasePrice().multiply(uocShipOrderItem.getSendCount()));
            shipOrderItemJson.put("purPrice", (Object)uocSaleOrderItem.getPurchasePrice());
        }
    }

    private Map<Long, UocSaleOrderItem> getSaleItem(UocShipOrderDo uocShipOrderDo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            return saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        }
        return new HashMap<Long, UocSaleOrderItem>();
    }

    private UocSaleOrderDo getSaleOrder(UocShipOrderDo uocShipOrderDo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        uocSaleOrderQryBo.setOrderId(uocShipOrderDo.getOrderId());
        return this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private UocShipOrderDo getShipOrderItem(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocShipOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        return this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
    }

    private UocShipOrderDo getShipOrderMain(IUocEsSyncQryReqBo reqBo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setShipOrderId(reqBo.getObjId());
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
    }

    private UocImplOrderDo getImplOrderMain(UocShipOrderDo uocShipOrderDo) {
        UocImplOrderQryBo uocImplOrderQryBo = new UocImplOrderQryBo();
        uocImplOrderQryBo.setImplOrderId(uocShipOrderDo.getImplOrderId());
        uocImplOrderQryBo.setOrderId(uocShipOrderDo.getOrderId());
        return this.iUocImplOrderModel.getImplOrderMain(uocImplOrderQryBo);
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("SHIP_ORDER_STATE");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    private List<UocGetSaleOrderDetailServiceRspTaskBo> getBusiTaskInstList(IUocEsSyncQryReqBo reqBo) {
        List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<UocGetSaleOrderDetailServiceRspTaskBo>();
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(reqBo.getOrderId());
        taskInstQryBo.setObjId(reqBo.getObjId());
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        taskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
            taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
            taskBoList.forEach(each -> {
                UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                taskDealQryBo.setTaskInstId(each.getTaskInstId());
                taskDealQryBo.setObjId(each.getObjId());
                taskDealQryBo.setObjType(each.getObjType());
                List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
            });
        }
        return taskBoList;
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(IUocEsSyncQryReqBo reqBo, Boolean isAudit) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit.booleanValue()) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjId(reqBo.getObjId());
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        }
        procInstQryBo.setOrderId(reqBo.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            taskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
                });
                procInst.setProcState(uocOrderTaskInsts.get(0).getProcState());
                procInst.setTaskId(uocOrderTaskInsts.get(0).getTaskInstId());
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }
}

