/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.model.chngorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog;
import com.tydic.dyc.oc.repository.UocChngOrderRepository;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocChngOrderModelImpl
implements IUocChngOrderModel {
    @Autowired
    private UocChngOrderRepository uocChngOrderRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @Override
    public void createChngOrder(UocChngOrderDo uocChngOrderDo) {
        this.val(uocChngOrderDo);
        this.uocChngOrderRepository.createChngOrder(uocChngOrderDo);
        if (!CollectionUtils.isEmpty(uocChngOrderDo.getOrderAccessoryBoList())) {
            this.uocCommonRepository.addBatchOrderAccessory(uocChngOrderDo.getOrderAccessoryBoList());
        }
    }

    @Override
    public void modifyBatchChngOrderState(List<UocChngOrderDo> uocChngOrderDoList) {
        if (CollectionUtils.isEmpty(uocChngOrderDoList)) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        uocChngOrderDoList.forEach(uocChngOrderDo -> {
            if (null == uocChngOrderDo) {
                throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
            }
            if (null == uocChngOrderDo.getOrderId()) {
                throw new BaseBusinessException("102001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
            }
            if (null == uocChngOrderDo.getChngOrderId()) {
                throw new BaseBusinessException("102001", "\u5165\u53c2\u53d8\u66f4\u5355ID\u4e3a\u7a7a");
            }
            if (null == uocChngOrderDo.getChngOrderState()) {
                throw new BaseBusinessException("102001", "\u5165\u53c2\u53d8\u66f4\u5355\u72b6\u6001\u4e3a\u7a7a");
            }
        });
        this.uocChngOrderRepository.modifyBatchChngOrderState(uocChngOrderDoList);
    }

    @Override
    public List<UocChngOrderItemObj> getListChngOrderItemObj(UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo) {
        return this.uocChngOrderRepository.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
    }

    @Override
    public List<UocChngOrderDo> getListChngOrder(UocChngOrderQryBo uocChngOrderQryBo) {
        return this.uocChngOrderRepository.getListChngOrder(uocChngOrderQryBo);
    }

    @Override
    public UocChngOrderDo getChngOrderNo(UocChngOrderQryBo uocChngOrderQryBo) {
        if (null == uocChngOrderQryBo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == uocChngOrderQryBo.getOrderSource()) {
            throw new BaseBusinessException("102001", "\u6765\u6e90\u4e0d\u4e3a\u7a7a");
        }
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter("UOC");
        if (UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL.equals(uocChngOrderQryBo.getBusiType())) {
            getBo.setEncodedRuleCode("ORDER_CANCEL_NO_" + uocChngOrderQryBo.getOrderSource());
        }
        if (UocConstant.BUSI_TYPE.NUM.equals(uocChngOrderQryBo.getBusiType())) {
            getBo.setEncodedRuleCode("ORDER_ABNORMAL_NO_" + uocChngOrderQryBo.getOrderSource());
        }
        getBo.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerial = this.encodedSerialGetService.getEncodedSerial(getBo);
        if (CollectionUtils.isEmpty((Collection)encodedSerial.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerial.getSerialNoList().get(0)))) {
            throw new BaseBusinessException("101006", "\u83b7\u53d6\u5f02\u5e38\u5355\u7f16\u7801\u4e3a\u7a7a");
        }
        uocChngOrderDo.setChngOrderNo((String)encodedSerial.getSerialNoList().get(0));
        return uocChngOrderDo;
    }

    @Override
    public void updateShipStatusAndProCode(UocChngOrderDo uocChngOrderDo) {
        UocChngOrderQryBo qryBo = new UocChngOrderQryBo();
        qryBo.setOrderId(uocChngOrderDo.getOrderId());
        qryBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
        UocChngOrderDo chngOrderDo = this.uocChngOrderRepository.getChngOrder(qryBo);
        if (ObjectUtil.isEmpty((Object)chngOrderDo)) {
            throw new BaseBusinessException("102003", "\u8be5\u53d8\u66f4\u5355" + uocChngOrderDo.getChngOrderId() + "\u4e0d\u5b58\u5728");
        }
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(uocChngOrderDo.getChngOrderId());
        uocOrderStateChgLog.setOrderId(uocChngOrderDo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
        uocOrderStateChgLog.setOldState(chngOrderDo.getChngOrderState());
        uocOrderStateChgLog.setNewState(uocChngOrderDo.getChngOrderState());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(uocChngOrderDo.getUpdateOperId());
        this.uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
        this.uocChngOrderRepository.updateChngStatusAndProCode(uocChngOrderDo);
    }

    @Override
    public void updateChngOrderMain(UocChngOrderDo uocChngOrderDo) {
        this.val(uocChngOrderDo);
        if (null == uocChngOrderDo.getChngOrderId()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u53d8\u66f4\u5355ID\u4e3a\u7a7a");
        }
        this.uocChngOrderRepository.updateChngOrderMain(uocChngOrderDo);
    }

    @Override
    public UocChngOrderDo getChngOrder(UocChngOrderQryBo uocChngOrderQryBo) {
        return this.uocChngOrderRepository.getChngOrder(uocChngOrderQryBo);
    }

    @Override
    public List<UocChngOrderObj> getListChngOrderObj(UocChngOrderObjQryBo uocChngOrderObjQryBo) {
        return this.uocChngOrderRepository.getListChngOrderObj(uocChngOrderObjQryBo);
    }

    private void val(UocChngOrderDo uocChngOrderDo) {
        if (null == uocChngOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == uocChngOrderDo.getOrderId()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
    }
}

