/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.model.saleorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleItemMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.UocSaleOrderRepository;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocSaleOrderModelImpl
implements IUocSaleOrderModel {
    private static final Logger log = LoggerFactory.getLogger(UocSaleOrderModelImpl.class);
    @Autowired
    private UocSaleOrderRepository uocSaleOrderRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @Override
    public UocSaleOrderDo createSaleOrder(UocSaleOrderDo saleOrderDo) {
        List<UocOrderAccessory> list;
        List<UocSaleOrderPayConf> saleOrderPayConfList;
        this.validateCreateArg(saleOrderDo);
        saleOrderDo.setSaleOrderNo(this.genRequestCode(saleOrderDo));
        saleOrderDo.setSaleOrderId(IdUtil.nextId());
        saleOrderDo.setCreateTime(new Date());
        saleOrderDo.setSaleOrderState("XS_CJ_CJ");
        List<UocSaleOrderMap> saleOrderMapList = saleOrderDo.getSaleOrderMapList();
        if (ObjectUtil.isNotEmpty(saleOrderMapList)) {
            for (UocSaleOrderMap uocSaleOrderMap : saleOrderMapList) {
                uocSaleOrderMap.setId(IdUtil.nextId());
                uocSaleOrderMap.setSaleOrderId(saleOrderDo.getSaleOrderId());
                uocSaleOrderMap.setCreateOperId(saleOrderDo.getCreateOperId());
                uocSaleOrderMap.setCreateTime(saleOrderDo.getCreateTime());
            }
        }
        if (ObjectUtil.isNotEmpty(saleOrderPayConfList = saleOrderDo.getSaleOrderPayConfList())) {
            for (UocSaleOrderPayConf payConf : saleOrderPayConfList) {
                payConf.setId(IdUtil.nextId());
                payConf.setOrderId(saleOrderDo.getOrderId());
                payConf.setCreateTime(saleOrderDo.getCreateTime());
                payConf.setCreateOperId(saleOrderDo.getCreateOperId());
                payConf.setSaleOrderId(saleOrderDo.getSaleOrderId());
            }
        }
        if (ObjectUtil.isNotEmpty(list = saleOrderDo.getSaleOrderAccessoryList())) {
            for (UocOrderAccessory accessory : list) {
                accessory.setId(IdUtil.nextId());
                accessory.setObjId(saleOrderDo.getSaleOrderId());
                accessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                accessory.setOrderId(saleOrderDo.getOrderId());
                accessory.setCreateTime(saleOrderDo.getCreateTime());
                accessory.setCreateOperId(saleOrderDo.getCreateOperId());
            }
        }
        this.setSaleItems(saleOrderDo);
        return this.uocSaleOrderRepository.createSaleOrder(saleOrderDo);
    }

    private void validateCreateArg(UocSaleOrderDo saleOrderDo) {
        if (ObjectUtil.isEmpty((Object)saleOrderDo)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void setSaleItems(UocSaleOrderDo saleOrderDo) {
        List<UocSaleOrderItem> saleOrderItems = saleOrderDo.getSaleOrderItems();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            saleOrderItem.setOrderId(saleOrderDo.getOrderId());
            saleOrderItem.setSaleOrderItemId(IdUtil.nextId());
            saleOrderItem.setSaleOrderId(saleOrderDo.getSaleOrderId());
            saleOrderItem.setCreateOperId(saleOrderDo.getCreateOperId());
            saleOrderItem.setCreateTime(saleOrderDo.getCreateTime());
            List<UocSaleItemMap> saleItemMapList = saleOrderItem.getSaleItemMapList();
            if (!ObjectUtil.isNotEmpty(saleItemMapList)) continue;
            for (UocSaleItemMap uocSaleItemMap : saleItemMapList) {
                uocSaleItemMap.setId(IdUtil.nextId());
                uocSaleItemMap.setSaleOrderItemId(saleOrderItem.getOrderItemId());
                uocSaleItemMap.setSaleOrderId(saleOrderDo.getSaleOrderId());
                uocSaleItemMap.setOrderId(saleOrderDo.getOrderId());
                uocSaleItemMap.setCreateTime(saleOrderDo.getCreateTime());
                uocSaleItemMap.setCreateOperId(saleOrderDo.getCreateOperId());
            }
        }
    }

    @Override
    public List<UocSaleOrderItem> getSaleOrderItemList(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        if (null == uocSaleOrderItemQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    @Override
    public List<UocSaleItemMap> getSaleOrderItemMapList(UocSaleItemMapQryBo uocSaleItemMapQryBo) {
        if (null == uocSaleItemMapQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderItemMapList(uocSaleItemMapQryBo);
    }

    @Override
    public UocSaleOrderDo qrySaleOrder(UocSaleOrderQryBo uocSaleOrderQryBo) {
        if (null == uocSaleOrderQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.qrySaleOrder(uocSaleOrderQryBo);
    }

    @Override
    public UocSaleOrderDo getSaleOrderAccessoryList(UocOrderAccessoryQryBo uocOrderAccessoryQryBo) {
        if (null == uocOrderAccessoryQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderAccessoryList(uocOrderAccessoryQryBo);
    }

    @Override
    public List<UocSaleOrderPayConf> getSaleOrderPayConfList(UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo) {
        return this.uocSaleOrderRepository.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
    }

    @Override
    public List<UocSaleOrderMap> getSaleOrderExpandList(UocSaleOrderMapQryBo uocSaleOrderMapQryBo) {
        if (null == uocSaleOrderMapQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderExpandList(uocSaleOrderMapQryBo);
    }

    @Override
    public UocSaleOrderDo qryListSaleOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        return this.uocSaleOrderRepository.qryListSaleOrderItem(uocSaleOrderItemQryBo);
    }

    @Override
    public void modifySaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderDo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo);
    }

    @Override
    public UocSaleOrderDo updateSaleStatusAndProCode(UocSaleOrderDo reqBo) {
        this.validateUpdateSaleOrderArg(reqBo);
        UocSaleOrderQryBo qryBo = new UocSaleOrderQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.qrySaleOrder(qryBo);
        if (ObjectUtil.isEmpty((Object)uocSaleOrderDo)) {
            throw new BaseBusinessException("102001", "\u8be5\u9500\u552e\u5355" + reqBo.getSaleOrderId() + "\u4e0d\u5b58\u5728");
        }
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(reqBo.getSaleOrderId());
        uocOrderStateChgLog.setOrderId(reqBo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderStateChgLog.setOldState(uocSaleOrderDo.getSaleOrderState());
        uocOrderStateChgLog.setNewState(reqBo.getSaleOrderState());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(reqBo.getUpdateOperId());
        this.uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
        return this.uocSaleOrderRepository.updateSaleStatusAndProCode(reqBo);
    }

    private void validateUpdateSaleOrderArg(UocSaleOrderDo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocUpdateSaleOrderStateServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUpdateOperId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u66f4\u65b0\u4ebaid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u8ba2\u5355id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u9500\u552e\u5355id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderState())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u9500\u552e\u5355\u72b6\u6001\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void updateProcTaskInstToFinished(List<UocOrderTaskInst> uocOrderTaskInstList) {
        this.uocCommonRepository.updateToFinished(uocOrderTaskInstList);
    }

    @Override
    public void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList) {
        Date createTime = new Date();
        if (ObjectUtil.isNotEmpty(saveTaskList)) {
            for (UocOrderTaskInst uocOrderTaskInst : saveTaskList) {
                uocOrderTaskInst.setCreateTime(createTime);
            }
            this.uocCommonRepository.saveProcTaskInst(saveTaskList);
        }
    }

    @Override
    public List<UocSaleOrderDo> qrySaleOrderList(UocSaleOrderDo qryDo) {
        if (null == qryDo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.qrySaleOrderList(qryDo);
    }

    @Override
    public UocOrderProcInst createProInst(UocOrderProcInst inst) {
        inst.setId(IdUtil.nextId());
        inst.setCreateTime(new Date());
        return this.uocCommonRepository.createProInst(inst);
    }

    @Override
    public List<UocOrderProcInst> qryProcInsList(UocOrderProcInst inst) {
        return this.uocCommonRepository.qryProcInsList(inst);
    }

    @Override
    public List<UocOrderTaskInst> qryTaskInstList(UocOrderTaskInst taskInst) {
        return this.uocCommonRepository.qryTaskInstList(taskInst);
    }

    @Override
    public void saveOrderTaskDealList(List<UocOrderTaskDeal> dealList) {
        this.uocCommonRepository.saveOrderTaskDealList(dealList);
    }

    @Override
    public UocSaleOrderDo getSaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderMain(uocSaleOrderDo);
    }

    @Override
    public UocSaleStakeholder qrySaleOrderStakeholder(UocSaleStakeholderQryBo qryBo) {
        return this.uocSaleOrderRepository.qrySaleOrderStakeholder(qryBo);
    }

    private String genRequestCode(UocSaleOrderDo saleOrderDo) {
        String requestCode = "";
        CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter("UOC");
        getBo.setEncodedRuleCode("SALE_ORDER_NO_" + saleOrderDo.getOrderSource());
        getBo.setOrgType("-1");
        log.info("\u83b7\u53d6\u7f16\u53f7\u5165\u53c2\uff1a" + JSON.toJSONString((Object)getBo));
        try {
            CfcEncodedSerialGetServiceRspBO encodedSerial = this.encodedSerialGetService.getEncodedSerial(getBo);
            log.info("\u83b7\u53d6\u7f16\u53f7\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)encodedSerial));
            requestCode = (String)encodedSerial.getSerialNoList().get(0);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u7f16\u53f7\u5f02\u5e38\uff1a" + e.getMessage());
            throw new BaseBusinessException("103001", "\u83b7\u53d6\u7f16\u53f7\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        return requestCode;
    }
}

