/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocElasticsearchUtil;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.implorder.IUocImplOrderModel;
import com.tydic.dyc.oc.model.implorder.UocImplOrderDo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderQryBo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.UocEsSyncService;
import com.tydic.dyc.oc.service.domainservice.bo.UocEsSyncReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEsSyncRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocEsSyncService"})
public class UocEsSyncServiceImpl
implements UocEsSyncService {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncServiceImpl.class);
    @Autowired
    private UocEsSyncManager uocEsSyncManager;
    @Autowired
    private IUocImplOrderModel iUocImplOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private UocElasticsearchUtil uocElasticsearchUtil;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"sync"})
    public UocEsSyncRspBo sync(@RequestBody UocEsSyncReqBo reqBo) {
        this.val(reqBo);
        if (!reqBo.getAll().booleanValue()) {
            UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(reqBo, UocEsSyncManagerSaveDataReqBo.class);
            this.uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            return UocRu.success(UocEsSyncRspBo.class);
        }
        if (this.uocIndexConfig.getSaleOrderIndex().equals(reqBo.getIndexName())) {
            this.delIdx(this.uocIndexConfig.getSaleOrderIndex());
            this.syncSale();
        }
        if (this.uocIndexConfig.getImplOrderIndex().equals(reqBo.getIndexName())) {
            this.delIdx(this.uocIndexConfig.getImplOrderIndex());
            this.syncImpl();
        }
        if (this.uocIndexConfig.getShipOrderIndex().equals(reqBo.getIndexName())) {
            this.delIdx(this.uocIndexConfig.getShipOrderIndex());
            this.syncShip();
        }
        if (this.uocIndexConfig.getInspOrderIndex().equals(reqBo.getIndexName())) {
            this.delIdx(this.uocIndexConfig.getInspOrderIndex());
            this.syncInsp();
        }
        if (this.uocIndexConfig.getChngOrderIndex().equals(reqBo.getIndexName())) {
            this.delIdx(this.uocIndexConfig.getChngOrderIndex());
            this.syncChng();
        }
        return UocRu.success(UocEsSyncRspBo.class);
    }

    private void delIdx(String idx) {
        block2: {
            try {
                this.uocElasticsearchUtil.deleteIndex(idx);
            }
            catch (Exception e) {
                String eCause = JSON.toJSONString((Object)e.getCause());
                log.error(eCause);
                if (!eCause.contains("index_not_found_exception")) break block2;
                log.info("\u7d22\u5f15\u4e0d\u5b58\u5728");
            }
        }
    }

    private void val(UocEsSyncReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!reqBo.getAll().booleanValue()) {
            if (null == reqBo.getObjId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61ID\u4e3a\u7a7a");
            }
            if (null == reqBo.getOrderId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBo.getIndexName())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u7d22\u5f15\u540d\u4e3a\u7a7a");
            }
        }
    }

    private void syncSale() {
        List<UocSaleOrderDo> listOrder = this.getListSaleOrder();
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(uocSaleOrderDo -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocSaleOrderDo, UocEsSyncManagerSaveDataReqBo.class);
                uocEsSyncManagerSaveDataReqBo.setObjId(uocSaleOrderDo.getSaleOrderId());
                uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
                this.uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private void syncImpl() {
        List<UocImplOrderDo> listOrder = this.getListImplOrder();
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(uocImplOrderDo -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocImplOrderDo, UocEsSyncManagerSaveDataReqBo.class);
                uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getImplOrderIndex());
                uocEsSyncManagerSaveDataReqBo.setObjId(uocImplOrderDo.getImplOrderId());
                this.uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private void syncShip() {
        List<UocShipOrderDo> listOrder = this.getListShipOrder();
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(uocShipOrderDo -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocShipOrderDo, UocEsSyncManagerSaveDataReqBo.class);
                uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
                uocEsSyncManagerSaveDataReqBo.setObjId(uocShipOrderDo.getShipOrderId());
                this.uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private void syncInsp() {
        List<UocInspOrderDo> listOrder = this.getListInspOrder();
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(uocInspOrderDo -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocInspOrderDo, UocEsSyncManagerSaveDataReqBo.class);
                uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getInspOrderIndex());
                uocEsSyncManagerSaveDataReqBo.setObjId(uocInspOrderDo.getInspOrderId());
                this.uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private void syncChng() {
        List<UocChngOrderDo> listOrder = this.getListChngOrder();
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(uocChngOrderDo -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocChngOrderDo, UocEsSyncManagerSaveDataReqBo.class);
                uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getChngOrderIndex());
                uocEsSyncManagerSaveDataReqBo.setObjId(uocChngOrderDo.getChngOrderId());
                this.uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private List<UocSaleOrderDo> getListSaleOrder() {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        return this.iUocSaleOrderModel.qrySaleOrderList(uocSaleOrderDo);
    }

    private List<UocImplOrderDo> getListImplOrder() {
        UocImplOrderQryBo uocImplOrderQryBo = new UocImplOrderQryBo();
        return this.iUocImplOrderModel.getListImplOrder(uocImplOrderQryBo);
    }

    private List<UocShipOrderDo> getListShipOrder() {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        return this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }

    private List<UocInspOrderDo> getListInspOrder() {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        return this.iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
    }

    private List<UocChngOrderDo> getListChngOrder() {
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        return this.iUocChngOrderModel.getListChngOrder(uocChngOrderQryBo);
    }
}

