/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.implorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.implorder.IUocImplOrderModel;
import com.tydic.dyc.oc.model.implorder.UocImplOrderDo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplItemMapQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderItemQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderMapQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderQryBo;
import com.tydic.dyc.oc.model.implorder.sub.UocImplItemMap;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderMap;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryDetailBo;
import com.tydic.dyc.oc.service.implorder.UocGetImplOrderDetailsService;
import com.tydic.dyc.oc.service.implorder.bo.UocGetImplOrderDetailsServiceReqBo;
import com.tydic.dyc.oc.service.implorder.bo.UocGetImplOrderDetailsServiceRspBo;
import com.tydic.dyc.oc.service.implorder.bo.UocGetImplOrderDetailsServiceRspExtBo;
import com.tydic.dyc.oc.service.implorder.bo.UocGetImplOrderDetailsServiceRspItemBo;
import com.tydic.dyc.oc.service.implorder.bo.UocGetImplOrderDetailsServiceRspItemExtBo;
import com.tydic.dyc.oc.service.implorder.bo.UocGetImplOrderDetailsServiceRspReceiverAddressBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.implorder.UocGetImplOrderDetailsService"})
public class UocGetImplOrderDetailsServiceImpl
implements UocGetImplOrderDetailsService {
    @Autowired
    private IUocImplOrderModel iUocImplOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @PostMapping(value={"getImplOrderDetails"})
    public UocGetImplOrderDetailsServiceRspBo getImplOrderDetails(@RequestBody UocGetImplOrderDetailsServiceReqBo reqBo) {
        this.validateParam(reqBo);
        UocGetImplOrderDetailsServiceRspReceiverAddressBo receiverAddressBo = new UocGetImplOrderDetailsServiceRspReceiverAddressBo();
        ArrayList<UocGetImplOrderDetailsServiceRspItemBo> implOrderDetailsServiceRspBoList = new ArrayList<UocGetImplOrderDetailsServiceRspItemBo>();
        List<Object> implOrderDetailsServiceRspExtBoList = new ArrayList();
        ArrayList<UocBaseOrderAccessoryTypeDetailBo> accessoryDetailBoList = new ArrayList<UocBaseOrderAccessoryTypeDetailBo>();
        UocImplOrderDo implOrder = this.iUocImplOrderModel.getImplOrderMain(UocRu.js(reqBo, UocImplOrderQryBo.class));
        if (ObjectUtil.isNull((Object)implOrder)) {
            return UocRu.success(UocGetImplOrderDetailsServiceRspBo.class);
        }
        UocGetImplOrderDetailsServiceRspBo rspBo = UocRu.js(implOrder, UocGetImplOrderDetailsServiceRspBo.class);
        UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
        relaQryBo.setOrderId(implOrder.getOrderId());
        UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        rspBo.setReceiverAddressBo(UocRu.js(uocOrdLogisticsRela, UocGetImplOrderDetailsServiceRspReceiverAddressBo.class));
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
        uocOrderAccessoryQryBo.setObjId(implOrder.getImplOrderId());
        uocOrderAccessoryQryBo.setOrderId(implOrder.getOrderId());
        uocOrderAccessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.IMPL);
        List<UocOrderAccessory> saleOrderAccessoryList = this.iUocOrderModel.getOrderAccessoryList(uocOrderAccessoryQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderAccessoryList)) {
            List<UocBaseOrderAccessoryDetailBo> accessoryDetailBos = UocRu.jsl(saleOrderAccessoryList, UocBaseOrderAccessoryDetailBo.class);
            Map<Integer, List<UocBaseOrderAccessoryDetailBo>> accessoryDetailMap = accessoryDetailBos.stream().collect(Collectors.groupingBy(UocBaseOrderAccessoryDetailBo::getAttachmentType));
            Iterator<Integer> iterator = accessoryDetailMap.keySet().iterator();
            while (iterator.hasNext()) {
                UocBaseOrderAccessoryTypeDetailBo accessoryTypeDetailBo = new UocBaseOrderAccessoryTypeDetailBo();
                Integer attachmentType = iterator.next();
                accessoryTypeDetailBo.setAttachmentType(attachmentType);
                accessoryTypeDetailBo.setAttchList(accessoryDetailMap.get(attachmentType));
                accessoryDetailBoList.add(accessoryTypeDetailBo);
            }
        }
        rspBo.setAccessoryDetailBoList(accessoryDetailBoList);
        List<UocImplOrderMap> implOrderMapList = this.iUocImplOrderModel.getImplOrderMapList(UocRu.js(reqBo, UocImplOrderMapQryBo.class));
        if (ObjectUtil.isNotEmpty(implOrderMapList)) {
            implOrderDetailsServiceRspExtBoList = UocRu.jsl(implOrderMapList, UocGetImplOrderDetailsServiceRspExtBo.class);
        }
        rspBo.setImplOrderDetailsServiceRspExtBoList(implOrderDetailsServiceRspExtBoList);
        UocImplOrderItemQryBo uocImplOrderItemQryBo = new UocImplOrderItemQryBo();
        uocImplOrderItemQryBo.setImplOrderId(implOrder.getImplOrderId());
        uocImplOrderItemQryBo.setOrderId(implOrder.getOrderId());
        List<UocImplOrderItem> uocImplOrderItemList = this.iUocImplOrderModel.getListImplOrderItem(uocImplOrderItemQryBo).getUocImplOrderItemList();
        if (ObjectUtil.isNotEmpty(uocImplOrderItemList)) {
            for (UocImplOrderItem item : uocImplOrderItemList) {
                UocGetImplOrderDetailsServiceRspItemBo rspItemBo = UocRu.js(item, UocGetImplOrderDetailsServiceRspItemBo.class);
                UocImplItemMapQryBo uocImplItemMapQryBo = new UocImplItemMapQryBo();
                uocImplItemMapQryBo.setImplOrderItemId(item.getImplOrderItemId());
                List<UocImplItemMap> impOrderItemMapList = this.iUocImplOrderModel.getImpOrderItemMapList(uocImplItemMapQryBo);
                rspItemBo.setImplOrderDetailsServiceRspItemExtBoList(UocRu.jsl(impOrderItemMapList, UocGetImplOrderDetailsServiceRspItemExtBo.class));
                implOrderDetailsServiceRspBoList.add(rspItemBo);
            }
        }
        rspBo.setImplOrderDetailsServiceRspBoList(implOrderDetailsServiceRspBoList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void validateParam(UocGetImplOrderDetailsServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getImplOrderId() == null) {
            throw new BaseBusinessException("100001", "\u6267\u884c\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

