/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.UocCancelSaleOrderService;
import com.tydic.dyc.oc.service.saleorder.bo.UocCancelSaleOrderServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCancelSaleOrderServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.saleorder.UocCancelSaleOrderService"})
public class UocCancelSaleOrderServiceImpl
implements UocCancelSaleOrderService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @PostMapping(value={"cancelSaleOrder"})
    public UocCancelSaleOrderServiceRspBo cancelSaleOrder(@RequestBody UocCancelSaleOrderServiceReqBo reqBo) {
        this.validateArg(reqBo);
        Date now = new Date();
        this.iUocSaleOrderModel.modifySaleOrderMain(this.convertSaleOrderDo(reqBo, now));
        if (ObjectUtil.isNotEmpty((Object)reqBo.getAccessoryAddBoList())) {
            this.iUocOrderModel.createOrderAccessory(this.convertSaleOrderAccessory(reqBo, now));
        }
        return UocRu.success(UocCancelSaleOrderServiceRspBo.class);
    }

    private List<UocOrderAccessory> convertSaleOrderAccessory(UocCancelSaleOrderServiceReqBo reqBo, Date now) {
        List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getAccessoryAddBoList(), UocOrderAccessory.class);
        uocOrderAccessoryList.forEach(each -> {
            each.setId(IdUtil.nextId());
            each.setObjId(reqBo.getSaleOrderId());
            each.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            each.setOrderId(reqBo.getOrderId());
            each.setCreateTime(now);
            each.setCreateOperId(reqBo.getUserId().toString());
        });
        return uocOrderAccessoryList;
    }

    private UocSaleOrderDo convertSaleOrderDo(UocCancelSaleOrderServiceReqBo reqBo, Date now) {
        UocSaleOrderDo uocSaleOrderDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocSaleOrderDo.setCancelTime(now);
        uocSaleOrderDo.setCancelReason(reqBo.getCancelReason());
        uocSaleOrderDo.setSaleOrderState("XS_QX_QX");
        return uocSaleOrderDo;
    }

    private void validateArg(UocCancelSaleOrderServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCancelSaleOrderServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCancelReason())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d6\u6d88\u539f\u56e0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7528\u6237ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

