/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.config.UocInitConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.UocSaleOrderRefuseService;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRefuseReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRefuseRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.saleorder.UocSaleOrderRefuseService"})
public class UocSaleOrderRefuseServiceImpl
implements UocSaleOrderRefuseService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private UocInitConfig uocInitConfig;
    private static final Integer OP_FLAG_CONFIRM = 1;
    private static final Integer OP_FLAG_REFUSE = 0;

    @PostMapping(value={"dealSaleOrderRefuse"})
    public UocSaleOrderRefuseRspBo dealSaleOrderRefuse(@RequestBody UocSaleOrderRefuseReqBo reqBo) {
        if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            return UocRu.success(UocSaleOrderRefuseRspBo.class);
        }
        this.validateArg(reqBo);
        Date now = new Date();
        this.iUocSaleOrderModel.modifySaleOrderMain(this.convertSaleOrderDo(reqBo, now));
        if (ObjectUtil.isNotEmpty((Object)reqBo.getOrderAccessoryList())) {
            this.iUocOrderModel.createOrderAccessory(this.convertSaleOrderAccessory(reqBo, now));
        }
        return UocRu.success(UocSaleOrderRefuseRspBo.class);
    }

    private List<UocOrderAccessory> convertSaleOrderAccessory(UocSaleOrderRefuseReqBo reqBo, Date now) {
        List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getOrderAccessoryList(), UocOrderAccessory.class);
        uocOrderAccessoryList.forEach(each -> {
            each.setId(IdUtil.nextId());
            each.setObjId(reqBo.getSaleOrderId());
            each.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            each.setOrderId(reqBo.getOrderId());
            each.setCreateTime(now);
            each.setCreateOperId(reqBo.getUserId().toString());
        });
        return uocOrderAccessoryList;
    }

    private UocSaleOrderDo convertSaleOrderDo(UocSaleOrderRefuseReqBo reqBo, Date now) {
        UocSaleOrderDo uocSaleOrderDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocSaleOrderDo.setRejectReason(reqBo.getRejectReason());
        uocSaleOrderDo.setRejectTime(ObjectUtil.isNotEmpty((Object)reqBo.getRejectTime()) ? reqBo.getRejectTime() : now);
        return uocSaleOrderDo;
    }

    private void validateArg(UocSaleOrderRefuseReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOpFlag()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!OP_FLAG_REFUSE.equals(reqBo.getOpFlag()) && !OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            throw new BaseBusinessException("100001", "\u64cd\u4f5c\u53ea\u80fd\u662f\u63a5\u5355\u6216\u62d2\u5355");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag()) && StringUtils.isBlank((CharSequence)reqBo.getRejectReason())) {
            throw new BaseBusinessException("100001", "\u62d2\u5355\u65f6\uff0c\u62d2\u5355\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

