/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.model.implorder.IUocImplOrderModel;
import com.tydic.dyc.oc.model.implorder.UocImplOrderDo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplItemMapQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderItemQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderMapQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderQryBo;
import com.tydic.dyc.oc.model.implorder.sub.UocImplItemMap;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderMap;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UocEsSyncImpl
implements IUocEsSync {
    public static final List<String> pCodeList = ListUtil.list((boolean)false);
    @Autowired
    private IUocImplOrderModel iUocImplOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    public static final String UOC_IMPL_ORDER_ITEM = "uocImplOrderItemList";

    @Override
    public String indexName() {
        return this.uocIndexConfig.getImplOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
        rspBo.setObjId(reqBo.getObjId());
        UocImplOrderDo implOrderSubject = this.getImplOrderSubject(reqBo);
        if (Objects.isNull(implOrderSubject)) {
            return rspBo;
        }
        List<UocImplOrderMap> implOrderMapList = this.getImplOrderMapList(reqBo);
        List<UocImplOrderItem> implOrderItemList = this.getImplOrderItemList(reqBo);
        List<UocImplItemMap> implOrderItemMapList = this.getImplOrderItemMapList(reqBo);
        Map<Object, Object> implItemMap = new HashMap();
        if (ObjectUtil.isNotEmpty(implOrderItemMapList)) {
            implItemMap = implOrderItemMapList.stream().collect(Collectors.groupingBy(UocImplItemMap::getImplOrderItemId));
        }
        JSONObject implObj = JSON.parseObject((String)JSON.toJSONString((Object)implOrderSubject));
        if (ObjectUtil.isNotEmpty(implOrderMapList)) {
            implOrderMapList.forEach(each -> implObj.put(each.getFieldCode(), (Object)each.getFieldValue()));
        }
        if (ObjectUtil.isNotEmpty(implOrderItemList)) {
            JSONArray implOrdeItemArray = new JSONArray();
            for (UocImplOrderItem item : implOrderItemList) {
                List uocImplItemMapList;
                JSONObject itemObj = JSON.parseObject((String)JSON.toJSONString((Object)item));
                if (ObjectUtil.isNotEmpty(implItemMap) && implItemMap.containsKey(item.getImplOrderItemId()) && ObjectUtil.isNotEmpty((Object)(uocImplItemMapList = (List)implItemMap.get(item.getImplOrderItemId())))) {
                    uocImplItemMapList.forEach(each -> itemObj.put(each.getFieldCode(), (Object)each.getFieldValue()));
                }
                implOrdeItemArray.add((Object)itemObj);
            }
            implObj.put(UOC_IMPL_ORDER_ITEM, (Object)implOrdeItemArray);
        }
        rspBo.setJsonObj(implObj);
        this.translateProperties(rspBo);
        return rspBo;
    }

    private static void initialize() {
        pCodeList.add("UOC_IMPL_ORDER_TYPE");
        pCodeList.add("UOC_IMPL_ORDER_STATE");
        pCodeList.add("UOC_ORD_INVOICE_TAG");
        pCodeList.add("UOC_ORD_PROC_STATE");
        pCodeList.add("UOC_ORD_CHECK_STATE");
        pCodeList.add("UOC_COMMON_FINISH_FLAG");
        pCodeList.add("UOC_COMMON_CANCEL_FLAG");
        pCodeList.add("UOC_COMMON_MODEL_SETTLE");
        pCodeList.add("UOC_COMMON_PURCHASE_TYPE");
        pCodeList.add("UOC_COMMON_ITEM_TYPE");
        pCodeList.add("UOC_COMMON_ITEM_STATE");
        pCodeList.add("UOC_ORD_DEL_TAG");
    }

    private void translateProperties(IUocEsSyncQryRspBo rspBo) {
        JSONObject jsonObj = rspBo.getJsonObj();
        Map<String, Map<String, String>> dictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        if (ObjectUtil.isNotEmpty(dictionaryMap)) {
            List<UocImplOrderItem> uocImplOrderItemList;
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_IMPL_ORDER_STATE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"implOrderState"))) {
                String implOrderStateCode = jsonObj.get((Object)"implOrderState").toString();
                jsonObj.put("implOrderStateStr", (Object)dictionaryMap.get("UOC_IMPL_ORDER_STATE").get(implOrderStateCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_IMPL_ORDER_TYPE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"implOrderType"))) {
                String implOrderTypeCode = jsonObj.get((Object)"implOrderType").toString();
                jsonObj.put("implOrderTypeStr", (Object)dictionaryMap.get("UOC_IMPL_ORDER_TYPE").get(implOrderTypeCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORD_INVOICE_TAG")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"invoiceTag"))) {
                String invoiceTagCode = jsonObj.get((Object)"invoiceTag").toString();
                jsonObj.put("invoiceTagStr", (Object)dictionaryMap.get("UOC_ORD_INVOICE_TAG").get(invoiceTagCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORD_PROC_STATE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"procState"))) {
                String procStateCode = jsonObj.get((Object)"procState").toString();
                jsonObj.put("procStateStr", (Object)dictionaryMap.get("UOC_ORD_PROC_STATE").get(procStateCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORD_CHECK_STATE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"checkState"))) {
                String checkStateCode = jsonObj.get((Object)"checkState").toString();
                jsonObj.put("procStateStr", (Object)dictionaryMap.get("UOC_ORD_CHECK_STATE").get(checkStateCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_FINISH_FLAG")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"finishFlag"))) {
                String finishFlagCode = jsonObj.get((Object)"finishFlag").toString();
                jsonObj.put("finishFlagStr", (Object)dictionaryMap.get("UOC_COMMON_FINISH_FLAG").get(finishFlagCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_CANCEL_FLAG")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"cancelFlag"))) {
                String cancelFlagCode = jsonObj.get((Object)"cancelFlag").toString();
                jsonObj.put("cancelFlagStr", (Object)dictionaryMap.get("UOC_COMMON_CANCEL_FLAG").get(cancelFlagCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_MODEL_SETTLE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"modelSettle"))) {
                String modelSettleCode = jsonObj.get((Object)"modelSettle").toString();
                jsonObj.put("modelSettleStr", (Object)dictionaryMap.get("UOC_COMMON_MODEL_SETTLE").get(modelSettleCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_PURCHASE_TYPE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"purchaseType"))) {
                String purchaseTypeCode = jsonObj.get((Object)"purchaseType").toString();
                jsonObj.put("purchaseTypeStr", (Object)dictionaryMap.get("UOC_COMMON_PURCHASE_TYPE").get(purchaseTypeCode));
            }
            if (ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)UOC_IMPL_ORDER_ITEM)) && ObjectUtil.isNotEmpty(uocImplOrderItemList = UocRu.jsl(jsonObj.get((Object)UOC_IMPL_ORDER_ITEM), UocImplOrderItem.class))) {
                uocImplOrderItemList.forEach(each -> {
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_ITEM_TYPE")) && ObjectUtil.isNotEmpty((Object)each.getItemType())) {
                        each.setItemTypeStr((String)((Map)dictionaryMap.get("UOC_COMMON_ITEM_TYPE")).get(each.getItemType().toString()));
                    }
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_ITEM_STATE"))) {
                        each.setImplItemStateStr((String)((Map)dictionaryMap.get("UOC_COMMON_ITEM_STATE")).get(each.getImplItemState()));
                    }
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORD_DEL_TAG")) && ObjectUtil.isNotEmpty((Object)each.getDelTag())) {
                        each.setDelTagStr((String)((Map)dictionaryMap.get("UOC_ORD_DEL_TAG")).get(each.getDelTag().toString()));
                    }
                });
                jsonObj.put(UOC_IMPL_ORDER_ITEM, (Object)JSON.parseArray((String)JSON.toJSONString(uocImplOrderItemList)));
            }
        }
    }

    private UocImplOrderDo getImplOrderSubject(IUocEsSyncQryReqBo reqBo) {
        UocImplOrderQryBo uocImplOrderQryBo = new UocImplOrderQryBo();
        uocImplOrderQryBo.setOrderId(reqBo.getOrderId());
        uocImplOrderQryBo.setImplOrderId(reqBo.getObjId());
        return this.iUocImplOrderModel.getImplOrderMain(uocImplOrderQryBo);
    }

    private List<UocImplOrderMap> getImplOrderMapList(IUocEsSyncQryReqBo reqBo) {
        UocImplOrderMapQryBo uocImplOrderMapQryBo = new UocImplOrderMapQryBo();
        uocImplOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocImplOrderMapQryBo.setImplOrderId(reqBo.getObjId());
        return this.iUocImplOrderModel.getImplOrderMapList(uocImplOrderMapQryBo);
    }

    private List<UocImplOrderItem> getImplOrderItemList(IUocEsSyncQryReqBo reqBo) {
        UocImplOrderItemQryBo uocImplOrderItemQryBo = new UocImplOrderItemQryBo();
        uocImplOrderItemQryBo.setImplOrderId(reqBo.getObjId());
        uocImplOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocImplOrderModel.getListImplOrderItem(uocImplOrderItemQryBo).getUocImplOrderItemList();
    }

    private List<UocImplItemMap> getImplOrderItemMapList(IUocEsSyncQryReqBo reqBo) {
        UocImplItemMapQryBo uocImplItemMapQryBo = new UocImplItemMapQryBo();
        uocImplItemMapQryBo.setImplOrderId(reqBo.getObjId());
        uocImplItemMapQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocImplOrderModel.getImpOrderItemMapList(uocImplItemMapQryBo);
    }

    static {
        UocEsSyncImpl.initialize();
    }
}

