/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.implorder.IUocImplOrderModel;
import com.tydic.dyc.oc.model.implorder.UocImplOrderDo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderItemQryBo;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocNumChngOrderCreateService;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocNumChngOrderCreateService"})
public class UocNumChngOrderCreateServiceImpl
implements UocNumChngOrderCreateService {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocImplOrderModel iUocImplOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"createNumChng"})
    public UocNumChngOrderCreateRspBo createNumChng(@RequestBody UocNumChngOrderCreateReqBo reqBo) {
        this.validateArg(reqBo);
        String operId = reqBo.getUserId().toString();
        Date now = new Date();
        List<UocShipOrderItem> shipOrderItemList = this.getShipOrderItemList(reqBo);
        this.checkChngingCount(reqBo, shipOrderItemList);
        List<UocImplOrderItem> implOrderItemList = this.getImplOrderItemList(shipOrderItemList);
        this.iUocChngOrderModel.createChngOrder(this.convertChngOrderDo(reqBo, operId, now, shipOrderItemList, implOrderItemList));
        this.iUocShipOrderModel.modifyShipOrderItemChngingCount(this.convertShipOrderDo(reqBo, operId, now));
        this.iUocImplOrderModel.modifyBatchItemChngingCount(this.convertImplOrderDo(reqBo, shipOrderItemList, operId, now));
        return UocRu.success(UocNumChngOrderCreateRspBo.class);
    }

    private void checkChngingCount(UocNumChngOrderCreateReqBo reqBo, List<UocShipOrderItem> shipOrderItemList) {
        UocImplOrderItemQryBo uocImplOrderItemQryBo = new UocImplOrderItemQryBo();
        uocImplOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocImplOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocImplOrderItemQryBo.setImplOrderId(reqBo.getImplOrderId());
        UocImplOrderDo uocImplOrderDo = this.iUocImplOrderModel.getCollectCountImplOrderItem(uocImplOrderItemQryBo);
        if (CollectionUtils.isEmpty(uocImplOrderDo.getUocImplOrderItemList())) {
            throw new BaseBusinessException("101006", "\u67e5\u8be2\u6267\u884c\u5355\u6c47\u603b\u6570\u91cf\u4e3a\u7a7a");
        }
        UocImplOrderItem uocImplOrderItem = uocImplOrderDo.getUocImplOrderItemList().get(0);
        if (uocImplOrderItem.getChngingCount().compareTo(BigDecimal.ZERO) != 0) {
            throw new BaseBusinessException("101006", "\u6267\u884c\u5355\u4e0b\u5b58\u5728\u5f02\u5e38\u53d8\u66f4\u5728\u9014\u6570\u91cf\uff0c\u8bf7\u5f85\u53d8\u66f4\u5b8c\u7ed3\u540e\u518d\u53d1\u8d77");
        }
        Map<Long, UocShipOrderItem> uocShipOrderItemMap = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        reqBo.getChngItemList().forEach(uocNumChngOrderCreateReqItemBo -> {
            UocShipOrderItem uocShipOrderItem = (UocShipOrderItem)uocShipOrderItemMap.get(uocNumChngOrderCreateReqItemBo.getShipOrderItemId());
            if (uocNumChngOrderCreateReqItemBo.getChngCount().add(uocShipOrderItem.getReturnCount()).compareTo(uocShipOrderItem.getInspCount()) > 0) {
                throw new BaseBusinessException("101008", "\u53ef\u53d8\u66f4\u6570\u91cf\u4e0d\u8db3\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
            }
        });
    }

    private UocImplOrderDo convertImplOrderDo(UocNumChngOrderCreateReqBo reqBo, List<UocShipOrderItem> shipOrderItemList, String operId, Date now) {
        UocImplOrderDo uocImplOrderDo = new UocImplOrderDo();
        uocImplOrderDo.setImplOrderId(reqBo.getImplOrderId());
        uocImplOrderDo.setOrderId(reqBo.getOrderId());
        uocImplOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocImplOrderDo.setUpdateTime(now);
        uocImplOrderDo.setUpdateOperId(operId);
        Map<Long, UocShipOrderItem> uocShipOrderItemMap = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        HashMap uocImplOrderItemMap = new HashMap();
        reqBo.getChngItemList().forEach(uocNumChngOrderCreateReqItemBo -> {
            UocShipOrderItem uocShipOrderItem = (UocShipOrderItem)uocShipOrderItemMap.get(uocNumChngOrderCreateReqItemBo.getShipOrderItemId());
            UocImplOrderItem uocImplOrderItem = (UocImplOrderItem)uocImplOrderItemMap.get(uocShipOrderItem.getImplOrderItemId());
            if (null == uocImplOrderItem) {
                uocImplOrderItem = new UocImplOrderItem();
                uocImplOrderItem.setImplOrderItemId(uocShipOrderItem.getImplOrderItemId());
                uocImplOrderItem.setChngingCount(uocNumChngOrderCreateReqItemBo.getChngCount());
            } else {
                uocImplOrderItem.setChngingCount(uocImplOrderItem.getChngingCount().add(uocNumChngOrderCreateReqItemBo.getChngCount()));
            }
            uocImplOrderItemMap.put(uocShipOrderItem.getImplOrderItemId(), uocImplOrderItem);
        });
        uocImplOrderDo.setUocImplOrderItemList(new ArrayList<UocImplOrderItem>(uocImplOrderItemMap.values()));
        return uocImplOrderDo;
    }

    private UocShipOrderDo convertShipOrderDo(UocNumChngOrderCreateReqBo reqBo, String operId, Date now) {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderId(reqBo.getOrderId());
        uocShipOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderDo.setShipOrderId(reqBo.getShipOrderId());
        uocShipOrderDo.setImplOrderId(reqBo.getImplOrderId());
        uocShipOrderDo.setUpdateOperId(operId);
        uocShipOrderDo.setUpdateTime(now);
        ArrayList<UocShipOrderItem> uocShipOrderItemList = new ArrayList<UocShipOrderItem>();
        reqBo.getChngItemList().forEach(uocNumChngOrderCreateReqItemBo -> {
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setShipOrderItemId(uocNumChngOrderCreateReqItemBo.getShipOrderItemId());
            uocShipOrderItem.setChngingCount(uocNumChngOrderCreateReqItemBo.getChngCount());
            uocShipOrderItemList.add(uocShipOrderItem);
        });
        uocShipOrderDo.setShipOrderItemBoList(uocShipOrderItemList);
        return uocShipOrderDo;
    }

    private UocChngOrderDo convertChngOrderDo(UocNumChngOrderCreateReqBo reqBo, String operId, Date now, List<UocShipOrderItem> shipOrderItemList, List<UocImplOrderItem> implOrderItemList) {
        Map<Long, UocShipOrderItem> shipOrderItemMap = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        Map<Long, UocImplOrderItem> implOrderItemMap = implOrderItemList.stream().collect(Collectors.toMap(UocImplOrderItem::getImplOrderItemId, o -> o));
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        uocChngOrderDo.setChngOrderId(IdUtil.nextId());
        uocChngOrderDo.setChngOrderState("CHNG_CHNG_QRZ");
        uocChngOrderDo.setCreateOperId(operId);
        uocChngOrderDo.setTenantId(reqBo.getTenantId());
        uocChngOrderDo.setCreateTime(now);
        uocChngOrderDo.setCreateOperName(reqBo.getName());
        uocChngOrderDo.setCreateOperMobile(reqBo.getCellphone());
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        uocChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.NUM);
        uocChngOrderDo.setRemark(reqBo.getRemark());
        ArrayList<UocChngOrderObj> uocChngOrderObjList = new ArrayList<UocChngOrderObj>();
        UocChngOrderObj uocChngOrderObj = new UocChngOrderObj();
        uocChngOrderObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
        uocChngOrderObj.setOrderId(reqBo.getOrderId());
        uocChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
        uocChngOrderObj.setImplOrderId(reqBo.getImplOrderId());
        uocChngOrderObj.setShipOrderId(reqBo.getShipOrderId());
        uocChngOrderObj.setChngOrderObjId(IdUtil.nextId());
        uocChngOrderObj.setChngType(UocConstant.BUSI_TYPE.NUM);
        uocChngOrderObj.setCreateOperId(operId);
        uocChngOrderObj.setCreateTime(now);
        ArrayList<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<UocChngOrderItemObj>();
        uocChngOrderObj.setChngNum(BigDecimal.ZERO);
        uocChngOrderObj.setChngFee(BigDecimal.ZERO);
        reqBo.getChngItemList().forEach(uocNumChngOrderCreateReqItemBo -> {
            UocShipOrderItem uocShipOrderItem = (UocShipOrderItem)shipOrderItemMap.get(uocNumChngOrderCreateReqItemBo.getShipOrderItemId());
            UocImplOrderItem uocImplOrderItem = (UocImplOrderItem)implOrderItemMap.get(uocShipOrderItem.getImplOrderItemId());
            UocChngOrderItemObj uocChngOrderItemObj = new UocChngOrderItemObj();
            uocChngOrderItemObj.setChngNum(uocNumChngOrderCreateReqItemBo.getChngCount());
            uocChngOrderItemObj.setChngFee(uocNumChngOrderCreateReqItemBo.getChngCount().multiply(uocImplOrderItem.getSalePrice()));
            uocChngOrderItemObj.setChngOrderId(uocChngOrderObj.getChngOrderId());
            uocChngOrderItemObj.setChngOrderObjId(uocChngOrderObj.getChngOrderObjId());
            uocChngOrderItemObj.setShipOrderItemId(uocNumChngOrderCreateReqItemBo.getShipOrderItemId());
            uocChngOrderItemObj.setImplOrderItemId(uocShipOrderItem.getImplOrderItemId());
            uocChngOrderItemObj.setSaleOrderItemId(uocShipOrderItem.getSaleOrderItemId());
            uocChngOrderItemObj.setChngType(UocConstant.BUSI_TYPE.NUM);
            uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
            uocChngOrderItemObj.setId(IdUtil.nextId());
            uocChngOrderItemObj.setCreateOperId(operId);
            uocChngOrderItemObj.setCreateTime(now);
            uocChngOrderItemObjList.add(uocChngOrderItemObj);
            uocChngOrderObj.setChngNum(uocChngOrderObj.getChngNum().add(uocNumChngOrderCreateReqItemBo.getChngCount()));
            uocChngOrderObj.setChngFee(uocChngOrderObj.getChngNum().multiply(uocImplOrderItem.getSalePrice()));
        });
        uocChngOrderObj.setUocChngOrderItemObjList(uocChngOrderItemObjList);
        uocChngOrderObjList.add(uocChngOrderObj);
        uocChngOrderDo.setUocChngOrderObjList(uocChngOrderObjList);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtParallelBoList())) {
            List<UocChngOrderMap> uocChngOrderMapList = UocRu.jsl(reqBo.getExtParallelBoList(), UocChngOrderMap.class);
            uocChngOrderMapList.forEach(uocChngOrderMap -> {
                uocChngOrderMap.setChngOrderId(uocChngOrderDo.getChngOrderId());
                uocChngOrderMap.setOrderId(uocChngOrderDo.getOrderId());
                uocChngOrderMap.setCreateOperId(operId);
                uocChngOrderMap.setCreateTime(now);
                uocChngOrderMap.setId(IdUtil.nextId());
            });
            uocChngOrderDo.setUocChngOrderMapList(uocChngOrderMapList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getOrderAccessoryBoList(), UocOrderAccessory.class);
            uocOrderAccessoryList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setCreateTime(now);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
                uocOrderAccessory.setObjId(uocChngOrderDo.getChngOrderId());
            });
            uocChngOrderDo.setOrderAccessoryBoList(uocOrderAccessoryList);
        }
        return uocChngOrderDo;
    }

    private String getChngOrderNo(UocNumChngOrderCreateReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("101002", "\u67e5\u8be2\u9a8c\u6536\u5355\u4e3a\u7a7a");
        }
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.NUM);
        uocChngOrderQryBo.setOrderSource(uocSaleOrderDo.getOrderSource());
        UocChngOrderDo uocChngOrderDo = this.iUocChngOrderModel.getChngOrderNo(uocChngOrderQryBo);
        return uocChngOrderDo.getChngOrderNo();
    }

    private List<UocShipOrderItem> getShipOrderItemList(UocNumChngOrderCreateReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderItemIdList(reqBo.getChngItemList().stream().map(UocNumChngOrderCreateReqItemBo::getShipOrderItemId).collect(Collectors.toList()));
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderItemQryBo.setImplOrderId(reqBo.getImplOrderId());
        uocShipOrderItemQryBo.setShipOrderId(reqBo.getShipOrderId());
        UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        if (CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
            throw new BaseBusinessException("101006", "\u67e5\u8be2\u53d1\u8d27\u5355\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a");
        }
        return uocShipOrderDo.getShipOrderItemBoList();
    }

    private List<UocImplOrderItem> getImplOrderItemList(List<UocShipOrderItem> uocShipOrderItemList) {
        UocImplOrderItemQryBo uocImplOrderItemQryBo = new UocImplOrderItemQryBo();
        uocImplOrderItemQryBo.setImplOrderItemIdList(uocShipOrderItemList.stream().map(UocShipOrderItem::getImplOrderItemId).distinct().collect(Collectors.toList()));
        uocImplOrderItemQryBo.setOrderId(uocShipOrderItemList.get(0).getOrderId());
        UocImplOrderDo uocImplOrderDo = this.iUocImplOrderModel.getListImplOrderItem(uocImplOrderItemQryBo);
        if (CollectionUtils.isEmpty(uocImplOrderDo.getUocImplOrderItemList())) {
            throw new BaseBusinessException("101006", "\u67e5\u8be2\u6267\u884c\u5355\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a");
        }
        return uocImplOrderDo.getUocImplOrderItemList();
    }

    private void validateArg(UocNumChngOrderCreateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getImplOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u6267\u884c\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getShipOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u5355ID\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getChngItemList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u4fe1\u606f\u5217\u8868\u4e3a\u7a7a");
        }
        reqBo.getChngItemList().forEach(uocNumChngOrderCreateReqItemBo -> {
            if (null == uocNumChngOrderCreateReqItemBo.getShipOrderItemId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u660e\u7ec6ID\u4e3a\u7a7a");
            }
            if (null == uocNumChngOrderCreateReqItemBo.getChngCount()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u6570\u91cf\u4e3a\u7a7a");
            }
        });
    }
}

