/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.implorder;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.implorder.IUocImplOrderModel;
import com.tydic.dyc.oc.model.implorder.UocImplOrderDo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplItemMapQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderItemQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderMapQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderQryBo;
import com.tydic.dyc.oc.model.implorder.sub.UocImplItemMap;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderMap;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryDetailBo;
import com.tydic.dyc.oc.service.implorder.UocGetImplOrderDetailsService;
import com.tydic.dyc.oc.service.implorder.bo.UocGetImplOrderDetailsServiceReqBo;
import com.tydic.dyc.oc.service.implorder.bo.UocGetImplOrderDetailsServiceRspBo;
import com.tydic.dyc.oc.service.implorder.bo.UocGetImplOrderDetailsServiceRspExtBo;
import com.tydic.dyc.oc.service.implorder.bo.UocGetImplOrderDetailsServiceRspItemBo;
import com.tydic.dyc.oc.service.implorder.bo.UocGetImplOrderDetailsServiceRspItemExtBo;
import com.tydic.dyc.oc.service.implorder.bo.UocGetImplOrderDetailsServiceRspReceiverAddressBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.implorder.UocGetImplOrderDetailsService"})
public class UocGetImplOrderDetailsServiceImpl
implements UocGetImplOrderDetailsService {
    public static final List<String> pCodeList = ListUtil.list((boolean)false);
    @Autowired
    private IUocImplOrderModel iUocImplOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @PostMapping(value={"getImplOrderDetails"})
    public UocGetImplOrderDetailsServiceRspBo getImplOrderDetails(@RequestBody UocGetImplOrderDetailsServiceReqBo reqBo) {
        this.validateParam(reqBo);
        UocGetImplOrderDetailsServiceRspReceiverAddressBo receiverAddressBo = new UocGetImplOrderDetailsServiceRspReceiverAddressBo();
        ArrayList<UocGetImplOrderDetailsServiceRspItemBo> implOrderDetailsServiceRspBoList = new ArrayList<UocGetImplOrderDetailsServiceRspItemBo>();
        List<Object> implOrderDetailsServiceRspExtBoList = new ArrayList();
        ArrayList<UocBaseOrderAccessoryTypeDetailBo> accessoryDetailBoList = new ArrayList<UocBaseOrderAccessoryTypeDetailBo>();
        UocImplOrderDo implOrder = this.iUocImplOrderModel.getImplOrderMain(UocRu.js(reqBo, UocImplOrderQryBo.class));
        if (ObjectUtil.isNull((Object)implOrder)) {
            return UocRu.success(UocGetImplOrderDetailsServiceRspBo.class);
        }
        UocGetImplOrderDetailsServiceRspBo rspBo = UocRu.js(implOrder, UocGetImplOrderDetailsServiceRspBo.class);
        UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
        relaQryBo.setOrderId(implOrder.getOrderId());
        UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        rspBo.setReceiverAddressBo(UocRu.js(uocOrdLogisticsRela, UocGetImplOrderDetailsServiceRspReceiverAddressBo.class));
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
        uocOrderAccessoryQryBo.setObjId(implOrder.getImplOrderId());
        uocOrderAccessoryQryBo.setOrderId(implOrder.getOrderId());
        uocOrderAccessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.IMPL);
        List<UocOrderAccessory> saleOrderAccessoryList = this.iUocOrderModel.getOrderAccessoryList(uocOrderAccessoryQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderAccessoryList)) {
            List<UocBaseOrderAccessoryDetailBo> accessoryDetailBos = UocRu.jsl(saleOrderAccessoryList, UocBaseOrderAccessoryDetailBo.class);
            Map<Integer, List<UocBaseOrderAccessoryDetailBo>> accessoryDetailMap = accessoryDetailBos.stream().collect(Collectors.groupingBy(UocBaseOrderAccessoryDetailBo::getAttachmentType));
            Iterator<Integer> iterator = accessoryDetailMap.keySet().iterator();
            while (iterator.hasNext()) {
                UocBaseOrderAccessoryTypeDetailBo accessoryTypeDetailBo = new UocBaseOrderAccessoryTypeDetailBo();
                Integer attachmentType = iterator.next();
                accessoryTypeDetailBo.setAttachmentType(attachmentType);
                accessoryTypeDetailBo.setAttchList(accessoryDetailMap.get(attachmentType));
                accessoryDetailBoList.add(accessoryTypeDetailBo);
            }
        }
        rspBo.setAccessoryDetailBoList(accessoryDetailBoList);
        List<UocImplOrderMap> implOrderMapList = this.iUocImplOrderModel.getImplOrderMapList(UocRu.js(reqBo, UocImplOrderMapQryBo.class));
        if (ObjectUtil.isNotEmpty(implOrderMapList)) {
            implOrderDetailsServiceRspExtBoList = UocRu.jsl(implOrderMapList, UocGetImplOrderDetailsServiceRspExtBo.class);
        }
        rspBo.setImplOrderDetailsServiceRspExtBoList(implOrderDetailsServiceRspExtBoList);
        UocImplOrderItemQryBo uocImplOrderItemQryBo = new UocImplOrderItemQryBo();
        uocImplOrderItemQryBo.setImplOrderId(implOrder.getImplOrderId());
        uocImplOrderItemQryBo.setOrderId(implOrder.getOrderId());
        List<UocImplOrderItem> uocImplOrderItemList = this.iUocImplOrderModel.getListImplOrderItem(uocImplOrderItemQryBo).getUocImplOrderItemList();
        if (ObjectUtil.isNotEmpty(uocImplOrderItemList)) {
            for (UocImplOrderItem item : uocImplOrderItemList) {
                UocGetImplOrderDetailsServiceRspItemBo rspItemBo = UocRu.js(item, UocGetImplOrderDetailsServiceRspItemBo.class);
                UocImplItemMapQryBo uocImplItemMapQryBo = new UocImplItemMapQryBo();
                uocImplItemMapQryBo.setImplOrderItemId(item.getImplOrderItemId());
                List<UocImplItemMap> impOrderItemMapList = this.iUocImplOrderModel.getImpOrderItemMapList(uocImplItemMapQryBo);
                rspItemBo.setImplOrderDetailsServiceRspItemExtBoList(UocRu.jsl(impOrderItemMapList, UocGetImplOrderDetailsServiceRspItemExtBo.class));
                implOrderDetailsServiceRspBoList.add(rspItemBo);
            }
        }
        rspBo.setImplOrderDetailsServiceRspBoList(implOrderDetailsServiceRspBoList);
        this.translateProperties(rspBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private static void initialize() {
        pCodeList.add("UOC_IMPL_ORDER_TYPE");
        pCodeList.add("UOC_IMPL_ORDER_STATE");
        pCodeList.add("UOC_ORD_INVOICE_TAG");
        pCodeList.add("UOC_ORD_PROC_STATE");
        pCodeList.add("UOC_COMMON_FINISH_FLAG");
        pCodeList.add("UOC_COMMON_CANCEL_FLAG");
        pCodeList.add("UOC_COMMON_MODEL_SETTLE");
        pCodeList.add("UOC_COMMON_PURCHASE_TYPE");
        pCodeList.add("UOC_COMMON_ITEM_TYPE");
        pCodeList.add("UOC_COMMON_ITEM_STATE");
        pCodeList.add("UOC_ORD_DEL_TAG");
        pCodeList.add("UOC_ORDER_ACCESSORY_ATTACHMENT_TYPE");
        pCodeList.add("UOC_ORDER_OBJ_TYPE");
    }

    private void translateProperties(UocGetImplOrderDetailsServiceRspBo rspBo) {
        Map<String, Map<String, String>> dictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        if (ObjectUtil.isNotEmpty(dictionaryMap)) {
            List implOrderDetailsServiceRspBoList;
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_STATE"))) {
                rspBo.setSaleOrderStateStr(dictionaryMap.get("UOC_SALE_ORDER_STATE").get(rspBo.getSaleOrderState()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_IMPL_ORDER_STATE"))) {
                rspBo.setImplOrderStateStr(dictionaryMap.get("UOC_IMPL_ORDER_STATE").get(rspBo.getImplOrderState()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_IMPL_ORDER_TYPE")) && ObjectUtil.isNotEmpty((Object)rspBo.getImplOrderType())) {
                rspBo.setImplOrderTypeStr(dictionaryMap.get("UOC_IMPL_ORDER_TYPE").get(rspBo.getImplOrderType().toString()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORD_PROC_STATE"))) {
                rspBo.setProcStateStr(dictionaryMap.get("UOC_ORD_PROC_STATE").get(rspBo.getProcState()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORD_CHECK_STATE"))) {
                rspBo.setCheckStateStr(dictionaryMap.get("UOC_ORD_CHECK_STATE").get(rspBo.getCheckState()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_FINISH_FLAG")) && ObjectUtil.isNotEmpty((Object)rspBo.getFinishFlag())) {
                rspBo.setFinishFlagStr(dictionaryMap.get("UOC_COMMON_FINISH_FLAG").get(rspBo.getFinishFlag().toString()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_MODEL_SETTLE")) && ObjectUtil.isNotEmpty((Object)rspBo.getModelSettle())) {
                rspBo.setModelSettleStr(dictionaryMap.get("UOC_COMMON_MODEL_SETTLE").get(rspBo.getModelSettle().toString()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_PURCHASE_TYPE")) && ObjectUtil.isNotEmpty((Object)rspBo.getPurchaseType())) {
                rspBo.setPurchaseTypeStr(dictionaryMap.get("UOC_COMMON_PURCHASE_TYPE").get(rspBo.getPurchaseType().toString()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_PAY_TYPE"))) {
                rspBo.setPayTypeStr(dictionaryMap.get("UOC_SALE_ORDER_PAY_TYPE").get(rspBo.getPayType()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_SOURCE")) && ObjectUtil.isNotEmpty((Object)rspBo.getOrderSource())) {
                rspBo.setOrderSourceStr(dictionaryMap.get("UOC_SALE_ORDER_SOURCE").get(rspBo.getOrderSource().toString()));
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getImplOrderDetailsServiceRspBoList()) && ObjectUtil.isNotEmpty((Object)(implOrderDetailsServiceRspBoList = rspBo.getImplOrderDetailsServiceRspBoList()))) {
                implOrderDetailsServiceRspBoList.forEach(each -> {
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_ITEM_TYPE")) && ObjectUtil.isNotEmpty((Object)each.getItemType())) {
                        each.setItemTypeStr((String)((Map)dictionaryMap.get("UOC_COMMON_ITEM_TYPE")).get(each.getItemType().toString()));
                    }
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_ITEM_STATE"))) {
                        each.setImplItemStateStr((String)((Map)dictionaryMap.get("UOC_COMMON_ITEM_STATE")).get(each.getImplItemState()));
                    }
                });
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getAccessoryDetailBoList())) {
                rspBo.getAccessoryDetailBoList().forEach(each -> {
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_ACCESSORY_ATTACHMENT_TYPE")) && ObjectUtil.isNotEmpty((Object)each.getAttachmentType())) {
                        each.setAttachmentTypeStr((String)((Map)dictionaryMap.get("UOC_ORDER_ACCESSORY_ATTACHMENT_TYPE")).get(each.getAttachmentType().toString()));
                    }
                    if (ObjectUtil.isNotEmpty((Object)each.getAttchList())) {
                        for (UocBaseOrderAccessoryDetailBo accessoryDetailBo : each.getAttchList()) {
                            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_OBJ_TYPE")) && ObjectUtil.isNotEmpty((Object)accessoryDetailBo.getObjType())) {
                                accessoryDetailBo.setObjTypeStr((String)((Map)dictionaryMap.get("UOC_ORDER_OBJ_TYPE")).get(accessoryDetailBo.getObjType().toString()));
                            }
                            if (!ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_ACCESSORY_ATTACHMENT_TYPE")) || !ObjectUtil.isNotEmpty((Object)accessoryDetailBo.getAttachmentType())) continue;
                            accessoryDetailBo.setAttachmentTypeStr((String)((Map)dictionaryMap.get("UOC_ORDER_ACCESSORY_ATTACHMENT_TYPE")).get(accessoryDetailBo.getAttachmentType().toString()));
                        }
                    }
                });
            }
        }
    }

    private void validateParam(UocGetImplOrderDetailsServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getImplOrderId() == null) {
            throw new BaseBusinessException("100001", "\u6267\u884c\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    static {
        UocGetImplOrderDetailsServiceImpl.initialize();
    }
}

