/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.UocCancelApplySaleOrderService;
import com.tydic.dyc.oc.service.saleorder.bo.UocCancelApplySaleOrderReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCancelApplySaleOrderRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.saleorder.UocCancelApplySaleOrderService"})
public class UocCancelApplySaleOrderServiceImpl
implements UocCancelApplySaleOrderService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @PostMapping(value={"cancelApplySaleOrder"})
    public UocCancelApplySaleOrderRspBo cancelApplySaleOrder(@RequestBody UocCancelApplySaleOrderReqBo reqBo) {
        this.validateArg(reqBo);
        Date now = new Date();
        UocSaleOrderDo uocSaleOrderDo = this.getUocSaleOrderDo(reqBo);
        UocChngOrderDo uocChngOrderDo = this.convertChngOrderDo(reqBo, now, uocSaleOrderDo);
        this.iUocChngOrderModel.createChngOrder(uocChngOrderDo);
        this.iUocSaleOrderModel.modifySaleOrderMain(this.convertSaleOrderDo(reqBo, now));
        this.dealMap(reqBo, now);
        UocCancelApplySaleOrderRspBo uocCancelApplySaleOrderRspBo = UocRu.success(UocCancelApplySaleOrderRspBo.class);
        uocCancelApplySaleOrderRspBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
        return uocCancelApplySaleOrderRspBo;
    }

    private UocChngOrderDo convertChngOrderDo(UocCancelApplySaleOrderReqBo reqBo, Date now, UocSaleOrderDo uocSaleOrderDo) {
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        uocChngOrderDo.setChngOrderId(IdUtil.nextId());
        uocChngOrderDo.setChngOrderNo(this.getChngOrderNo(uocSaleOrderDo));
        uocChngOrderDo.setChngOrderState("CHNG_XS_QXSQZ");
        uocChngOrderDo.setCancelReason(reqBo.getCancelReason());
        uocChngOrderDo.setCancelOperId(reqBo.getUserId().toString());
        uocChngOrderDo.setCancelOperName(reqBo.getName());
        uocChngOrderDo.setCancelTime(now);
        uocChngOrderDo.setCreateOperId(reqBo.getUserId().toString());
        uocChngOrderDo.setCreateOperName(reqBo.getName());
        uocChngOrderDo.setCreateOperMobile(reqBo.getCellphone());
        uocChngOrderDo.setCreateTime(now);
        uocChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL);
        uocChngOrderDo.setTenantId(reqBo.getTenantId());
        ArrayList<UocChngOrderObj> uocChngOrderObjList = new ArrayList<UocChngOrderObj>();
        UocChngOrderObj uocChngOrderObj = new UocChngOrderObj();
        uocChngOrderObj.setOrderId(reqBo.getOrderId());
        uocChngOrderObj.setChngOrderObjId(IdUtil.nextId());
        uocChngOrderObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
        uocChngOrderObj.setChngType(UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL);
        uocChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
        uocChngOrderObj.setCreateTime(now);
        uocChngOrderObj.setCreateOperId(reqBo.getUserId().toString());
        uocChngOrderObj.setOtherChngValue(uocSaleOrderDo.getSaleOrderState());
        ArrayList<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<UocChngOrderItemObj>();
        List<UocSaleOrderItem> saleOrderItemList = this.getSaleOrderItemList(reqBo);
        saleOrderItemList.forEach(uocSaleOrderItem -> {
            UocChngOrderItemObj uocChngOrderItemObj = new UocChngOrderItemObj();
            uocChngOrderItemObj.setSaleOrderItemId(uocSaleOrderItem.getSaleOrderItemId());
            uocChngOrderItemObj.setId(IdUtil.nextId());
            uocChngOrderItemObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
            uocChngOrderItemObj.setChngOrderObjId(uocChngOrderObj.getChngOrderObjId());
            uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
            uocChngOrderItemObj.setCreateTime(now);
            uocChngOrderItemObj.setCreateOperId(reqBo.getUserId().toString());
            uocChngOrderItemObjList.add(uocChngOrderItemObj);
        });
        uocChngOrderObj.setUocChngOrderItemObjList(uocChngOrderItemObjList);
        uocChngOrderObjList.add(uocChngOrderObj);
        uocChngOrderDo.setUocChngOrderObjList(uocChngOrderObjList);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAccessoryAddBoList())) {
            List<UocOrderAccessory> orderAccessoryBoList = UocRu.jsl(reqBo.getAccessoryAddBoList(), UocOrderAccessory.class);
            orderAccessoryBoList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setObjId(uocChngOrderDo.getChngOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setCreateTime(now);
            });
            uocChngOrderDo.setOrderAccessoryBoList(orderAccessoryBoList);
        }
        return uocChngOrderDo;
    }

    private List<UocSaleOrderItem> getSaleOrderItemList(UocCancelApplySaleOrderReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(saleOrderItemList)) {
            throw new BaseBusinessException("101009", "\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u4e3a\u7a7a");
        }
        return saleOrderItemList;
    }

    private String getChngOrderNo(UocSaleOrderDo uocSaleOrderDo) {
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL);
        uocChngOrderQryBo.setOrderSource(uocSaleOrderDo.getOrderSource());
        UocChngOrderDo uocChngOrderDo = this.iUocChngOrderModel.getChngOrderNo(uocChngOrderQryBo);
        return uocChngOrderDo.getChngOrderNo();
    }

    private UocSaleOrderDo getUocSaleOrderDo(UocCancelApplySaleOrderReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("101009", "\u67e5\u8be2\u9a8c\u6536\u5355\u4e3a\u7a7a");
        }
        return uocSaleOrderDo;
    }

    private List<UocOrderAccessory> convertSaleOrderAccessory(UocCancelApplySaleOrderReqBo reqBo, Date now) {
        List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getAccessoryAddBoList(), UocOrderAccessory.class);
        uocOrderAccessoryList.forEach(each -> {
            each.setId(IdUtil.nextId());
            each.setObjId(reqBo.getSaleOrderId());
            each.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            each.setOrderId(reqBo.getOrderId());
            each.setCreateTime(now);
            each.setCreateOperId(reqBo.getUserId().toString());
        });
        return uocOrderAccessoryList;
    }

    private UocSaleOrderDo convertSaleOrderDo(UocCancelApplySaleOrderReqBo reqBo, Date now) {
        UocSaleOrderDo uocSaleOrderDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocSaleOrderDo.setCancelOperId(reqBo.getUserId().toString());
        uocSaleOrderDo.setCancelRequestTime(now);
        uocSaleOrderDo.setCancelReason(reqBo.getCancelReason());
        uocSaleOrderDo.setSaleOrderState("XS_QX_QXSQ");
        return uocSaleOrderDo;
    }

    private void dealMap(UocCancelApplySaleOrderReqBo reqBo, Date now) {
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtDeleteList())) {
            UocChngOrderDo delChngOrderDo = new UocChngOrderDo();
            ArrayList<UocChngOrderMap> extParallelBoList = new ArrayList<UocChngOrderMap>();
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                UocChngOrderMap uocChngOrderMap = new UocChngOrderMap();
                uocChngOrderMap.setOrderId(reqBo.getOrderId());
                uocChngOrderMap.setChngOrderId(uocBaseExtParallelDeleteBo.getObjId());
                uocChngOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
                uocChngOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                uocChngOrderMap.setUpdateTime(now);
                extParallelBoList.add(uocChngOrderMap);
            });
            delChngOrderDo.setUocChngOrderMapList(extParallelBoList);
            this.iUocChngOrderModel.updateInvalid(delChngOrderDo);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtEditList())) {
            UocChngOrderDo add = new UocChngOrderDo();
            UocChngOrderDo modify = new UocChngOrderDo();
            ArrayList<UocChngOrderMap> addList = new ArrayList<UocChngOrderMap>();
            ArrayList<UocChngOrderMap> modifyList = new ArrayList<UocChngOrderMap>();
            reqBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
                    UocChngOrderMap addShipOrderMap = new UocChngOrderMap();
                    addShipOrderMap.setChngOrderId(uocBaseExtParallelEditBo.getObjId());
                    addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
                    addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    addShipOrderMap.setOrderId(reqBo.getOrderId());
                    addShipOrderMap.setId(IdUtil.nextId());
                    addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                    addShipOrderMap.setCreateTime(now);
                    addList.add(addShipOrderMap);
                } else {
                    UocChngOrderMap updateShipOrderMap = new UocChngOrderMap();
                    updateShipOrderMap.setChngOrderId(uocBaseExtParallelEditBo.getObjId());
                    updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    updateShipOrderMap.setOrderId(reqBo.getOrderId());
                    updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                    updateShipOrderMap.setUpdateTime(now);
                    modifyList.add(updateShipOrderMap);
                }
            });
            if (!CollectionUtils.isEmpty(addList)) {
                add.setUocChngOrderMapList(addList);
                this.iUocChngOrderModel.addChngOrderMap(add);
            }
            if (!CollectionUtils.isEmpty(modifyList)) {
                modify.setUocChngOrderMapList(modifyList);
                this.iUocChngOrderModel.updateBatchValue(modify);
            }
        }
    }

    private void validateArg(UocCancelApplySaleOrderReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCancelApplySaleOrderReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCancelReason())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d6\u6d88\u539f\u56e0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7528\u6237ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtDeleteList())) {
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                    throw new BaseBusinessException("100001", "\u8981\u5220\u9664\u7684\u6269\u5c55\u5c5e\u6027\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                    throw new BaseBusinessException("100001", "\u8981\u5220\u9664\u7684\u6269\u5c55\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtEditList())) {
            reqBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
                    throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u7f16\u8f91\u64cd\u4f5c\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u7f16\u8f91\u64cd\u4f5c\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4ec5\u652f\u6301\u65b0\u589e\u548c\u4fee\u6539");
                }
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldValue())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
            });
        }
    }
}

