/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfItemMapQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderMapQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderObjQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfItemMap;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderMap;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UocEsSyncAf
implements IUocEsSync {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncAf.class);
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public String indexName() {
        return this.uocIndexConfig.getAfOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
        rspBo.setObjId(reqBo.getObjId());
        UocAfOrder afOrderMain = this.getAfOrderMain(reqBo);
        if (ObjectUtil.isNull((Object)afOrderMain)) {
            return rspBo;
        }
        List<UocAfOrderMap> afOrderMapList = this.getAfOrderMapList(reqBo);
        List<UocAfOrderObj> afOrderObjList = this.getAfOrderObjList(reqBo);
        List<UocAfOrderItem> afOrderItemList = this.getAfOrderItemList(reqBo);
        List<UocAfItemMap> afOrderItemMapList = this.getAfOrderItemMapList(reqBo);
        ConcurrentMap<Object, Object> afItemMap = new ConcurrentHashMap();
        if (ObjectUtil.isNotEmpty(afOrderItemMapList)) {
            afItemMap = afOrderItemMapList.stream().collect(Collectors.groupingByConcurrent(UocAfItemMap::getAfOrderItemId));
        }
        List<UocOrderAccessory> orderAccessoryList = this.getOrderAccessoryList(reqBo);
        UocAfOrderDo uocAfOderDo = UocRu.js(afOrderMain, UocAfOrderDo.class);
        this.translateAfMain(uocAfOderDo);
        uocAfOderDo.setAfOrderObjList(afOrderObjList);
        uocAfOderDo.setOrderAccessoryBoList(orderAccessoryList);
        Map<Long, UocSaleOrderItem> saleItemMap = this.getSaleItem(uocAfOderDo);
        JSONObject afOrderObj = JSON.parseObject((String)JSON.toJSONString((Object)uocAfOderDo));
        if (ObjectUtil.isNotEmpty(afOrderMapList)) {
            afOrderMapList.forEach(each -> afOrderObj.put(each.getFieldCode(), (Object)each.getFieldValue()));
        }
        JSONArray afItemArray = new JSONArray();
        if (ObjectUtil.isNotEmpty(afOrderItemList)) {
            for (UocAfOrderItem item : afOrderItemList) {
                this.translateAfItem(item);
                JSONObject afItemObj = JSON.parseObject((String)JSON.toJSONString((Object)item));
                if (ObjectUtil.isNotEmpty(afItemMap) && afItemMap.containsKey(item.getAfOrderItemId())) {
                    ((List)afItemMap.get(item.getAfOrderItemId())).forEach(each -> afItemObj.put(each.getFieldCode(), (Object)each.getFieldValue()));
                }
                if (ObjectUtil.isNotEmpty(saleItemMap) && saleItemMap.containsKey(item.getOrderItemId())) {
                    this.putSaleItemInfo(afItemObj, saleItemMap.get(item.getOrderItemId()));
                }
                afItemArray.add((Object)afItemObj);
            }
        }
        afOrderObj.put("afOrderItemBoList", (Object)afItemArray);
        rspBo.setJsonObj(afOrderObj);
        log.info("\u552e\u540e\u5355ES\u6570\u636e\uff1a{}", (Object)afOrderObj.toJSONString());
        return rspBo;
    }

    private void translateAfItem(UocAfOrderItem item) {
        Map<String, Map<String, String>> dicMap = this.getDic();
        if (ObjectUtil.isNotNull((Object)item.getIshaspackage())) {
            item.setIshaspackageStr(dicMap.get("UOC_ORD_IS_HAS_PACKAGE").get(item.getIshaspackage().toString()));
        }
        if (ObjectUtil.isNotNull((Object)item.getPackageDesc())) {
            item.setPackageDescStr(dicMap.get("UOC_ORD_PACKAGE_DECRIP").get(item.getPackageDesc().toString()));
        }
        if (ObjectUtil.isNotNull((Object)item.getDelTag())) {
            item.setDelTagStr(dicMap.get("UOC_ORD_DEL_TAG").get(item.getDelTag().toString()));
        }
    }

    private void translateAfMain(UocAfOrderDo uocAfOderDo) {
        Map<String, Map<String, String>> dicMap = this.getDic();
        if (ObjectUtil.isNotEmpty(dicMap)) {
            if (ObjectUtil.isNotNull((Object)uocAfOderDo.getServType())) {
                uocAfOderDo.setServTypeStr(dicMap.get("UOC_ORD_SERVICE_TYPE").get(uocAfOderDo.getServType().toString()));
            }
            if (ObjectUtil.isNotNull((Object)uocAfOderDo.getServState())) {
                uocAfOderDo.setServStateStr(dicMap.get("UOC_ORD_SERVICE_STATE").get(uocAfOderDo.getServState().toString()));
            }
            if (ObjectUtil.isNotNull((Object)uocAfOderDo.getIsCancel())) {
                uocAfOderDo.setIsCancelStr(dicMap.get("UOC_ORD_IS_CANCEL").get(uocAfOderDo.getIsCancel().toString()));
            }
            uocAfOderDo.setPayTypeStr(dicMap.get("UOC_SALE_ORDER_PAY_TYPE").get(uocAfOderDo.getPayType()));
            if (ObjectUtil.isNotNull((Object)uocAfOderDo.getPayState())) {
                uocAfOderDo.setPayStateStr(dicMap.get("UOC_SALE_ORDER_PAY_STATE").get(uocAfOderDo.getPayState().toString()));
            }
            if (ObjectUtil.isNotNull((Object)uocAfOderDo.getPickwareType())) {
                uocAfOderDo.setPickwareTypeStr(dicMap.get("UOC_ORD_PICKWARE_SERVE_TYPE").get(uocAfOderDo.getPickwareType().toString()));
            }
            if (ObjectUtil.isNotNull((Object)uocAfOderDo.getCancelFlag())) {
                uocAfOderDo.setCancelFlagStr(dicMap.get("UOC_COMMON_CANCEL_FLAG").get(uocAfOderDo.getCancelFlag().toString()));
            }
            if (ObjectUtil.isNotNull((Object)uocAfOderDo.getDelTag())) {
                uocAfOderDo.setDelTagStr(dicMap.get("UOC_ORD_DEL_TAG").get(uocAfOderDo.getDelTag().toString()));
            }
            if (ObjectUtil.isNotNull((Object)uocAfOderDo.getCancelType())) {
                uocAfOderDo.setCancelTypeStr(dicMap.get("UOC_ORD_CANCEL_TYPE").get(uocAfOderDo.getCancelType().toString()));
            }
            uocAfOderDo.setServiceStepStr(dicMap.get("UOC_ORD_SERVICE_STEP").get(uocAfOderDo.getServiceStep()));
        }
    }

    private List<UocOrderAccessory> getOrderAccessoryList(IUocEsSyncQryReqBo reqBo) {
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
        uocOrderAccessoryQryBo.setObjId(reqBo.getObjId());
        uocOrderAccessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        uocOrderAccessoryQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocOrderModel.getOrderAccessoryList(uocOrderAccessoryQryBo);
    }

    private List<UocShipOrderItem> getListShipOrderItem(UocSaleOrderItem reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderItemQryBo.setSaleOrderItemId(reqBo.getSaleOrderItemId());
        UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        return ObjectUtil.isNotNull((Object)uocShipOrderDo) ? uocShipOrderDo.getShipOrderItemBoList() : new ArrayList<UocShipOrderItem>();
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("UOC_ORD_SERVICE_TYPE");
        pCodes.add("UOC_ORD_SERVICE_STATE");
        pCodes.add("UOC_ORD_IS_CANCEL");
        pCodes.add("UOC_SALE_ORDER_PAY_TYPE");
        pCodes.add("UOC_SALE_ORDER_PAY_STATE");
        pCodes.add("UOC_COMMON_CANCEL_FLAG");
        pCodes.add("UOC_ORD_DEL_TAG");
        pCodes.add("UOC_ORD_CANCEL_TYPE");
        pCodes.add("UOC_ORD_PICKWARE_SERVE_TYPE");
        pCodes.add("UOC_ORD_SERVICE_STEP");
        pCodes.add("UOC_ORD_IS_HAS_PACKAGE");
        pCodes.add("UOC_ORD_PACKAGE_DECRIP");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    private void putSaleItemInfo(JSONObject afItemObj, UocSaleOrderItem uocSaleOrderItem) {
        afItemObj.put("commodityId", (Object)uocSaleOrderItem.getCommodityId());
        afItemObj.put("commodityName", (Object)uocSaleOrderItem.getCommodityName());
        afItemObj.put("skuName", (Object)uocSaleOrderItem.getSkuName());
        afItemObj.put("skuId", (Object)uocSaleOrderItem.getSkuId());
        afItemObj.put("skuExtSkuId", (Object)uocSaleOrderItem.getSkuExtSkuId());
        afItemObj.put("skuMaterialId", (Object)uocSaleOrderItem.getSkuMaterialId());
        afItemObj.put("skuMainPicUrl", (Object)uocSaleOrderItem.getSkuMainPicUrl());
        afItemObj.put("skuMaterialName", (Object)uocSaleOrderItem.getSkuMaterialName());
        afItemObj.put("skuMaterialTypeId", (Object)uocSaleOrderItem.getSkuMaterialTypeId());
        afItemObj.put("skuMaterialTypeName", (Object)uocSaleOrderItem.getSkuMaterialTypeName());
        afItemObj.put("unitName", (Object)uocSaleOrderItem.getUnitName());
        afItemObj.put("model", (Object)uocSaleOrderItem.getModel());
        afItemObj.put("spec", (Object)uocSaleOrderItem.getSpec());
        afItemObj.put("tax", (Object)uocSaleOrderItem.getTax());
        afItemObj.put("taxId", (Object)uocSaleOrderItem.getTaxId());
        afItemObj.put("taxPrice", (Object)uocSaleOrderItem.getTaxPrice());
        afItemObj.put("skuBrandId", (Object)uocSaleOrderItem.getSkuBrandId());
        afItemObj.put("skuBrandName", (Object)uocSaleOrderItem.getSkuBrandName());
        afItemObj.put("l1Catalog", (Object)uocSaleOrderItem.getL1Catalog());
        afItemObj.put("l1CatalogName", (Object)uocSaleOrderItem.getL1CatalogName());
        afItemObj.put("l2Catalog", (Object)uocSaleOrderItem.getL2Catalog());
        afItemObj.put("l2CatalogName", (Object)uocSaleOrderItem.getL2CatalogName());
        afItemObj.put("l3Catalog", (Object)uocSaleOrderItem.getL3Catalog());
        afItemObj.put("l3CatalogName", (Object)uocSaleOrderItem.getL3CatalogName());
        afItemObj.put("salePrice", (Object)uocSaleOrderItem.getSalePrice());
        List<UocShipOrderItem> shipOrderItemList = this.getListShipOrderItem(uocSaleOrderItem);
        if (ObjectUtil.isNotEmpty(shipOrderItemList)) {
            afItemObj.put("saleFee", (Object)uocSaleOrderItem.getSalePrice().multiply(shipOrderItemList.get(0).getSendCount()));
            afItemObj.put("purFee", (Object)uocSaleOrderItem.getPurchasePrice().multiply(shipOrderItemList.get(0).getSendCount()));
        }
        afItemObj.put("purPrice", (Object)uocSaleOrderItem.getPurchasePrice());
        afItemObj.put("purchaseCount", (Object)uocSaleOrderItem.getPurchaseCount());
    }

    private Map<Long, UocSaleOrderItem> getSaleItem(UocAfOrderDo uocAfOderDo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(uocAfOderDo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(uocAfOderDo.getOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            return saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getOrderItemId, o -> o, (k1, k2) -> k2));
        }
        return new HashMap<Long, UocSaleOrderItem>();
    }

    private List<UocAfOrderObj> getAfOrderObjList(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderObjQryBo uocAfOrderObjQryBo = new UocAfOrderObjQryBo();
        uocAfOrderObjQryBo.setAfOrderId(reqBo.getObjId());
        uocAfOrderObjQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocAfOrderModel.getAfOrderObjList(uocAfOrderObjQryBo);
    }

    private List<UocAfOrderItem> getAfOrderItemList(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderItemQryBo uocAfOrderItemQryBo = new UocAfOrderItemQryBo();
        uocAfOrderItemQryBo.setAfOrderId(reqBo.getObjId());
        uocAfOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocAfOrderModel.getAfOrderItemList(uocAfOrderItemQryBo);
    }

    private List<UocAfItemMap> getAfOrderItemMapList(IUocEsSyncQryReqBo reqBo) {
        UocAfItemMapQryBo uocAfItemMapQryBo = new UocAfItemMapQryBo();
        uocAfItemMapQryBo.setAfOrderId(reqBo.getObjId());
        uocAfItemMapQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocAfOrderModel.getAfOrderItemMapList(uocAfItemMapQryBo);
    }

    private List<UocAfOrderMap> getAfOrderMapList(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderMapQryBo uocAfOrderMapQryBo = new UocAfOrderMapQryBo();
        uocAfOrderMapQryBo.setAfOrderId(reqBo.getObjId());
        uocAfOrderMapQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocAfOrderModel.getAfOrderMapList(uocAfOrderMapQryBo);
    }

    private UocAfOrder getAfOrderMain(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setAfOrderId(reqBo.getObjId());
        uocAfOrderQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
    }
}

