/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.model.implorder.IUocImplOrderModel;
import com.tydic.dyc.oc.model.implorder.UocImplOrderDo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderItemQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderQryBo;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UocEsSyncInsp
implements IUocEsSync {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncInsp.class);
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocImplOrderModel iUocImplOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    private static final String ES_INSP_ORDER_ITEM_KEY = "uocInspOrderItemList";
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public String indexName() {
        return this.uocIndexConfig.getInspOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        UocInspOrderDo inspOderItem;
        IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
        iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
        UocInspOrderDo inspOrderMain = this.getInspOrderMain(reqBo);
        if (null == inspOrderMain) {
            return iUocEsSyncQryRspBo;
        }
        JSONObject inspOrderJson = JSON.parseObject((String)JSON.toJSONString((Object)inspOrderMain));
        if (!CollectionUtils.isEmpty(inspOrderMain.getExtParallelBoList())) {
            inspOrderMain.getExtParallelBoList().forEach(uocInspOrderMap -> inspOrderJson.put(uocInspOrderMap.getFieldCode(), (Object)uocInspOrderMap.getFieldValue()));
        }
        if (!CollectionUtils.isEmpty((inspOderItem = this.getInspOderItem(inspOrderMain)).getUocInspOrderItemList())) {
            Map<Long, UocSaleOrderItem> saleItemMap = this.getSaleItem(inspOrderMain);
            UocImplOrderDo implOrderItem = this.getListImplOrderItem(inspOderItem);
            Map<Long, UocShipOrderItem> shipOrderItemMap = this.getListShipOrderItem(inspOderItem);
            Map<Long, UocImplOrderItem> uocImplOrderItemMap = implOrderItem.getUocImplOrderItemList().stream().collect(Collectors.toMap(UocImplOrderItem::getImplOrderItemId, o -> o));
            JSONArray inspOrdeItemArray = new JSONArray();
            inspOderItem.getUocInspOrderItemList().forEach(uocInspOrderItem -> {
                JSONObject inspOrderItemJson = JSON.parseObject((String)JSON.toJSONString((Object)uocInspOrderItem));
                if (!CollectionUtils.isEmpty(uocInspOrderItem.getItemExtParallelBoList())) {
                    uocInspOrderItem.getItemExtParallelBoList().forEach(uocInspItemMap -> inspOrderItemJson.put(uocInspItemMap.getFieldCode(), (Object)uocInspItemMap.getFieldValue()));
                }
                this.putSaleItem(inspOrderItemJson, (UocSaleOrderItem)saleItemMap.get(uocInspOrderItem.getSaleOrderItemId()));
                this.putShipItem(inspOrderItemJson, (UocShipOrderItem)shipOrderItemMap.get(uocInspOrderItem.getShipOrderItemId()));
                inspOrdeItemArray.add((Object)inspOrderItemJson);
                inspOrderJson.put("purPrice", (Object)((UocImplOrderItem)uocImplOrderItemMap.get(uocInspOrderItem.getImplOrderItemId())).getPurchasePrice());
                inspOrderJson.put("salePrice", (Object)((UocImplOrderItem)uocImplOrderItemMap.get(uocInspOrderItem.getImplOrderItemId())).getSalePrice());
            });
            inspOrderJson.put(ES_INSP_ORDER_ITEM_KEY, (Object)inspOrdeItemArray);
        }
        this.putSaleOrder(inspOrderMain, inspOrderJson);
        UocImplOrderDo implOrderMain = this.getImplOrderMain(inspOrderMain);
        inspOrderJson.put("implOrderNo", (Object)(null == implOrderMain ? "" : implOrderMain.getImplOrderNo()));
        this.putShipOrder(inspOrderMain, inspOrderJson);
        this.putStr(inspOrderJson, inspOrderMain);
        iUocEsSyncQryRspBo.setJsonObj(inspOrderJson);
        return iUocEsSyncQryRspBo;
    }

    private void putSaleOrder(UocInspOrderDo inspOrderMain, JSONObject inspOrderJson) {
        UocSaleOrderDo saleOrder = this.getSaleOrder(inspOrderMain);
        if (null != saleOrder) {
            inspOrderJson.put("saleOrderNo", (Object)saleOrder.getSaleOrderNo());
            this.putSaleStakeholder(saleOrder, inspOrderJson);
        }
    }

    private void putStr(JSONObject inspOrderJson, UocInspOrderDo inspOrderMain) {
        Map<String, Map<String, String>> dicMap = this.getDic();
        Map<String, String> stateMap = dicMap.get("INSP_ORDER_STATE");
        inspOrderJson.put("inspOrderStateStr", (Object)(ObjectUtil.isNotEmpty(stateMap) ? stateMap.get(inspOrderMain.getInspOrderState()) : ""));
        inspOrderJson.put("saleOrderId", (Object)(ObjectUtil.isNotEmpty((Object)inspOrderJson.get((Object)"saleOrderId")) ? inspOrderMain.getSaleOrderId().toString() : ""));
        inspOrderJson.put("implOrderId", (Object)(ObjectUtil.isNotEmpty((Object)inspOrderJson.get((Object)"implOrderId")) ? inspOrderMain.getImplOrderId().toString() : ""));
    }

    private void putShipItem(JSONObject inspOrderItemJson, UocShipOrderItem uocShipOrderItem) {
        if (null != uocShipOrderItem) {
            inspOrderItemJson.put("sendCount", (Object)uocShipOrderItem.getSendCount());
        }
    }

    private void putSaleStakeholder(UocSaleOrderDo saleOrder, JSONObject inspOrderJson) {
        UocSaleStakeholder uocSaleStakeholder = saleOrder.getStakeholder();
        if (null != uocSaleStakeholder) {
            inspOrderJson.put("supNo", (Object)uocSaleStakeholder.getSupNo());
            inspOrderJson.put("supId", (Object)uocSaleStakeholder.getSupId());
            inspOrderJson.put("supName", (Object)uocSaleStakeholder.getSupName());
        }
    }

    private void putShipOrder(UocInspOrderDo inspOrderMain, JSONObject inspOrderJson) {
        List<UocShipOrderDo> uocShipOrderDoList = this.getListShipOrder(inspOrderMain);
        if (!CollectionUtils.isEmpty(uocShipOrderDoList)) {
            ArrayList shipOrderNoList = new ArrayList();
            ArrayList shipOrderIdList = new ArrayList();
            uocShipOrderDoList.forEach(uocShipOrderDo -> {
                shipOrderNoList.add(uocShipOrderDo.getShipOrderNo());
                if (null != uocShipOrderDo.getShipOrderId()) {
                    shipOrderIdList.add(uocShipOrderDo.getShipOrderId().toString());
                }
            });
            inspOrderJson.put("shipOrderNo", shipOrderNoList);
            inspOrderJson.put("shipOrderId", shipOrderIdList);
        }
    }

    private List<UocShipOrderDo> getListShipOrder(UocInspOrderDo uocInspOrderDo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setShipOrderIdList(uocInspOrderDo.getUocShipInspRelList().stream().map(UocShipInspRel::getShipOrderId).collect(Collectors.toList()));
        return this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }

    private Map<Long, UocShipOrderItem> getListShipOrderItem(UocInspOrderDo uocInspOrderDo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderItemIdList(uocInspOrderDo.getUocInspOrderItemList().stream().map(UocInspOrderItem::getShipOrderItemId).collect(Collectors.toList()));
        UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        if (!CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
            return uocShipOrderDo.getShipOrderItemBoList().stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        }
        return new HashMap<Long, UocShipOrderItem>();
    }

    private Map<Long, UocSaleOrderItem> getSaleItem(UocInspOrderDo uocInspOrderDo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(uocInspOrderDo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(uocInspOrderDo.getOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            return saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        }
        return new HashMap<Long, UocSaleOrderItem>();
    }

    private void putSaleItem(JSONObject inspOrderItemJson, UocSaleOrderItem uocSaleOrderItem) {
        if (null != uocSaleOrderItem) {
            inspOrderItemJson.put("commodityId", (Object)uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put("commodityName", (Object)uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put("skuName", (Object)uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put("skuMaterialId", (Object)uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put("skuMainPicUrl", (Object)uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put("skuMaterialName", (Object)uocSaleOrderItem.getSkuMaterialName());
            inspOrderItemJson.put("skuMaterialTypeId", (Object)uocSaleOrderItem.getSkuMaterialTypeId());
            inspOrderItemJson.put("skuMaterialTypeName", (Object)uocSaleOrderItem.getSkuMaterialTypeName());
            inspOrderItemJson.put("model", (Object)uocSaleOrderItem.getModel());
            inspOrderItemJson.put("spec", (Object)uocSaleOrderItem.getSpec());
            inspOrderItemJson.put("tax", (Object)uocSaleOrderItem.getTax());
            inspOrderItemJson.put("taxId", (Object)uocSaleOrderItem.getTaxId());
            inspOrderItemJson.put("taxPrice", (Object)uocSaleOrderItem.getTaxPrice());
            inspOrderItemJson.put("l1Catalog", (Object)uocSaleOrderItem.getL1Catalog());
            inspOrderItemJson.put("l1CatalogName", (Object)uocSaleOrderItem.getL1CatalogName());
            inspOrderItemJson.put("l2Catalog", (Object)uocSaleOrderItem.getL2Catalog());
            inspOrderItemJson.put("l2CatalogName", (Object)uocSaleOrderItem.getL2CatalogName());
            inspOrderItemJson.put("l3Catalog", (Object)uocSaleOrderItem.getL3Catalog());
            inspOrderItemJson.put("l3CatalogName", (Object)uocSaleOrderItem.getL3CatalogName());
            inspOrderItemJson.put("salePrice", (Object)uocSaleOrderItem.getSalePrice());
            inspOrderItemJson.put("purchaseCount", (Object)uocSaleOrderItem.getPurchaseCount());
        }
    }

    private UocInspOrderDo getInspOderItem(UocInspOrderDo inspOrderMain) {
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setInspOrderId(inspOrderMain.getInspOrderId());
        uocInspOrderItemQryBo.setOrderId(inspOrderMain.getOrderId());
        return this.iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
    }

    private UocInspOrderDo getInspOrderMain(IUocEsSyncQryReqBo reqBo) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setInspOrderId(reqBo.getObjId());
        uocInspOrderQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
    }

    private UocImplOrderDo getImplOrderMain(UocInspOrderDo uocInspOrderDo) {
        UocImplOrderQryBo uocImplOrderQryBo = new UocImplOrderQryBo();
        uocImplOrderQryBo.setImplOrderId(uocInspOrderDo.getImplOrderId());
        uocImplOrderQryBo.setOrderId(uocInspOrderDo.getOrderId());
        return this.iUocImplOrderModel.getImplOrderMain(uocImplOrderQryBo);
    }

    private UocImplOrderDo getListImplOrderItem(UocInspOrderDo uocInspOrderDo) {
        UocImplOrderItemQryBo uocImplOrderItemQryBo = new UocImplOrderItemQryBo();
        uocImplOrderItemQryBo.setImplOrderItemIdList(uocInspOrderDo.getUocInspOrderItemList().stream().map(UocInspOrderItem::getImplOrderItemId).filter(Objects::nonNull).collect(Collectors.toList()));
        uocImplOrderItemQryBo.setOrderId(uocInspOrderDo.getOrderId());
        return this.iUocImplOrderModel.getListImplOrderItem(uocImplOrderItemQryBo);
    }

    private UocSaleOrderDo getSaleOrder(UocInspOrderDo uocInspOrderDo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(uocInspOrderDo.getSaleOrderId());
        uocSaleOrderQryBo.setOrderId(uocInspOrderDo.getOrderId());
        return this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("INSP_ORDER_STATE");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }
}

