/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.config.mq.consumer;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.datasync.event.bo.ChannelEvent;
import com.tydic.dyc.base.events.Event;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.EventConsumerManger;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UocSaleOrderSyncConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(UocSaleOrderSyncConsumer.class);
    private Logger logger = LoggerFactory.getLogger(UocSaleOrderSyncConsumer.class);
    @Autowired
    private UocEsSyncManager SyncManager;
    @Autowired
    private EventConsumerManger eventConsumerManger;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        String content = proxyMessage.getContent();
        log.info("es\u6d88\u8d39\u8005\u6536\u5230\uff0c\u6570\u636e\u5185\u5bb9\u5982\u4e0b");
        log.info(content);
        try {
            ChannelEvent eventList;
            List events;
            if (ObjectUtil.isNotEmpty((Object)content) && ObjectUtil.isNotEmpty((Object)(events = (eventList = (ChannelEvent)JSON.parseObject((String)content, ChannelEvent.class)).getTraceEventList()))) {
                for (Event event : events) {
                    String eventCode = event.getCode();
                    Map paramMap = event.getParamMap();
                    EventConsumer eventConsumer = this.eventConsumerManger.getEventConsumer(eventCode);
                    List<IUocEsSyncQryEventReqBo> eventReqBos = eventConsumer.parseMap(paramMap);
                    this.validateArg(eventReqBos);
                    if (!ObjectUtil.isNotEmpty(eventReqBos)) continue;
                    for (IUocEsSyncQryEventReqBo eventReqBo : eventReqBos) {
                        UocEsSyncManagerSaveDataReqBo saveDataReqBo;
                        String indexName = eventReqBo.getIndexName();
                        List<IUocEsSyncQryReqBo> dataList = eventReqBo.getDataList();
                        for (IUocEsSyncQryReqBo syncQryReqBo : dataList) {
                            if (!syncQryReqBo.getDelFlag().booleanValue()) continue;
                            saveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
                            saveDataReqBo.setOrderId(syncQryReqBo.getOrderId());
                            saveDataReqBo.setObjId(syncQryReqBo.getObjId());
                            saveDataReqBo.setIndexName(indexName);
                            log.info("\u540c\u6b65\u6570\u636e\u5220\u9664\u53c2\u6570\u5165\u53c2:" + JSON.toJSONString((Object)saveDataReqBo));
                            this.SyncManager.deleteData(saveDataReqBo);
                        }
                        for (IUocEsSyncQryReqBo syncQryReqBo : dataList) {
                            if (syncQryReqBo.getDelFlag().booleanValue()) continue;
                            saveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
                            saveDataReqBo.setOrderId(syncQryReqBo.getOrderId());
                            saveDataReqBo.setObjId(syncQryReqBo.getObjId());
                            saveDataReqBo.setIndexName(indexName);
                            log.info("\u540c\u6b65\u6570\u636e\u4fdd\u5b58\u53c2\u6570\u5165\u53c2:" + JSON.toJSONString((Object)saveDataReqBo));
                            this.SyncManager.saveData(saveDataReqBo);
                        }
                    }
                }
            }
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u540c\u6b65\u6d88\u8d39\u8005\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
    }

    private void validateArg(List<IUocEsSyncQryEventReqBo> reqBo) {
        if (ObjectUtil.isNotEmpty(reqBo) && reqBo == null) {
            throw new BaseBusinessException("100001", "\u4e8b\u4ef6\u6570\u636e\u89e3\u6790\u8fd4\u56de\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (IUocEsSyncQryEventReqBo eventReqBo : reqBo) {
            this.validateEventRsp(eventReqBo);
        }
    }

    private void validateEventRsp(IUocEsSyncQryEventReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[IUocEsSyncQryEventReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getIndexName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7d22\u5f15\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty(reqBo.getDataList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u6570\u636e\u5217\u8868]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (IUocEsSyncQryReqBo syncQryReqBo : reqBo.getDataList()) {
            this.validateSync(syncQryReqBo);
        }
    }

    private void validateSync(IUocEsSyncQryReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[IUocEsSyncQryReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getObjId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5bf9\u8c61id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

