/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.model.insporder.impl;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.UocInspOrderRepository;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocInspOrderModelImpl
implements IUocInspOrderModel {
    @Autowired
    private UocInspOrderRepository uocInspOrderRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @Override
    public void createInspOrder(UocInspOrderDo uocInspOrderDo) {
        this.valDo(uocInspOrderDo);
        this.uocInspOrderRepository.createInspOrder(uocInspOrderDo);
        this.uocCommonRepository.addBatchOrderAccessory(uocInspOrderDo.getUocOrderAccessoryList());
    }

    @Override
    public UocInspOrderDo getInspOrderMain(UocInspOrderQryBo uocInspOrderQryBo) {
        if (null == uocInspOrderQryBo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocInspOrderQryBo.getOrderId()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocInspOrderRepository.getInspOrderMain(uocInspOrderQryBo);
    }

    @Override
    public UocInspOrderDo getListInspOrderItem(UocInspOrderItemQryBo uocInspOrderItemQryBo) {
        if (null == uocInspOrderItemQryBo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocInspOrderItemQryBo.getOrderId()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocInspOrderRepository.getListInspOrderItem(uocInspOrderItemQryBo);
    }

    @Override
    public List<UocInspOrderDo> getListInspOrder(UocInspOrderQryBo uocInspOrderQryBo) {
        if (null == uocInspOrderQryBo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        return this.uocInspOrderRepository.getListInspOrder(uocInspOrderQryBo);
    }

    @Override
    public UocInspOrderDo getInspOrderNo(UocInspOrderDo uocInspOrderDo) {
        if (null == uocInspOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocInspOrderDo.getOrderSource()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter("UOC");
        getBo.setEncodedRuleCode("ORDER_INSPECTION_NO_" + uocInspOrderDo.getOrderSource());
        getBo.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerial = this.encodedSerialGetService.getEncodedSerial(getBo);
        if (CollectionUtils.isEmpty((Collection)encodedSerial.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerial.getSerialNoList().get(0)))) {
            throw new BaseBusinessException("101006", "\u83b7\u53d6\u9a8c\u6536\u5355\u7f16\u7801\u4e3a\u7a7a");
        }
        uocInspOrderDo.setInspOrderNo((String)encodedSerial.getSerialNoList().get(0));
        return uocInspOrderDo;
    }

    private void valDo(UocInspOrderDo uocInspOrderDo) {
        if (null == uocInspOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocInspOrderDo.getOrderId()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

