/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.config.UocInitConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.service.domainservice.UocCreateOrderProcInsUpdateStatusDomainService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderProcInsUpdateStatusDomainServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderProcInsUpdateStatusDomainServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocCreateOrderProcInsUpdateStatusDomainService"})
public class UocCreateOrderProcInsUpdateStatusDomainServiceImpl
implements UocCreateOrderProcInsUpdateStatusDomainService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private UocInitConfig uocInitConfig;
    private static final String FINISH = "-F";

    @PostMapping(value={"createOrderProcIns"})
    public UocCreateOrderProcInsUpdateStatusDomainServiceRspBo createOrderProcIns(@RequestBody UocCreateOrderProcInsUpdateStatusDomainServiceReqBo reqBo) {
        List nextTaskInfos;
        String oldTaskInstId;
        this.validateArg(reqBo);
        if (ObjectUtil.isNotEmpty((Object)reqBo.getProcInstId())) {
            UocOrderProcInst qryInst = new UocOrderProcInst();
            qryInst.setProcInstId(reqBo.getProcInstId());
            qryInst.setOrderId(reqBo.getOrderId());
            List<UocOrderProcInst> uocOrderProcInsts = this.iUocSaleOrderModel.qryProcInsList(qryInst);
            if (ObjectUtil.isEmpty(uocOrderProcInsts)) {
                UocOrderProcInst createSaleProcIns = new UocOrderProcInst();
                createSaleProcIns.setProcInstId(reqBo.getProcInstId());
                createSaleProcIns.setOrderId(reqBo.getOrderId());
                createSaleProcIns.setObjId(reqBo.getObjId());
                createSaleProcIns.setObjType(reqBo.getObjType());
                createSaleProcIns.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                this.iUocSaleOrderModel.createProInst(createSaleProcIns);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)(oldTaskInstId = reqBo.getOldTaskInstId()))) {
            UocOrderTaskInst qryInst = new UocOrderTaskInst();
            qryInst.setOrderId(reqBo.getOrderId());
            qryInst.setTaskInstId(oldTaskInstId);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(qryInst);
            if (ObjectUtil.isEmpty(uocOrderTaskInsts)) {
                throw new BaseBusinessException("101005", "\u4efb\u52a1\u5b9e\u4f8bid(" + oldTaskInstId + ")\u4e0d\u5b58\u5728");
            }
            if (UocDicConstant.PROC_TASK_FINISHED.FINISHED.equals(uocOrderTaskInsts.get(0).getFinishTag())) {
                throw new BaseBusinessException("101005", "\u4efb\u52a1\u5b9e\u4f8bid(" + oldTaskInstId + ")\u5df2\u5b8c\u7ed3");
            }
            ArrayList<UocOrderTaskInst> updateList = new ArrayList<UocOrderTaskInst>();
            UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
            updateList.add(uocOrderTaskInst);
            uocOrderTaskInst.setOrderId(reqBo.getOrderId());
            uocOrderTaskInst.setTaskInstId(oldTaskInstId);
            this.iUocSaleOrderModel.updateProcTaskInstToFinished(updateList);
            if (null != reqBo.getFinish() && reqBo.getFinish().booleanValue()) {
                String flag = FINISH;
                if (!StringUtils.isBlank((CharSequence)reqBo.getOpFlag())) {
                    flag = flag + "-" + reqBo.getOpFlag();
                }
                String state = this.uocInitConfig.getStateByTachecode(uocOrderTaskInsts.get(0).getProcState() + flag, reqBo.getObjType());
                this.updateState(reqBo, state);
                ArrayList<UocOrderTaskInst> saveList = new ArrayList<UocOrderTaskInst>();
                UocOrderTaskInst taskBo = new UocOrderTaskInst();
                taskBo.setId(IdUtil.nextId());
                taskBo.setOrderId(reqBo.getOrderId());
                taskBo.setTaskInstId(String.valueOf(IdUtil.nextId()));
                taskBo.setObjId(reqBo.getObjId());
                taskBo.setObjType(reqBo.getObjType());
                taskBo.setProcState(uocOrderTaskInsts.get(0).getProcState() + FINISH);
                taskBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
                saveList.add(taskBo);
                this.iUocSaleOrderModel.saveProcTaskInst(saveList);
            } else if (CollectionUtils.isEmpty((Collection)reqBo.getNextTaskInfos())) {
                String state = this.uocInitConfig.getStateByTachecode(uocOrderTaskInsts.get(0).getProcState() + "-" + reqBo.getOpFlag(), reqBo.getObjType());
                this.updateState(reqBo, state);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)(nextTaskInfos = reqBo.getNextTaskInfos()))) {
            ArrayList<UocOrderTaskDeal> saveDealList = new ArrayList<UocOrderTaskDeal>();
            ArrayList<UocOrderTaskInst> saveList = new ArrayList<UocOrderTaskInst>();
            for (UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo : nextTaskInfos) {
                UocOrderTaskInst taskBo = new UocOrderTaskInst();
                taskBo.setId(IdUtil.nextId());
                taskBo.setOrderId(reqBo.getOrderId());
                taskBo.setTaskInstId(nextTaskInfo.getTaskInstId());
                taskBo.setObjId(reqBo.getObjId());
                taskBo.setObjType(reqBo.getObjType());
                taskBo.setProcState(nextTaskInfo.getTacheCode());
                taskBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                saveList.add(taskBo);
                String assignee = nextTaskInfo.getAssignee();
                List candidates = nextTaskInfo.getCandidates();
                if (ObjectUtil.isNotEmpty((Object)assignee)) {
                    UocOrderTaskDeal deal = this.assembleTaskDealObj(reqBo, nextTaskInfo);
                    deal.setDealId(assignee);
                    deal.setDealClass("1");
                    saveDealList.add(deal);
                } else if (ObjectUtil.isNotEmpty((Object)candidates)) {
                    for (String candidate : candidates) {
                        UocOrderTaskDeal deal = this.assembleTaskDealObj(reqBo, nextTaskInfo);
                        deal.setDealId(candidate);
                        deal.setDealClass("2");
                        saveDealList.add(deal);
                    }
                }
                String state = this.uocInitConfig.getStateByTachecode(nextTaskInfo.getTacheCode(), reqBo.getObjType());
                this.updateState(reqBo, state);
            }
            if (ObjectUtil.isNotEmpty(saveDealList)) {
                this.iUocSaleOrderModel.saveOrderTaskDealList(saveDealList);
            }
            this.iUocSaleOrderModel.saveProcTaskInst(saveList);
        }
        return UocRu.success(UocCreateOrderProcInsUpdateStatusDomainServiceRspBo.class);
    }

    private void updateState(UocCreateOrderProcInsUpdateStatusDomainServiceReqBo reqBo, String state) {
        if (ObjectUtil.isNotEmpty((Object)state)) {
            if (UocDicConstant.OBJ_TYPE.SHIP.equals(reqBo.getObjType())) {
                UocShipOrderDo updateShipDo = new UocShipOrderDo();
                updateShipDo.setUpdateOperId(reqBo.getUserId().toString());
                updateShipDo.setOrderId(reqBo.getOrderId());
                updateShipDo.setShipOrderId(reqBo.getObjId());
                updateShipDo.setShipOrderState(state);
                this.iUocShipOrderModel.updateShipStatusAndProCode(updateShipDo);
            }
            if (UocDicConstant.OBJ_TYPE.SALE.equals(reqBo.getObjType())) {
                UocSaleOrderDo updateSaleDo = new UocSaleOrderDo();
                updateSaleDo.setUpdateOperId(reqBo.getUserId().toString());
                updateSaleDo.setOrderId(reqBo.getOrderId());
                updateSaleDo.setSaleOrderId(reqBo.getObjId());
                updateSaleDo.setSaleOrderState(state);
                this.iUocSaleOrderModel.updateSaleStatusAndProCode(updateSaleDo);
            }
            if (UocDicConstant.OBJ_TYPE.CHNG.equals(reqBo.getObjType())) {
                UocChngOrderDo updateChngDo = new UocChngOrderDo();
                updateChngDo.setUpdateOperId(reqBo.getUserId().toString());
                updateChngDo.setOrderId(reqBo.getOrderId());
                updateChngDo.setChngOrderId(reqBo.getObjId());
                updateChngDo.setChngOrderState(state);
                this.iUocChngOrderModel.updateShipStatusAndProCode(updateChngDo);
            }
        }
    }

    private UocOrderTaskDeal assembleTaskDealObj(UocCreateOrderProcInsUpdateStatusDomainServiceReqBo reqBo, UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo) {
        UocOrderTaskDeal deal = new UocOrderTaskDeal();
        deal.setId(IdUtil.nextId());
        deal.setTaskInstId(nextTaskInfo.getTaskInstId());
        deal.setOrderId(reqBo.getOrderId());
        deal.setObjId(reqBo.getObjId());
        deal.setObjType(reqBo.getObjType());
        return deal;
    }

    private void validateArg(UocCreateOrderProcInsUpdateStatusDomainServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateSaleProcInsUpdateStatusDomainServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010userId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u8ba2\u5355id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getObjId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u5355\u636eID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getObjType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u5355\u636e\u7c7b\u578b\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getNextTaskInfos())) {
            for (UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo : reqBo.getNextTaskInfos()) {
                this.validateUocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo(nextTaskInfo);
            }
        }
    }

    private void validateUocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo(UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getTaskInstId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u65b0\u4efb\u52a1\u5b9e\u4f8bid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getTacheCode())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u73af\u8282\u7f16\u7801\uff0c\u4f20\u503c\u5c31\u4f1a\u66f4\u65b0\u9500\u552e\u5355\u73af\u8282\u7f16\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

