/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.implorder.IUocImplOrderModel;
import com.tydic.dyc.oc.model.implorder.UocImplOrderDo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderItemQryBo;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.service.domainservice.UocImplShipOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocImplShipOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocImplShipOrderReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocImplShipOrderRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocImplShipOrderService"})
public class UocImplShipOrderServiceImpl
implements UocImplShipOrderService {
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocImplOrderModel iUocImplOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    private static final String OP_FLAG_YES = "1";
    private static final String OP_FLAG_NO = "0";

    @PostMapping(value={"dealImplShipOrder"})
    public UocImplShipOrderRspBo dealImplShipOrder(@RequestBody UocImplShipOrderReqBo reqBo) {
        this.validateArg(reqBo);
        Date now = new Date();
        List<UocImplOrderItem> uocImplOrderItemList = this.getUocImplOrderItemList(reqBo);
        UocSaleOrderDo uocSaleOrderDo = this.getUocSaleOrderDo(reqBo);
        UocShipOrderDo uocShipOrderDo = this.convertShipOrderDo(reqBo, now, uocImplOrderItemList, uocSaleOrderDo);
        this.iUocShipOrderModel.createShipOrder(uocShipOrderDo);
        this.iUocImplOrderModel.modifyBatchItemSendCount(this.convertImplOrderDo(reqBo, now));
        UocImplShipOrderRspBo uocImplShipOrderRspBo = UocRu.success(UocImplShipOrderRspBo.class);
        if ("XS_FH_DFH".equals(uocSaleOrderDo.getSaleOrderState())) {
            this.modifySaleState(reqBo);
        }
        boolean finish = this.checkSaleOrderIsFinish(reqBo);
        uocImplShipOrderRspBo.setFinish(Boolean.valueOf(finish));
        uocImplShipOrderRspBo.setOpFlag(finish ? OP_FLAG_YES : OP_FLAG_NO);
        uocImplShipOrderRspBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        return uocImplShipOrderRspBo;
    }

    private void modifySaleState(UocImplShipOrderReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocSaleOrderDo.setSaleOrderState("XS_FH_FHZ");
        this.iUocSaleOrderModel.updateSaleStatusAndProCode(uocSaleOrderDo);
    }

    private boolean checkSaleOrderIsFinish(UocImplShipOrderReqBo reqBo) {
        UocImplOrderItemQryBo uocImplOrderItemQryBo = new UocImplOrderItemQryBo();
        uocImplOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocImplOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocImplOrderItemQryBo.setImplOrderId(reqBo.getImplOrderId());
        UocImplOrderDo uocImplOrderDo = this.iUocImplOrderModel.getCollectCountImplOrderItem(uocImplOrderItemQryBo);
        if (CollectionUtils.isEmpty(uocImplOrderDo.getUocImplOrderItemList())) {
            throw new BaseBusinessException("101003", "\u67e5\u8be2\u6570\u91cf\u6c47\u603b\u4e3a\u7a7a");
        }
        UocImplOrderItem uocImplOrderItem = uocImplOrderDo.getUocImplOrderItemList().get(0);
        if (null == uocImplOrderItem) {
            throw new BaseBusinessException("101003", "\u67e5\u8be2\u6570\u91cf\u6c47\u603b\u4e3a\u7a7a");
        }
        return uocImplOrderItem.getPurchaseCount().compareTo(uocImplOrderItem.getSendCount().add(uocImplOrderItem.getReturnCount())) == 0;
    }

    private UocImplOrderDo getListImplOrderItem(UocImplShipOrderReqBo reqBo) {
        UocImplOrderItemQryBo uocImplOrderItemQryBo = new UocImplOrderItemQryBo();
        uocImplOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocImplOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocImplOrderDo uocImplOrderDo = this.iUocImplOrderModel.getListImplOrderItem(uocImplOrderItemQryBo);
        if (CollectionUtils.isEmpty(uocImplOrderDo.getUocImplOrderItemList())) {
            throw new BaseBusinessException("101004", "\u67e5\u8be2\u6267\u884c\u660e\u7ec6\u4e3a\u7a7a");
        }
        return uocImplOrderDo;
    }

    private UocImplOrderDo convertImplOrderDo(UocImplShipOrderReqBo reqBo, Date now) {
        UocImplOrderDo uocImplOrderDo = new UocImplOrderDo();
        uocImplOrderDo.setOrderId(reqBo.getOrderId());
        uocImplOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocImplOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocImplOrderDo.setUpdateTime(now);
        uocImplOrderDo.setUocImplOrderItemList(reqBo.getShipOrderItemBoList().stream().map(uocImplShipOrderReqItemBo -> {
            UocImplOrderItem uocImplOrderItem = new UocImplOrderItem();
            uocImplOrderItem.setImplOrderItemId(uocImplShipOrderReqItemBo.getImplOrderItemId());
            uocImplOrderItem.setSendCount(uocImplShipOrderReqItemBo.getSendCount());
            return uocImplOrderItem;
        }).collect(Collectors.toList()));
        return uocImplOrderDo;
    }

    private UocShipOrderDo convertShipOrderDo(UocImplShipOrderReqBo reqBo, Date now, List<UocImplOrderItem> uocImplOrderItemList, UocSaleOrderDo uocSaleOrderDo) {
        Map<Long, UocImplOrderItem> uocImplOrderItemMap = uocImplOrderItemList.stream().collect(Collectors.toMap(UocImplOrderItem::getImplOrderItemId, o -> o));
        UocShipOrderDo uocShipOrderDo = UocRu.js(reqBo, UocShipOrderDo.class);
        uocShipOrderDo.setShipOrderState("FH_FH_FH");
        uocShipOrderDo.setShipOperId(reqBo.getUserId().toString());
        uocShipOrderDo.setCreateOperId(reqBo.getUserId().toString());
        uocShipOrderDo.setCreateTime(now);
        uocShipOrderDo.setShipOrderId(IdUtil.nextId());
        uocShipOrderDo.setSupNo(uocImplOrderItemList.get(0).getSupplierId());
        uocShipOrderDo.setShipOrderNo(this.getShipOrderNo(reqBo, uocSaleOrderDo));
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtParallelBoList())) {
            uocShipOrderDo.getExtParallelBoList().forEach(uocShipOrderMap -> {
                uocShipOrderMap.setId(IdUtil.nextId());
                uocShipOrderMap.setOrderId(reqBo.getOrderId());
                uocShipOrderMap.setSaleOrderId(reqBo.getSaleOrderId());
                uocShipOrderMap.setShipOrderId(uocShipOrderDo.getShipOrderId());
                uocShipOrderMap.setImplOrderId(reqBo.getImplOrderId());
                uocShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                uocShipOrderMap.setCreateTime(now);
            });
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getOrderAccessoryBoList(), UocOrderAccessory.class);
            uocOrderAccessoryList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setCreateTime(now);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
                uocOrderAccessory.setObjId(uocShipOrderDo.getShipOrderId());
            });
            uocShipOrderDo.setOrderAccessoryBoList(uocOrderAccessoryList);
        }
        uocShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
            UocImplOrderItem uocImplOrderItem = (UocImplOrderItem)uocImplOrderItemMap.get(uocShipOrderItem.getImplOrderItemId());
            if (uocShipOrderItem.getSendCount().add(uocImplOrderItem.getSendCount()).compareTo(uocImplOrderItem.getPurchaseCount()) > 0) {
                throw new BaseBusinessException("101002", "\u5b58\u5728\u5df2\u53d1\u8d27\u5b8c\u6210\u7684\u5546\u54c1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5546\u54c1\u53d1\u8d27");
            }
            uocShipOrderItem.setShipOrderId(uocShipOrderDo.getShipOrderId());
            uocShipOrderItem.setOrderId(uocShipOrderDo.getOrderId());
            uocShipOrderItem.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
            uocShipOrderItem.setImplOrderId(uocShipOrderDo.getImplOrderId());
            uocShipOrderItem.setSaleOrderItemId(uocImplOrderItem.getSaleOrderItemId());
            uocShipOrderItem.setUnitName(uocImplOrderItem.getUnitName());
            uocShipOrderItem.setCreateOperId(reqBo.getUserId().toString());
            uocShipOrderItem.setCreateTime(now);
            uocShipOrderItem.setShipOrderItemId(IdUtil.nextId());
            if (!CollectionUtils.isEmpty(uocShipOrderItem.getItemExtParallelBoList())) {
                uocShipOrderItem.getItemExtParallelBoList().forEach(uocShipItemMap -> {
                    uocShipItemMap.setId(IdUtil.nextId());
                    uocShipItemMap.setOrderId(reqBo.getOrderId());
                    uocShipItemMap.setSaleOrderId(reqBo.getSaleOrderId());
                    uocShipItemMap.setImplOrderId(uocShipOrderItem.getImplOrderId());
                    uocShipItemMap.setShipOrderItemId(uocShipOrderItem.getShipOrderItemId());
                    uocShipItemMap.setShipOrderId(uocShipOrderItem.getShipOrderId());
                    uocShipItemMap.setId(IdUtil.nextId());
                    uocShipItemMap.setCreateTime(now);
                    uocShipItemMap.setCreateOperId(reqBo.getUserId().toString());
                });
            }
        });
        return uocShipOrderDo;
    }

    private List<UocImplOrderItem> getUocImplOrderItemList(UocImplShipOrderReqBo reqBo) {
        List<Long> implOrderItemIds = reqBo.getShipOrderItemBoList().stream().map(UocImplShipOrderReqItemBo::getImplOrderItemId).collect(Collectors.toList());
        UocImplOrderItemQryBo uocImplOrderItemQryBo = new UocImplOrderItemQryBo();
        uocImplOrderItemQryBo.setImplOrderItemIdList(implOrderItemIds);
        uocImplOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocImplOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocImplOrderDo uocImplOrderDo = this.iUocImplOrderModel.getListImplOrderItem(uocImplOrderItemQryBo);
        List<UocImplOrderItem> uocImplOrderItemList = uocImplOrderDo.getUocImplOrderItemList();
        if (CollectionUtils.isEmpty(uocImplOrderItemList)) {
            throw new BaseBusinessException("101002", "\u83b7\u53d6\u6267\u884c\u5355\u660e\u7ec6\u4e3a\u7a7a");
        }
        return uocImplOrderItemList;
    }

    private String getShipOrderNo(UocImplShipOrderReqBo reqBo, UocSaleOrderDo uocSaleOrderDo) {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderSource(uocSaleOrderDo.getOrderSource());
        uocShipOrderDo = this.iUocShipOrderModel.getShipOrderNo(uocShipOrderDo);
        return uocShipOrderDo.getShipOrderNo();
    }

    private UocSaleOrderDo getUocSaleOrderDo(UocImplShipOrderReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("101002", "\u67e5\u8be2\u9a8c\u6536\u5355\u4e3a\u7a7a");
        }
        return uocSaleOrderDo;
    }

    private void validateArg(UocImplShipOrderReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getImplOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u6267\u884c\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getShipCompanyNo()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u914d\u9001\u5355\u53f7\u4e3a\u7a7a");
        }
        if (null == reqBo.getShipName()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u8054\u7cfb\u4eba\u4e3a\u7a7a");
        }
        if (null == reqBo.getShipPhone()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8054\u7cfb\u4eba\u7535\u8bdd\u4e3a\u7a7a");
        }
        if (null == reqBo.getShipTime()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u65e5\u671f\u4e3a\u7a7a");
        }
        if (null == reqBo.getEstimateArrivalTime()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9884\u8ba1\u5230\u8d27\u65e5\u671f\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e3a\u7a7a");
        }
    }
}

