package com.tydic.dyc.oc.model.agreeorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.agreeorder.IUocAgreementOrderModel;
import com.tydic.dyc.oc.model.agreeorder.UocOrderAgreementDo;
import com.tydic.dyc.oc.model.agreeorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.repository.UocAgreementOrderRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class IUocAgreementOrderModelImpl implements IUocAgreementOrderModel {

    @Autowired
    private UocAgreementOrderRepository uocAgreementOrderRepository;

    @Override
    public UocOrderAgreementDo getAgreementOrderBy(UocOrderAgreementQryBo uocOrderAgreementQryBo) {
        if (ObjectUtil.isNull(uocOrderAgreementQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAgreementOrderRepository.getAgreementOrderBy(uocOrderAgreementQryBo);
    }

    @Override
    public List<UocOrderAgreementDo> getAgreementOrderList(UocOrderAgreementQryBo uocOrderAgreementQryBo) {
        if (ObjectUtil.isNull(uocOrderAgreementQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAgreementOrderRepository.getAgreementOrderList(uocOrderAgreementQryBo);
    }
}
