package com.tydic.dyc.oc.model.insporder.impl;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocObjNoConstants;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.UocInspOrderRepository;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 标题:UocInspOrderModelImpl
 * 说明:验收单方法实现
 * 时间:2022/2/25 11:34
 * 作者:罗有
 */

@Service
public class UocInspOrderModelImpl implements IUocInspOrderModel {

    @Autowired
    private UocInspOrderRepository uocInspOrderRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @Override
    public void createInspOrder(UocInspOrderDo uocInspOrderDo) {
        valDo(uocInspOrderDo);
        uocInspOrderRepository.createInspOrder(uocInspOrderDo);
        uocCommonRepository.addBatchOrderAccessory(uocInspOrderDo.getUocOrderAccessoryList());
    }

    @Override
    public UocInspOrderDo getInspOrderMain(UocInspOrderQryBo uocInspOrderQryBo) {
        if (null == uocInspOrderQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocInspOrderQryBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        return uocInspOrderRepository.getInspOrderMain(uocInspOrderQryBo);
    }

    @Override
    public UocInspOrderDo getListInspOrderItem(UocInspOrderItemQryBo uocInspOrderItemQryBo) {
        if (null == uocInspOrderItemQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocInspOrderItemQryBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        return uocInspOrderRepository.getListInspOrderItem(uocInspOrderItemQryBo);
    }

    @Override
    public List<UocInspOrderDo> getListInspOrder(UocInspOrderQryBo uocInspOrderQryBo) {
        if (null == uocInspOrderQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
        }
//        if (null == uocInspOrderQryBo.getOrderId()) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID为空");
//        }
        return uocInspOrderRepository.getListInspOrder(uocInspOrderQryBo);
    }

    @Override
    public UocInspOrderDo getInspOrderNo(UocInspOrderDo uocInspOrderDo) {
        if(null == uocInspOrderDo){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocInspOrderDo.getOrderSource()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参来源不能为空");
        }
        CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter(UocObjNoConstants.UOC);
        getBo.setEncodedRuleCode(UocObjNoConstants.ORDER_INSPECTION_NO + "_" + uocInspOrderDo.getOrderSource());
        getBo.setOrgType(UocObjNoConstants.ORG_TYPE);
        CfcEncodedSerialGetServiceRspBO encodedSerial = encodedSerialGetService.getEncodedSerial(getBo);
        if (CollectionUtils.isEmpty(encodedSerial.getSerialNoList()) || StringUtils.isBlank(encodedSerial.getSerialNoList().get(0))) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_NUM_CHNG_APPLY_ERROR, "获取验收单编码为空");
        }
        uocInspOrderDo.setInspOrderNo(encodedSerial.getSerialNoList().get(0));
        return uocInspOrderDo;
    }

    private void valDo(UocInspOrderDo uocInspOrderDo) {
        if (null == uocInspOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocInspOrderDo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
    }
}
