package com.tydic.dyc.oc.model.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.repository.UocOrderRepository;
import com.tydic.dyc.oc.utils.IdUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;


/**
 * 标题:OrderModelmpl
 * 说明:
 * 时间:2022/2/16 11:39
 * 作者:田桂银
 */
@Slf4j
@Service
public class OrderModelmpl implements IUocOrderModel {

    @Autowired
    private UocOrderRepository uocOrderRepository;

    @Override
    public UocOrderDo createOrder(UocOrderDo orderDo) {
        validateCreateOrderArg(orderDo);
        orderDo.setOrderId(IdUtil.nextId());
        orderDo.setCreateTime(new Date());

        //组装地址信息（收货地址，发票地址）
        setAddressInfo(orderDo);

        //组装订单主数据
        setOrderInfo(orderDo);

        //组装发票信息
        UocOrdInvoice uocOrdInvoice = orderDo.getUocOrdInvoice();
        if (ObjectUtil.isNotEmpty(uocOrdInvoice)) {
            uocOrdInvoice.setId(IdUtil.nextId());
            uocOrdInvoice.setOrderId(orderDo.getOrderId());
            uocOrdInvoice.setContactId(orderDo.getInvoiceAddress().getContactId());
            uocOrdInvoice.setCreateOperId(orderDo.getCreateOperId());
            uocOrdInvoice.setCreateTime(orderDo.getCreateTime());
        }

        //组装附件信息
        List<UocOrderAccessory> accessoryList = orderDo.getAccessoryList();
        for (UocOrderAccessory uocOrderAccessory : accessoryList) {
            uocOrderAccessory.setId(IdUtil.nextId());
            uocOrderAccessory.setOrderId(orderDo.getOrderId());
            uocOrderAccessory.setCreateTime(orderDo.getCreateTime());
            uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
            uocOrderAccessory.setObjId(orderDo.getOrderId());
            uocOrderAccessory.setAttachmentType(UocDicConstant.ACCESSORY_TYPE.CREATE_ORDER);
        }

        //设置订单明细信息
        setOrderItemInfo(orderDo);

        return uocOrderRepository.saveUocOrder(orderDo);
    }

    private void validateCreateOrderArg(UocOrderDo orderDo) {
        if (ObjectUtil.isEmpty(orderDo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        List<UocOrderItem> orderItems = orderDo.getOrderItems();

        if (ObjectUtil.isEmpty(orderItems)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[商品列表]不能为空");
        }


    }

    @Override
    public UocOrderDo createOrderAccessory(List<UocOrderAccessory> uocOrderAccessoryList) {
        if (ObjectUtil.isEmpty(uocOrderAccessoryList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.createOrderAccessory(uocOrderAccessoryList);
    }

    private void setOrderItemInfo(UocOrderDo orderDo) {
        //订单明细数据
        List<UocOrderItem> orderItems = orderDo.getOrderItems();


        for (UocOrderItem orderItem : orderItems) {
            orderItem.setOrderItemId(IdUtil.nextId());
            orderItem.setOrderId(orderDo.getOrderId());
            orderItem.setCreateTime(orderDo.getCreateTime());
            orderItem.setCreateOperId(orderDo.getCreateOperId());

            //订单明细扩展数据，可能为空
            List<UocOrderItemMap> itemMapList = orderItem.getItemMapList();
            if (ObjectUtil.isNotEmpty(itemMapList)) {
                for (UocOrderItemMap itemMap : itemMapList) {
                    itemMap.setId(IdUtil.nextId());
                    itemMap.setOrderItemId(orderItem.getOrderItemId());
                    itemMap.setOrderId(orderDo.getOrderId());
                    itemMap.setCreateTime(orderDo.getCreateTime());
                    itemMap.setCreateOperId(orderDo.getCreateOperId());
                }
            }

            //商品延保数据，可能为空
            List<UocOrderItemEw> ewList = orderItem.getEwList();
            if (ObjectUtil.isNotEmpty(ewList)) {
                for (UocOrderItemEw ew : ewList) {
                    ew.setId(IdUtil.nextId());
                    ew.setOrderItemId(orderItem.getOrderItemId());
                    ew.setOrderId(orderDo.getOrderId());
                    ew.setCreateOperId(orderDo.getCreateOperId());
                    ew.setCreateTime(orderDo.getCreateTime());
                    ew.setSkuId(orderItem.getSkuId());
                }
            }

        }

    }


    private void setOrderInfo(UocOrderDo orderDo) {
        //根据是否传入开票对象，判断是否需要开票
        if (ObjectUtil.isNotEmpty(orderDo.getUocOrdInvoice())) {
            orderDo.setNeedInvoiceTag(UocDicConstant.NEED_INVOICED.NEED_INVOICED_Y);
        } else {
            orderDo.setNeedInvoiceTag(UocDicConstant.NEED_INVOICED.NEED_INVOICED_N);
        }

        //设置收货地址id
        orderDo.setContactId(orderDo.getReceiverAddress() != null ? orderDo.getReceiverAddress().getContactId() : null);

        //转换，并保存订单主体数据

        //保存订单扩展数据
        if (ObjectUtil.isNotEmpty(orderDo.getOrderExt())) {
            List<UocOrderMap> orderExt = orderDo.getOrderExt();
            for (UocOrderMap map : orderExt) {
                map.setOrderId(orderDo.getOrderId());
                map.setCreateOperId(orderDo.getCreateOperId());
                map.setId(IdUtil.nextId());
                map.setCreateTime(orderDo.getCreateTime());
            }
        }
    }

    private void setAddressInfo(UocOrderDo orderDo) {
        UocOrdLogisticsRela invoiceAddress = orderDo.getInvoiceAddress();
        if (invoiceAddress != null) {
            invoiceAddress.setOrderId(orderDo.getOrderId());
            invoiceAddress.setContactId(IdUtil.nextId());
            invoiceAddress.setCreateOperId(orderDo.getCreateOperId());
            invoiceAddress.setCreateTime(orderDo.getCreateTime());
        }

        UocOrdLogisticsRela receiverAddress = orderDo.getReceiverAddress();
        if (receiverAddress != null) {
            receiverAddress.setOrderId(orderDo.getOrderId());
            receiverAddress.setContactId(IdUtil.nextId());
            receiverAddress.setCreateOperId(orderDo.getCreateOperId());
            receiverAddress.setCreateTime(orderDo.getCreateTime());
        }
    }

    @Override
    public UocOrderStateChgLog createOrderStateChangeLog(UocOrderStateChgLog uocOrderStateChgLog) {
        if (null == uocOrderStateChgLog) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.createOrderStateChangeLog(uocOrderStateChgLog);
    }

    @Override
    public List<UocOrderStakeholderQryBo> qryStakeholderList(UocOrderStakeholderQryBo qryBo) {
        return uocOrderRepository.qryStakeholderList(qryBo);
    }

    @Override
    public List<UocOrderTaskInst> qryOrderTaskInstList(UocOrderTaskInstQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryOrderTaskInstList(qryBo);
    }

    @Override
    public List<UocOrderTaskDeal> qryOrderTaskDealList(UocOrderTaskDealQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryOrderTaskDealList(qryBo);
    }

    @Override
    public List<UocOrderProcInst> qryOrderProcInstList(UocOrderProcInstQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryOrderProcInstList(qryBo);
    }

    @Override
    public UocOrderDo qryOrderBy(UocOrderDo uocOrderDo) {
        if (null == uocOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryOrderBy(uocOrderDo);
    }

    @Override
    public List<UocOrderItem> qryOrderItemList(UocOrderItemQryBo uocOrderItemQryBo) {
        if (null == uocOrderItemQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryOrderItemList(uocOrderItemQryBo);
    }

    @Override
    public UocOrdLogisticsRela qryOrderLogisticsRela(UocOrdLogisticsRelaQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryOrderLogisticsRela(qryBo);
    }

    @Override
    public UocOrdInvoice qryOrderInvoice(UocOrdInvoiceQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryOrderInvoice(qryBo);
    }

    @Override
    public List<UocOrderAccessory> getOrderAccessoryList(UocOrderAccessoryQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.getOrderAccessoryList(qryBo);
    }

    @Override
    public List<UocOrderMap> qryOrderMapList(UocOrderMapQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryOrderMapList(qryBo);
    }
}


