package com.tydic.dyc.oc.model.saleorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocObjNoConstants;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.*;
import com.tydic.dyc.oc.model.saleorder.sub.*;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.UocSaleOrderRepository;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;


/**
 * 标题:IUocSaleOrderModelImpl
 * 说明:
 * 时间:2022/2/24 18:27
 * 作者:田桂银
 */
@Service
@Slf4j
public class UocSaleOrderModelImpl implements IUocSaleOrderModel {

    @Autowired
    private UocSaleOrderRepository uocSaleOrderRepository;

    @Autowired
    private UocCommonRepository uocCommonRepository;

    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @Override
    public UocSaleOrderDo createSaleOrder(UocSaleOrderDo saleOrderDo) {
        validateCreateArg(saleOrderDo);
        saleOrderDo.setSaleOrderNo(genRequestCode(saleOrderDo));
        //设置销售单
        saleOrderDo.setSaleOrderId(IdUtil.nextId());
        saleOrderDo.setCreateTime(new Date());
        //默认设置为刚创建状态
        saleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_CJ_CJ);

        //设置销售单扩展
        List<UocSaleOrderMap> saleOrderMapList = saleOrderDo.getSaleOrderMapList();
        if (ObjectUtil.isNotEmpty(saleOrderMapList)) {
            for (UocSaleOrderMap uocSaleOrderMap : saleOrderMapList) {
                uocSaleOrderMap.setId(IdUtil.nextId());
                uocSaleOrderMap.setSaleOrderId(saleOrderDo.getSaleOrderId());
                uocSaleOrderMap.setCreateOperId(saleOrderDo.getCreateOperId());
                uocSaleOrderMap.setCreateTime(saleOrderDo.getCreateTime());
            }
        }

        //设置支付配置
        List<UocSaleOrderPayConf> saleOrderPayConfList = saleOrderDo.getSaleOrderPayConfList();
        if (ObjectUtil.isNotEmpty(saleOrderPayConfList)) {
            for (UocSaleOrderPayConf payConf : saleOrderPayConfList) {
                payConf.setId(IdUtil.nextId());
                payConf.setOrderId(saleOrderDo.getOrderId());
                payConf.setCreateTime(saleOrderDo.getCreateTime());
                payConf.setCreateOperId(saleOrderDo.getCreateOperId());
                payConf.setSaleOrderId(saleOrderDo.getSaleOrderId());
            }
        }

        //设置附件
        List<UocOrderAccessory> saleOrderAccessoryList = saleOrderDo.getSaleOrderAccessoryList();
        if (ObjectUtil.isNotEmpty(saleOrderAccessoryList)) {
            for (UocOrderAccessory accessory : saleOrderAccessoryList) {
                accessory.setId(IdUtil.nextId());
                accessory.setObjId(saleOrderDo.getSaleOrderId());
                accessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                accessory.setOrderId(saleOrderDo.getOrderId());
                accessory.setCreateTime(saleOrderDo.getCreateTime());
                accessory.setCreateOperId(saleOrderDo.getCreateOperId());
            }
        }

        //设置销售明细
        setSaleItems(saleOrderDo);

        return uocSaleOrderRepository.createSaleOrder(saleOrderDo);
    }

    private void validateCreateArg(UocSaleOrderDo saleOrderDo) {
        if(ObjectUtil.isEmpty(saleOrderDo)){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR,"入参对象不能为空");
        }
    }

    private void setSaleItems(UocSaleOrderDo saleOrderDo) {
        List<UocSaleOrderItem> saleOrderItems = saleOrderDo.getSaleOrderItems();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            saleOrderItem.setOrderId(saleOrderDo.getOrderId());
            saleOrderItem.setSaleOrderItemId(IdUtil.nextId());
            saleOrderItem.setSaleOrderId(saleOrderDo.getSaleOrderId());
            saleOrderItem.setCreateOperId(saleOrderDo.getCreateOperId());
            saleOrderItem.setCreateTime(saleOrderDo.getCreateTime());

            List<UocSaleItemMap> saleItemMapList = saleOrderItem.getSaleItemMapList();
            if (ObjectUtil.isNotEmpty(saleItemMapList)) {
                for (UocSaleItemMap uocSaleItemMap : saleItemMapList) {
                    uocSaleItemMap.setId(IdUtil.nextId());
                    uocSaleItemMap.setSaleOrderItemId(saleOrderItem.getOrderItemId());
                    uocSaleItemMap.setSaleOrderId(saleOrderDo.getSaleOrderId());
                    uocSaleItemMap.setOrderId(saleOrderDo.getOrderId());
                    uocSaleItemMap.setCreateTime(saleOrderDo.getCreateTime());
                    uocSaleItemMap.setCreateOperId(saleOrderDo.getCreateOperId());
                }
            }
        }
    }


    @Override
    public List<UocSaleOrderItem> getSaleOrderItemList(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        if (null == uocSaleOrderItemQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSaleOrderRepository.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    @Override
    public List<UocSaleItemMap> getSaleOrderItemMapList(UocSaleItemMapQryBo uocSaleItemMapQryBo) {
        if (null == uocSaleItemMapQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSaleOrderRepository.getSaleOrderItemMapList(uocSaleItemMapQryBo);
    }


    @Override
    public UocSaleOrderDo qrySaleOrder(UocSaleOrderQryBo uocSaleOrderQryBo) {
        if (null == uocSaleOrderQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSaleOrderRepository.qrySaleOrder(uocSaleOrderQryBo);
    }

    @Override
    public UocSaleOrderDo getSaleOrderAccessoryList(UocOrderAccessoryQryBo uocOrderAccessoryQryBo) {
        if (null == uocOrderAccessoryQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSaleOrderRepository.getSaleOrderAccessoryList(uocOrderAccessoryQryBo);
    }

    @Override
    public List<UocSaleOrderPayConf> getSaleOrderPayConfList(UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo) {
        return uocSaleOrderRepository.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
    }

    @Override
    public List<UocSaleOrderMap> getSaleOrderExpandList(UocSaleOrderMapQryBo uocSaleOrderMapQryBo) {
        if (null == uocSaleOrderMapQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSaleOrderRepository.getSaleOrderExpandList(uocSaleOrderMapQryBo);
    }

    @Override
    public UocSaleOrderDo qryListSaleOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        return uocSaleOrderRepository.qryListSaleOrderItem(uocSaleOrderItemQryBo);
    }

    @Override
    public void modifySaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocSaleOrderDo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == uocSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }

        uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo);
    }

    @Override
    public UocSaleOrderDo updateSaleStatusAndProCode(UocSaleOrderDo reqBo) {
        validateUpdateSaleOrderArg(reqBo);
        //查询销售单修改前状态
        UocSaleOrderQryBo qryBo = new UocSaleOrderQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = qrySaleOrder(qryBo);
        if (ObjectUtil.isEmpty(uocSaleOrderDo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_UPDATE_STATE_ERROR, "该销售单" + reqBo.getSaleOrderId() + "不存在");
        }

        //记录变更日志
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(reqBo.getSaleOrderId());
        uocOrderStateChgLog.setOrderId(reqBo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderStateChgLog.setOldState(uocSaleOrderDo.getSaleOrderState());
        uocOrderStateChgLog.setNewState(reqBo.getSaleOrderState());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(reqBo.getUpdateOperId());

        //调用通用repository，创建状态变更日志
        uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);

        //更新销售单数据
        return uocSaleOrderRepository.updateSaleStatusAndProCode(reqBo);
    }

    private void validateUpdateSaleOrderArg(UocSaleOrderDo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocUpdateSaleOrderStateServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getUpdateOperId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【更新人id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【订单id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【销售单id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderState())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【销售单状态】不能为空");
        }
    }

    @Override
    public void updateProcTaskInstToFinished(List<UocOrderTaskInst> uocOrderTaskInstList) {
        uocCommonRepository.updateToFinished(uocOrderTaskInstList);
    }

    @Override
    public void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList) {
        Date createTime = new Date();
        if (ObjectUtil.isNotEmpty(saveTaskList)) {
            for (UocOrderTaskInst uocOrderTaskInst : saveTaskList) {
                uocOrderTaskInst.setCreateTime(createTime);
            }
            uocCommonRepository.saveProcTaskInst(saveTaskList);
        }
    }

    @Override
    public List<UocSaleOrderDo> qrySaleOrderList(UocSaleOrderDo qryDo) {
        if (null == qryDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSaleOrderRepository.qrySaleOrderList(qryDo);
    }

    @Override
    public UocOrderProcInst createProInst(UocOrderProcInst inst) {
        inst.setId(IdUtil.nextId());
        inst.setCreateTime(new Date());
        return uocCommonRepository.createProInst(inst);
    }

    @Override
    public List<UocOrderProcInst> qryProcInsList(UocOrderProcInst inst) {
        return uocCommonRepository.qryProcInsList(inst);
    }

    @Override
    public List<UocOrderTaskInst> qryTaskInstList(UocOrderTaskInst taskInst) {
        return uocCommonRepository.qryTaskInstList(taskInst);
    }

    @Override
    public void saveOrderTaskDealList(List<UocOrderTaskDeal> dealList) {
        uocCommonRepository.saveOrderTaskDealList(dealList);
    }

    @Override
    public UocSaleOrderDo getSaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        if(null == uocSaleOrderDo){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
        }
        return uocSaleOrderRepository.getSaleOrderMain(uocSaleOrderDo);
    }

    @Override
    public List<UocSaleStakeholder> qrySaleOrderStakeholder(UocSaleStakeholderQryBo qryBo) {
        return uocSaleOrderRepository.qrySaleOrderStakeholder(qryBo);
    }


    private String genRequestCode(UocSaleOrderDo saleOrderDo) {
        String requestCode = "";
        CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter("UOC");
        getBo.setEncodedRuleCode(UocObjNoConstants.SALE_ORDER_NO + "_" + saleOrderDo.getOrderSource());
        getBo.setOrgType("-1");
        log.info("获取编号入参：" + JSON.toJSONString(getBo));

        //本机调试暂时修改!!!
        try {
            CfcEncodedSerialGetServiceRspBO encodedSerial = encodedSerialGetService.getEncodedSerial(getBo);
            log.info("获取编号出参：" + JSON.toJSONString(encodedSerial));
            requestCode = encodedSerial.getSerialNoList().get(0);
        } catch (Exception e) {
            log.info("获取编号异常：" + e.getMessage());
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_RESP_GET_OBJ_NO_ERROR, "获取编号异常：" + e.getMessage(), e);
        }
        return requestCode;
    }


    @Override
    public void addSaleOrderMap(UocSaleOrderDo uocSaleOrderDo) {
        valDo(uocSaleOrderDo);
        uocSaleOrderRepository.addShipOrderMap(uocSaleOrderDo);
    }

    @Override
    public void updateBatchValue(UocSaleOrderDo uocSaleOrderDo) {
        valDo(uocSaleOrderDo);
        uocSaleOrderRepository.updateBatchValue(uocSaleOrderDo);
    }

    @Override
    public void updateInvalid(UocSaleOrderDo uocSaleOrderDo) {
        valDo(uocSaleOrderDo);
        uocSaleOrderRepository.updateInvalid(uocSaleOrderDo);
    }

    private void valDo(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocSaleOrderDo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }

    }
}


