package com.tydic.dyc.oc.service.aforder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderItemQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderQryBo;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrder;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.aforder.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

/**
 * 标题:UocGetAfOrderDetailServiceImpl
 * 说明:售后服务单详情查询
 * 时间:2022/2/25 10:29
 * 作者:田坤林
 */
@HTServiceImpl
public class UocGetAfOrderDetailServiceImpl implements UocGetAfOrderDetailService {

    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Override
    public UocGetAfOrderDetailServiceRspBo qryAfOrderDetails(UocGetAfOrderDetailServiceReqBo reqBo) {
        UocGetAfOrderDetailServiceRspBo rspBo = UocRu.success(UocGetAfOrderDetailServiceRspBo.class);
        //入参校验
        validateParam(reqBo);
        //查询售后服务单主体
        UocAfOrder uocAfOrder = getAfOrderMain(reqBo);
        if (ObjectUtil.isNull(uocAfOrder)) {
            return rspBo;
        }
        //查询三方信息
        List<UocSaleStakeholder> stakeHolderList = getStakeHolderList(new UocSaleOrderItem(), reqBo, false);
        //查询售后服务单明细
        List<UocAfOrderItem> afOrderItemList = getAfOrderItemList(reqBo);
        //封装服务单信息
        encapServInfo(stakeHolderList, uocAfOrder, rspBo, reqBo);
        //封装商品信息
        encapCommodityInfo(afOrderItemList, rspBo, reqBo);
        //封装退款明细信息
        encapRefundInfo(stakeHolderList, uocAfOrder, reqBo, rspBo);
        return rspBo;
    }

    /**
     * 封装退款明细信息
     *
     * @param stakeHolderList
     * @param reqBo
     * @param rspBo
     */
    private void encapRefundInfo(List<UocSaleStakeholder> stakeHolderList, UocAfOrder uocAfOrder, UocGetAfOrderDetailServiceReqBo reqBo, UocGetAfOrderDetailServiceRspBo rspBo) {
        UocAfOrderRefundDetailBo refundDetailBo = new UocAfOrderRefundDetailBo();
        //查询支付单信息
        List<UocPayOrder> listPayOrder = getUocPayOrderDoList(reqBo);
        if (ObjectUtil.isNotEmpty(listPayOrder)) {
            refundDetailBo = UocRu.js(listPayOrder.get(0), UocAfOrderRefundDetailBo.class);
        }
        if (ObjectUtil.isNotEmpty(stakeHolderList)) {
            refundDetailBo.setPurAccount(stakeHolderList.get(0).getPurAccount());
            refundDetailBo.setPurAccountName(stakeHolderList.get(0).getPurAccountName());
        }
        refundDetailBo.setRealReturnFee(uocAfOrder.getRealReturnFee());
        //退款信息翻译
        translateRefundInfo(refundDetailBo);
        rspBo.setRefundInfo(refundDetailBo);
    }

    /**
     * 退款信息翻译
     *
     * @param refundDetailBo
     */
    private void translateRefundInfo(UocAfOrderRefundDetailBo refundDetailBo) {
        if (null != refundDetailBo.getInterType()) {
            refundDetailBo.setInterTypeStr(getDic().get(UocDicConstant.ORDER_SOURCE.P_CODE).get(refundDetailBo.getInterType().toString()));
        }
        //退款状态翻译
        refundDetailBo.setPayStateStr(getDic().get(UocDicConstant.PAY_STATE.P_CODE).get(refundDetailBo.getPayState()));
        //支付方式翻译
        if (null != refundDetailBo.getPayType()) {
            refundDetailBo.setPayTypeStr(getDic().get(UocDicConstant.PAY_TYPE.P_CODE).get(refundDetailBo.getPayType().toString()));
        }
    }

    /**
     * 查询支付单信息
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.payorder.UocPayOrderDo></>
     */
    private List<UocPayOrder> getUocPayOrderDoList(UocGetAfOrderDetailServiceReqBo reqBo) {
        UocPayOrderQryBo uocPayOrderQryBo = new UocPayOrderQryBo();
        uocPayOrderQryBo.setOrderId(reqBo.getOrderId());
        List<UocPayOrder> listPayOrder = iUocPayOrderModel.getListPayOrder(uocPayOrderQryBo);
        return listPayOrder;
    }

    /**
     * 封装服务单信息
     *
     * @param stakeHolderList
     * @param reqBo
     * @param uocAfOrder
     * @param rspBo
     */
    private void encapServInfo(List<UocSaleStakeholder> stakeHolderList, UocAfOrder uocAfOrder, UocGetAfOrderDetailServiceRspBo rspBo, UocGetAfOrderDetailServiceReqBo reqBo) {
        UocAfOrderServiceInfoBo servInfoBo = UocRu.js(uocAfOrder, UocAfOrderServiceInfoBo.class);
        if (ObjectUtil.isNotEmpty(stakeHolderList)) {
            UocSaleStakeholder stakeholder = stakeHolderList.get(0);
            servInfoBo.setSupplierId(stakeholder.getSupId());
            servInfoBo.setSupplierName(stakeholder.getSupName());
        }
        //封装收获地址信息
        encapReceiverAddressInfo(uocAfOrder, servInfoBo);
        //封装附件信息
        encapAccessoryInfo(reqBo, servInfoBo);
        //服务单字段翻译
        translateServInfo(servInfoBo);
        rspBo.setServInfo(servInfoBo);
    }

    /**
     * 服务单字段翻译
     *
     * @param servInfoBo
     */
    private void translateServInfo(UocAfOrderServiceInfoBo servInfoBo) {
        //服务单类型翻译
        if (null != servInfoBo.getServType()) {
            servInfoBo.setServTypeStr(getDic().get(UocDicConstant.SERVICE_TYPE.P_CODE).get(servInfoBo.getServType().toString()));
        }
        //服务单状态翻译
        if (null != servInfoBo.getServState()) {
            servInfoBo.setServStateStr(getDic().get(UocDicConstant.SERVICE_STATE.P_CODE).get(servInfoBo.getServState().toString()));
        }
        //付款方式翻译
        servInfoBo.setPayTypeStr(getDic().get(UocDicConstant.PAY_TYPE.P_CODE).get(servInfoBo.getPayType()));
        //售后原因翻译
        if (null != servInfoBo.getAfsReason()) {
            servInfoBo.setAfsReasonStr(getDic().get(UocDicConstant.AFS_REASON.P_CODE).get(servInfoBo.getAfsReason().toString()));
        }
    }

    /**
     * 封装附件信息
     *
     * @param reqBo
     * @param servInfoBo
     */
    private void encapAccessoryInfo(UocGetAfOrderDetailServiceReqBo reqBo, UocAfOrderServiceInfoBo servInfoBo) {
        //查询附件
        List<UocAfOrderAccessoryTypeDetailBo> accessoryInfo = new ArrayList<>();
        UocOrderAccessoryQryBo qryBo = new UocOrderAccessoryQryBo();
        qryBo.setObjId(reqBo.getAfOrderId());
        qryBo.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        qryBo.setOrderId(reqBo.getOrderId());
        List<UocOrderAccessory> orderAccessoryList = iUocOrderModel.getOrderAccessoryList(qryBo);
        if (ObjectUtil.isNotEmpty(orderAccessoryList)) {
            ConcurrentMap<Integer, List<UocOrderAccessory>> uocOrderAccessoryMap =
                    orderAccessoryList.stream().collect(Collectors.groupingByConcurrent(UocOrderAccessory::getAttachmentType));
            while (uocOrderAccessoryMap.keySet().iterator().hasNext()) {
                UocAfOrderAccessoryTypeDetailBo accessoryTypeDetailBo = new UocAfOrderAccessoryTypeDetailBo();
                Integer key = uocOrderAccessoryMap.keySet().iterator().next();
                accessoryTypeDetailBo.setAttachmentType(key);
                accessoryTypeDetailBo.setAttchList(UocRu.jsl(uocOrderAccessoryMap.get(key), UocAfOrderAccessoryDetailBo.class));
                accessoryInfo.add(accessoryTypeDetailBo);
            }
        }
        servInfoBo.setAccessoryInfo(accessoryInfo);
    }

    /**
     * 封装收获地址信息
     *
     * @param uocAfOrder
     * @param servInfoBo
     */
    private void encapReceiverAddressInfo(UocAfOrder uocAfOrder, UocAfOrderServiceInfoBo servInfoBo) {
        //查询收获地址
        UocOrdLogisticsRelaQryBo qryBo = new UocOrdLogisticsRelaQryBo();
        qryBo.setOrderId(uocAfOrder.getOrderId());
        qryBo.setContactId(uocAfOrder.getContactId());
        UocOrdLogisticsRela uocOrdLogisticsRela = iUocOrderModel.qryOrderLogisticsRela(qryBo);
        if (ObjectUtil.isNotNull(uocOrdLogisticsRela)) {
            servInfoBo.setOrderTakeDeliveryInfo(UocRu.js(uocOrdLogisticsRela, UocAfOrderReceiverAddressBo.class));
        }
    }

    /**
     * 封装商品信息
     *
     * @param reqBo
     * @param afOrderItemList
     * @param rspBo
     */
    private void encapCommodityInfo(List<UocAfOrderItem> afOrderItemList, UocGetAfOrderDetailServiceRspBo rspBo, UocGetAfOrderDetailServiceReqBo reqBo) {
        List<UocAfOrderCommodityItemBo> commodityInfo = new ArrayList<>();
        if (ObjectUtil.isNotEmpty(afOrderItemList)) {
            afOrderItemList.forEach(each -> {
                UocAfOrderCommodityItemBo commodityItemBo = new UocAfOrderCommodityItemBo();
                //封装订单明细信息
                encapOrderItemInfo(each, commodityItemBo);
                //封装售后单明细信息
                BeanUtils.copyProperties(each, commodityItemBo);
                //封装销售单明细信息
                encapSaleOrderItemInfo(each, commodityItemBo, reqBo);
                //封装发货单明细信息
                encapShipOrderItemInfo(each, commodityItemBo);
                //封装验收单明细信息
                encapInspOrderItemInfo(each, commodityItemBo);
                //商品信息字段翻译
                translateCommodityInfo(commodityItemBo);
                commodityInfo.add(commodityItemBo);
            });
        }
        rspBo.setCommodityInfo(commodityInfo);
    }

    /**
     * 商品信息字段翻译
     *
     * @param commodityItemBo
     */
    private void translateCommodityInfo(UocAfOrderCommodityItemBo commodityItemBo) {
        //发货单状态翻译
        commodityItemBo.setShipOrderStateStr(getDic().get(UocStateConstants.ShipOrder.P_CODE).get(commodityItemBo.getShipOrderState()));
        //sku来源翻译
        if (null != commodityItemBo.getSkuSource()) {
            commodityItemBo.setSkuSourceStr(getDic().get(UocDicConstant.ORDER_SOURCE.P_CODE).get(commodityItemBo.getSkuSource().toString()));
        }
    }

    /**
     * 封装验收单明细信息
     *
     * @param item
     * @param commodityItemBo
     */
    private void encapInspOrderItemInfo(UocAfOrderItem item, UocAfOrderCommodityItemBo commodityItemBo) {
        List<UocInspOrderItem> inspOrderItemList = getInspOrderItemList(item);
        if (ObjectUtil.isNotEmpty(inspOrderItemList)) {
            UocInspOrderItem uocInspOrderItem = inspOrderItemList.get(0);
            BeanUtils.copyProperties(uocInspOrderItem, commodityItemBo);
        }
    }

    /**
     * 查询验收单明细
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem></>
     */
    private List<UocInspOrderItem> getInspOrderItemList(UocAfOrderItem reqBo) {
        //查询验收单明细
        UocInspOrderItemQryBo qryBo = new UocInspOrderItemQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setInspOrderItemId(reqBo.getInspItemId());
        return iUocInspOrderModel.getListInspOrderItem(qryBo).getUocInspOrderItemList();
    }

    /**
     * 封装发货单明细信息
     *
     * @param item
     * @param commodityItemBo
     */
    private void encapShipOrderItemInfo(UocAfOrderItem item, UocAfOrderCommodityItemBo commodityItemBo) {
        //查询发货单明细
        List<UocShipOrderItem> shipOrderItemList = getShipOrderItemList(item);
        if (ObjectUtil.isNotEmpty(shipOrderItemList)) {
            UocShipOrderItem uocShipOrderItem = shipOrderItemList.get(0);
            BeanUtils.copyProperties(uocShipOrderItem, commodityItemBo);
            //封装发货单主体信息
            encapShipOrderMainInfo(commodityItemBo, uocShipOrderItem);
        }
    }

    /**
     * 封装发货单主体信息
     *
     * @param commodityItemBo
     * @param uocShipOrderItem
     */
    private void encapShipOrderMainInfo(UocAfOrderCommodityItemBo commodityItemBo, UocShipOrderItem uocShipOrderItem) {
        //查询发货单主体
        UocShipOrderDo shipOrderDo = getShipOrderDo(uocShipOrderItem);
        if (ObjectUtil.isNotNull(shipOrderDo)) {
            BeanUtils.copyProperties(shipOrderDo, commodityItemBo);
        }
    }

    /**
     * 封装销售单明细信息
     *
     * @param reqBo
     * @param item
     * @param commodityItemBo
     */
    private void encapSaleOrderItemInfo(UocAfOrderItem item, UocAfOrderCommodityItemBo commodityItemBo, UocGetAfOrderDetailServiceReqBo reqBo) {
        //查询销售单明细
        List<UocSaleOrderItem> saleOrderItemList = getSaleOrderItemList(item);
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            UocSaleOrderItem saleOrderItem = saleOrderItemList.get(0);
            BeanUtils.copyProperties(saleOrderItem, commodityItemBo);
            //封装三方信息
            encapStakeHolderInfo(commodityItemBo, saleOrderItem, reqBo);
        }
    }

    /**
     * 封装订单明细信息
     *
     * @param item
     * @param commodityItemBo
     */
    private void encapOrderItemInfo(UocAfOrderItem item, UocAfOrderCommodityItemBo commodityItemBo) {
        //查询订单明细信息
        List<UocOrderItem> orderItemList = getOrderItemList(item);
        if (ObjectUtil.isNotEmpty(orderItemList)) {
            UocOrderItem uocOrderItem = orderItemList.get(0);
            BeanUtils.copyProperties(uocOrderItem, commodityItemBo);
        }
    }

    /**
     * 查询订单明细信息
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderItem></>
     */
    private List<UocOrderItem> getOrderItemList(UocAfOrderItem reqBo) {
        UocOrderItemQryBo qryBo = new UocOrderItemQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setOrderItemId(reqBo.getOrderItemId());
        return iUocOrderModel.qryOrderItemList(qryBo);
    }

    /**
     * 封装三方信息
     *
     * @param reqBo
     * @param commodityItemBo
     * @param saleOrderItem
     */
    private void encapStakeHolderInfo(UocAfOrderCommodityItemBo commodityItemBo, UocSaleOrderItem saleOrderItem, UocGetAfOrderDetailServiceReqBo reqBo) {
        List<UocSaleStakeholder> stakeHolderList = getStakeHolderList(saleOrderItem, reqBo, true);
        if (ObjectUtil.isNotEmpty(stakeHolderList)) {
            UocSaleStakeholder uocSaleStakeholder = stakeHolderList.get(0);
            BeanUtils.copyProperties(uocSaleStakeholder, commodityItemBo);
        }
    }

    /**
     * 查询三方信息
     *
     * @param item
     * @return java.util.List<com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder></>
     */
    private List<UocSaleStakeholder> getStakeHolderList(UocSaleOrderItem item, UocGetAfOrderDetailServiceReqBo reqBo, Boolean isSaleItem) {
        UocSaleStakeholderQryBo qryBo = new UocSaleStakeholderQryBo();
        if (isSaleItem) {
            qryBo.setOrderId(item.getOrderId());
        } else {
            qryBo.setOrderId(reqBo.getOrderId());
        }
        return iUocSaleOrderModel.qrySaleOrderStakeholder(qryBo);
    }

    /**
     * 查询发货单主体
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.shiporder.UocShipOrderDo
     */
    private UocShipOrderDo getShipOrderDo(UocShipOrderItem reqBo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        return iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
    }

    /**
     * 查询发货单明细
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem></>
     */
    private List<UocShipOrderItem> getShipOrderItemList(UocAfOrderItem reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setShipOrderItemId(reqBo.getShipItemId());
        return iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo).getShipOrderItemBoList();
    }


    /**
     * 查询销售订单明细
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem></>
     */
    private List<UocSaleOrderItem> getSaleOrderItemList(UocAfOrderItem reqBo) {
        UocSaleOrderItemQryBo qryBo = new UocSaleOrderItemQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setOrderItemId(reqBo.getOrderItemId());
        return iUocSaleOrderModel.getSaleOrderItemList(qryBo);
    }

    /**
     * 查询售后服务单主体
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.aforder.sub.UocAfOrder
     */
    private UocAfOrder getAfOrderMain(UocGetAfOrderDetailServiceReqBo reqBo) {
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderQryBo.setOrderId(reqBo.getOrderId());
        return iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
    }

    /**
     * 查询售后服务单明细
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem></>
     */
    private List<UocAfOrderItem> getAfOrderItemList(UocGetAfOrderDetailServiceReqBo reqBo) {
        UocAfOrderItemQryBo uocAfOrderItemQryBo = new UocAfOrderItemQryBo();
        uocAfOrderItemQryBo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return iUocAfOrderModel.getAfOrderItemList(uocAfOrderItemQryBo);
    }

    /**
     * 入参校验
     *
     * @param reqBo
     */
    private void validateParam(UocGetAfOrderDetailServiceReqBo reqBo) {
        if (ObjectUtil.isNull(reqBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参不能为空");
        }
        if (reqBo.getAfOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "售后服务单ID不能为空");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单ID不能为空");
        }
    }

    /**
     * 查询字典
     */
    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocDicConstant.SERVICE_STATE.P_CODE);
        pCodes.add(UocDicConstant.SERVICE_TYPE.P_CODE);
        pCodes.add(UocDicConstant.PAY_TYPE.P_CODE);
        pCodes.add(UocDicConstant.AFS_REASON.P_CODE);
        pCodes.add(UocDicConstant.ORDER_SOURCE.P_CODE);
        pCodes.add(UocStateConstants.ShipOrder.P_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }
}
