package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.implorder.IUocImplOrderModel;
import com.tydic.dyc.oc.model.implorder.UocImplOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题:UocChngOrderConfirmOrRefuseServiceImpl
 * 说明:数量变更确认/拒绝 实现
 * 时间:2022/3/9 20:42
 * 作者:罗有
 */

@HTServiceImpl
public class UocChngOrderConfirmOrRefuseServiceImpl implements UocChngOrderConfirmOrRefuseService {

	@Autowired
	private IUocChngOrderModel iUocChngOrderModel;
	@Autowired
	private IUocShipOrderModel iUocShipOrderModel;
	@Autowired
	private IUocImplOrderModel iUocImplOrderModel;

	private static final Integer OP_FLAG_CONFIRM = 1;

	private static final Integer OP_FLAG_REFUSE = 0;

	@Override
	public UocChngOrderConfirmOrRefuseRspBo dealConfirmOrRefuse(UocChngOrderConfirmOrRefuseReqBo reqBo) {
		validateArg(reqBo);
		String operId = reqBo.getUserId().toString();
		Date now = new Date();
		List<UocChngOrderItemObj> uocChngOrderItemObjList = getListChngOrderItemObj(reqBo);
		iUocChngOrderModel.modifyBatchChngOrderState(convertChngOrderDo(reqBo, now, operId));
		if(OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
			confirm(reqBo, operId, now, uocChngOrderItemObjList);
		}
		if(OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
			refuse(reqBo, operId, now, uocChngOrderItemObjList);
		}
		dealMap(reqBo, now);
		return UocRu.success(UocChngOrderConfirmOrRefuseRspBo.class);
	}

	private void refuse(UocChngOrderConfirmOrRefuseReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
		iUocShipOrderModel.modifyItemChngCountRefuse(convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
		iUocImplOrderModel.modifyBatchItemChngCountRefuse(convertImplOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
	}

	private void confirm(UocChngOrderConfirmOrRefuseReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
		iUocShipOrderModel.modifyItemReturnCountConfirm(convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
		iUocImplOrderModel.modifyBatchItemReturnCountConfirm(convertImplOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
	}


	/**
	 * 查询执行单信息
	 */
	private UocImplOrderDo convertImplOrderDo(UocChngOrderConfirmOrRefuseReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
		UocImplOrderDo uocImplOrderDo = new UocImplOrderDo();
		uocImplOrderDo.setUpdateOperId(operId);
		uocImplOrderDo.setUpdateTime(now);
		uocImplOrderDo.setOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList()));
		uocImplOrderDo.setImplOrderItemIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getImplOrderItemId).collect(Collectors.toList()));
		return uocImplOrderDo;
	}

	/**
	 * 查询发货单信息信息
	 */
	private UocShipOrderDo convertShipOrderDo(UocChngOrderConfirmOrRefuseReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
		List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
		UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
		uocShipOrderDo.setShipOrderItemIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).collect(Collectors.toList()));
		uocShipOrderDo.setOrderIdList(orderIdList);
		uocShipOrderDo.setUpdateTime(now);
		uocShipOrderDo.setUpdateOperId(operId);
		return uocShipOrderDo;
	}

	/**
	 * 组装变更单信息
	 */
	private List<UocChngOrderDo> convertChngOrderDo(UocChngOrderConfirmOrRefuseReqBo reqBo, Date now, String operId) {
		String state = getState(reqBo);
		return reqBo.getChngOrderList().stream().map(uocChngOrderConfirmOrRefuseReqItemBo -> {
			UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
			uocChngOrderDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
			uocChngOrderDo.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
			uocChngOrderDo.setChngOrderState(state);
			uocChngOrderDo.setUpdateTime(now);
			uocChngOrderDo.setUpdateOperId(operId);
			uocChngOrderDo.setUpdateOperName(reqBo.getName());
			uocChngOrderDo.setRejectReason(reqBo.getRejectRemark());
			return uocChngOrderDo;
		}).collect(Collectors.toList());
	}

	/**
	 * 获取对应状态
	 */
	private String getState(UocChngOrderConfirmOrRefuseReqBo reqBo) {
		if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
			return UocStateConstants.ChngOrder.NUM.CHNG_CHNG_JJ;
		}
		return UocStateConstants.ChngOrder.NUM.CHNG_CHNG_QR;
	}

	/**
	 * 查询变更对象明细信息
	 */
	private List<UocChngOrderItemObj> getListChngOrderItemObj(UocChngOrderConfirmOrRefuseReqBo reqBo){
		List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
		UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
		uocChngOrderItemObjQryBo.setChngOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList()));
		uocChngOrderItemObjQryBo.setOrderIdList(orderIdList);
		List<UocChngOrderItemObj> uocChngOrderItemObjList = iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
		if (CollectionUtils.isEmpty(uocChngOrderItemObjList)) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "查询变更明细对象为空");
		}
		return uocChngOrderItemObjList;
	}


	/**
	 * 扩展属性处理
	 */
	private void dealMap(UocChngOrderConfirmOrRefuseReqBo reqBo, Date now) {
		List<UocChngOrderConfirmOrRefuseReqItemBo> chngOrderList = reqBo.getChngOrderList();
		chngOrderList.forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
			if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList())) {
				UocChngOrderDo delChngOrderDo = new UocChngOrderDo();
				List<UocChngOrderMap> extParallelBoList = new ArrayList<>();
				uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
					UocChngOrderMap uocChngOrderMap = new UocChngOrderMap();
					uocChngOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
					uocChngOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
					uocChngOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
					uocChngOrderMap.setUpdateOperId(reqBo.getUserId().toString());
					uocChngOrderMap.setUpdateTime(now);
					extParallelBoList.add(uocChngOrderMap);
				});
				delChngOrderDo.setUocChngOrderMapList(extParallelBoList);
				iUocChngOrderModel.updateInvalid(delChngOrderDo);
			}
			if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList())) {
				UocChngOrderDo add = new UocChngOrderDo();
				UocChngOrderDo modify = new UocChngOrderDo();
				List<UocChngOrderMap> addList = new ArrayList<>();
				List<UocChngOrderMap> modifyList = new ArrayList<>();
				uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
					if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
						UocChngOrderMap addShipOrderMap = new UocChngOrderMap();
						addShipOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
						addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
						addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
						addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
						addShipOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
						addShipOrderMap.setId(IdUtil.nextId());
						addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
						addShipOrderMap.setCreateTime(now);
						addList.add(addShipOrderMap);
					} else {
						UocChngOrderMap updateShipOrderMap = new UocChngOrderMap();
						updateShipOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
						updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
						updateShipOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
						updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
						updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
						updateShipOrderMap.setUpdateTime(now);
						modifyList.add(updateShipOrderMap);
					}
				});
				if (!CollectionUtils.isEmpty(addList)) {
					add.setUocChngOrderMapList(addList);
					iUocChngOrderModel.addChngOrderMap(add);
				}
				if (!CollectionUtils.isEmpty(modifyList)) {
					modify.setUocChngOrderMapList(modifyList);
					iUocChngOrderModel.updateBatchValue(modify);
				}
			}
		});
	}

	private void validateArg(UocChngOrderConfirmOrRefuseReqBo reqBo) {
		if (null == reqBo) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
		}
		if (!OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) && !OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参操作只支持确认或拒绝为空");
		}
		if (CollectionUtils.isEmpty(reqBo.getChngOrderList())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息列表不能为空");
		}
		reqBo.getChngOrderList().forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
			if (null == uocChngOrderConfirmOrRefuseReqItemBo.getOrderId()) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息的订单ID不能为空");
			}
			if (null == uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId()) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息的变更单ID不能为空");
			}
		});
		if (null == reqBo.getUserId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID不能为空");
		}
		List<UocChngOrderConfirmOrRefuseReqItemBo> chngOrderList = reqBo.getChngOrderList();
		chngOrderList.forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {

			if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList())) {
				uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
					if (null == uocBaseExtParallelDeleteBo.getObjId()) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性对象ID不能为空");
					}
					if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性编码不能为空");
					}
				});
			}
			if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList())) {
				uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
					if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型不能为空");
					}
					if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型仅支持新增和修改");
					}
					if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
						if (null == uocBaseExtParallelDeleteBo.getObjId()) {
							throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，对象ID不能为空");
						}
						if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
							throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，属性编码不能为空");
						}
					}
					if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
						if (null == uocBaseExtParallelDeleteBo.getObjId()) {
							throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，对象ID不能为空");
						}
						if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
							throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性编码不能为空");
						}
						if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldValue())) {
							throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性值不能为空");
						}
					}
				});
			}
		});
	}

}
