package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.implorder.IUocImplOrderModel;
import com.tydic.dyc.oc.model.implorder.UocImplOrderDo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderItemQryBo;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderMap;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderArrivaConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderArrivaConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * 标题:UocShipOrderArrivaConfirmOrRefuseServiceImpl
 * 说明:发货单到货确认/拒收
 * 时间:2022/2/24 11:32
 * 作者:罗有
 */

@HTServiceImpl
public class UocShipOrderArrivaConfirmOrRefuseServiceImpl implements UocShipOrderArrivaConfirmOrRefuseService {

    /**
     * 到货确认
     */
    private static final Integer OP_FLAG_CONFIRM = 1;
	/**
	 * 到货拒收
	 */
	private static final Integer OP_FLAG_REFUSE = 2;
	@Autowired
	private IUocShipOrderModel iUocShipOrderModel;
	@Autowired
	private IUocImplOrderModel iUocImplOrderModel;
	@Autowired
	private IUocSaleOrderModel iUocSaleOrderModel;
	/**
	 * 全部拒单
	 */
	private static final String OP_FLAG_YES = "1";
	/**
	 * 不是全部拒单
	 */
	private static final String OP_FLAG_NO = "0";

	@Override
	public UocShipOrderArrivaConfirmOrRefuseRspBo dealArriva(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo) {
		//参数校验
		validateArg(reqBo);
		List<UocShipOrderItem> uocShipOrderItemList = getListShipOrderItem(reqBo);
		Date now = new Date();
		UocShipOrderDo uocShipOrderDo = convertShipOrderDo(reqBo, now);
		if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
			dealConfirm(uocShipOrderDo, uocShipOrderItemList);
		}
		if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
			dealRefuse(uocShipOrderDo, uocShipOrderItemList);
		}
		dealMap(reqBo, now);
		UocShipOrderArrivaConfirmOrRefuseRspBo uocShipOrderArrivaConfirmOrRefuseRspBo = UocRu.success(UocShipOrderArrivaConfirmOrRefuseRspBo.class);
		boolean allRefuseFlag = modifySaleOrderState(reqBo, now);
		uocShipOrderArrivaConfirmOrRefuseRspBo.setAllRefuseFlag(allRefuseFlag);
		uocShipOrderArrivaConfirmOrRefuseRspBo.setOpFlag(allRefuseFlag ? OP_FLAG_YES : OP_FLAG_NO);
		return uocShipOrderArrivaConfirmOrRefuseRspBo;
	}

	/**
	 * 扩展属性处理
	 */
	private void dealMap(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo, Date now) {
		if (!CollectionUtils.isEmpty(reqBo.getExtDeleteList())) {
			UocShipOrderDo delShipOrderDo = new UocShipOrderDo();
			List<UocShipOrderMap> extParallelBoList = new ArrayList<>();
			reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
				UocShipOrderMap uocShipOrderMap = new UocShipOrderMap();
				uocShipOrderMap.setShipOrderId(uocBaseExtParallelDeleteBo.getObjId());
				uocShipOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
				uocShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
				uocShipOrderMap.setUpdateTime(now);
				extParallelBoList.add(uocShipOrderMap);
			});
			delShipOrderDo.setExtParallelBoList(extParallelBoList);
			delShipOrderDo.setUpdateOperId(reqBo.getUserId().toString());
			delShipOrderDo.setUpdateTime(now);
			delShipOrderDo.setOrderId(reqBo.getOrderId());
			iUocShipOrderModel.updateInvalid(delShipOrderDo);
		}
		if (!CollectionUtils.isEmpty(reqBo.getExtEditList())) {
			UocShipOrderDo add = new UocShipOrderDo();
			UocShipOrderDo modify = new UocShipOrderDo();
			List<UocShipOrderMap> addList = new ArrayList<>();
			List<UocShipOrderMap> modifyList = new ArrayList<>();
			reqBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
				if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
					UocShipOrderMap addShipOrderMap = new UocShipOrderMap();
					addShipOrderMap.setShipOrderId(uocBaseExtParallelEditBo.getObjId());
					addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
					addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
					addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
					addShipOrderMap.setOrderId(reqBo.getOrderId());
					addShipOrderMap.setImplOrderId(reqBo.getImplOrderId());
					addShipOrderMap.setSaleOrderId(reqBo.getSaleOrderId());
					addShipOrderMap.setId(IdUtil.nextId());
					addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
					addShipOrderMap.setCreateTime(now);
					addList.add(addShipOrderMap);
				} else {
					UocShipOrderMap updateShipOrderMap = new UocShipOrderMap();
					updateShipOrderMap.setShipOrderId(uocBaseExtParallelEditBo.getObjId());
					updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
					updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
					modifyList.add(updateShipOrderMap);
				}
			});
			if (!CollectionUtils.isEmpty(addList)) {
				add.setExtParallelBoList(addList);
				iUocShipOrderModel.addShipOrderMap(add);
			}
			if (!CollectionUtils.isEmpty(modifyList)) {
				modify.setExtParallelBoList(modifyList);
				modify.setOrderId(reqBo.getOrderId());
				modify.setUpdateOperId(reqBo.getUserId().toString());
				modify.setUpdateTime(now);
				iUocShipOrderModel.updateBatchValue(modify);
			}
		}
	}

	private List<UocShipOrderItem> getListShipOrderItem(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo) {
		UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
		uocShipOrderItemQryBo.setShipOrderIdList(reqBo.getShipOrderIdList());
		uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
		uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
		UocShipOrderDo shipOrderDo = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
		if (CollectionUtils.isEmpty(shipOrderDo.getShipOrderItemBoList())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_CONFIRM_REFUSE_ERROR, "获取发货明细为空");
		}
        return shipOrderDo.getShipOrderItemBoList();
    }

	private UocShipOrderDo convertShipOrderDo(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo, Date now) {
		UocShipOrderDo uocShipOrderDo = UocRu.js(reqBo, UocShipOrderDo.class);
		uocShipOrderDo.setUpdateOperId(reqBo.getUserId().toString());
		uocShipOrderDo.setUpdateTime(now);
		setAccessory(reqBo, now, uocShipOrderDo);
		setMap(reqBo, now, uocShipOrderDo);
		return uocShipOrderDo;
	}

	private void setMap(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo, Date now, UocShipOrderDo uocShipOrderDo) {

	}

	/**
	 * 到货确认
	 */
	private void dealConfirm(UocShipOrderDo uocShipOrderDo, List<UocShipOrderItem> uocShipOrderItemList) {
		uocShipOrderItemList.forEach(uocShipOrderItem -> {
			if (uocShipOrderItem.getRefuseCount().compareTo(BigDecimal.ZERO) > 0) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_CONFIRM_REFUSE_ERROR, "已拒收发货单不能做到货确认，请重新选择");
			}
			if (uocShipOrderItem.getArriveCount().compareTo(BigDecimal.ZERO) > 0) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_CONFIRM_REFUSE_ERROR, "存在已确认到货发货单，请重新选择");
            }
        });
        uocShipOrderDo.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_YSH);
        iUocShipOrderModel.arrivaConfirm(uocShipOrderDo);
        UocImplOrderDo uocImplOrderDo = new UocImplOrderDo();
        uocImplOrderDo.setOrderId(uocShipOrderDo.getOrderId());
        uocImplOrderDo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        uocImplOrderDo.setImplOrderId(uocShipOrderDo.getImplOrderId());
        uocImplOrderDo.setUpdateOperId(uocShipOrderDo.getUpdateOperId());
        uocImplOrderDo.setUpdateTime(uocShipOrderDo.getUpdateTime());
        Map<Long, UocImplOrderItem> implItemIdMap = new HashMap<>();
        uocShipOrderItemList.forEach(uocShipOrderItem -> {
            UocImplOrderItem uocImplOrderItem = implItemIdMap.get(uocShipOrderItem.getImplOrderItemId());
            if(null != uocImplOrderItem){
                uocImplOrderItem.setArriveCount(uocImplOrderItem.getArriveCount().add(uocShipOrderItem.getSendCount()));
            }else {
                uocImplOrderItem = new UocImplOrderItem();
                uocImplOrderItem.setArriveCount(uocShipOrderItem.getSendCount());
                uocImplOrderItem.setImplOrderItemId(uocShipOrderItem.getImplOrderItemId());
            }
            implItemIdMap.put(uocShipOrderItem.getImplOrderItemId(), uocImplOrderItem);
        });
        uocImplOrderDo.setUocImplOrderItemList(new ArrayList<>(implItemIdMap.values()));
        iUocImplOrderModel.modifyBatchItemArrivaCount(uocImplOrderDo);
    }

    /**
     * 到货拒收
     */
    private void dealRefuse(UocShipOrderDo uocShipOrderDo, List<UocShipOrderItem> uocShipOrderItemList) {
        uocShipOrderItemList.forEach(uocShipOrderItem -> {
            if (uocShipOrderItem.getRefuseCount().compareTo(BigDecimal.ZERO) > 0) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_CONFIRM_REFUSE_ERROR, "存在已拒收发货单，请重新选择");
            }
            if (uocShipOrderItem.getArriveCount().compareTo(BigDecimal.ZERO) > 0) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_CONFIRM_REFUSE_ERROR, "已确认到货发货单不能做拒收，请重新选择");
            }
        });
//        uocShipOrderDo.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_JS);
        iUocShipOrderModel.arrivaRefuse(uocShipOrderDo);
        UocImplOrderDo uocImplOrderDo = new UocImplOrderDo();
        uocImplOrderDo.setOrderId(uocShipOrderDo.getOrderId());
        uocImplOrderDo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        uocImplOrderDo.setUpdateOperId(uocShipOrderDo.getUpdateOperId());
        uocImplOrderDo.setUpdateTime(uocShipOrderDo.getUpdateTime());
        Map<Long, UocImplOrderItem> implItemIdMap = new HashMap<>();
        uocShipOrderItemList.forEach(uocShipOrderItem -> {
            UocImplOrderItem uocImplOrderItem = implItemIdMap.get(uocShipOrderItem.getImplOrderItemId());
            if(null != uocImplOrderItem) {
                uocImplOrderItem.setRefuseCount(uocImplOrderItem.getRefuseCount().add(uocShipOrderItem.getSendCount()));
            }else {
                uocImplOrderItem = new UocImplOrderItem();
                uocImplOrderItem.setImplOrderItemId(uocShipOrderItem.getImplOrderItemId());
                uocImplOrderItem.setRefuseCount(uocShipOrderItem.getSendCount());
            }
            implItemIdMap.put(uocShipOrderItem.getImplOrderItemId(), uocImplOrderItem);
        });
        uocImplOrderDo.setUocImplOrderItemList(new ArrayList<>(implItemIdMap.values()));
        iUocImplOrderModel.modifyBatchItemRefuseCount(uocImplOrderDo);
    }

    /**
     * 组装附件参数
     */
    private void setAccessory(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo, Date now, UocShipOrderDo uocShipOrderDo) {
        if (!CollectionUtils.isEmpty(reqBo.getOrderAccessoryList())) {
            List<UocOrderAccessory> orderAccessoryBoList = new ArrayList<>();
            reqBo.getOrderAccessoryList().forEach(orderAccessoryAddBo -> {
                UocOrderAccessory uocOrderAccessory = UocRu.js(orderAccessoryAddBo, UocOrderAccessory.class);
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setObjId(reqBo.getSaleOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                uocOrderAccessory.setCreateTime(now);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setId(IdUtil.nextId());
                orderAccessoryBoList.add(uocOrderAccessory);
            });
            uocShipOrderDo.setOrderAccessoryBoList(orderAccessoryBoList);
        }
    }

    private boolean modifySaleOrderState(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo, Date now) {
        UocImplOrderItemQryBo uocImplOrderItemQryBo = new UocImplOrderItemQryBo();
        uocImplOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocImplOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocImplOrderDo uocImplOrderDo = iUocImplOrderModel.getCollectCountImplOrderItem(uocImplOrderItemQryBo);
        // 在到货确认/拒收节点会有 采购数量 发货数量 到货数量 拒收数量，不会有 退货数量 售后数量
        // XS_DH_DH   已到货(全部到货) 采购数量 = 到货数量
        // XS_DH_JS   已拒收(全部拒收) 采购数量 = 拒收数量
        // XS_DH_BFDH 部分到货 采购数量 > (到货数量 + 拒收数量) &&  到货数量 > 0 && 拒收数量 > 0
        if (CollectionUtils.isEmpty(uocImplOrderDo.getUocImplOrderItemList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_CONFIRM_REFUSE_ERROR, "查询数量汇总为空");
        }
        UocImplOrderItem uocImplOrderItem = uocImplOrderDo.getUocImplOrderItemList().get(0);
        if (null == uocImplOrderItem) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_CONFIRM_REFUSE_ERROR, "查询数量汇总为空");
        }
        boolean refuseAll = false;
        String state = null;
        if (uocImplOrderItem.getPurchaseCount().compareTo(uocImplOrderItem.getArriveCount()) == 0) {
            state = UocStateConstants.SaleOrder.XS_DH_DH;
        }
        if (uocImplOrderItem.getPurchaseCount().compareTo(uocImplOrderItem.getRefuseCount()) == 0) {
            state = UocStateConstants.SaleOrder.XS_DH_JS;
            refuseAll = true;
        }
        if (uocImplOrderItem.getPurchaseCount().compareTo(uocImplOrderItem.getArriveCount().add(uocImplOrderItem.getRefuseCount())) > 0
                && uocImplOrderItem.getArriveCount().compareTo(BigDecimal.ZERO) > 0
                && uocImplOrderItem.getRefuseCount().compareTo(BigDecimal.ZERO) > 0) {
            state = UocStateConstants.SaleOrder.XS_DH_BFDH;
        }
        if (!StringUtils.isBlank(state)) {
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setSaleOrderState(state);
            uocSaleOrderDo.setOrderId(reqBo.getOrderId());
            uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
            uocSaleOrderDo.setUpdateTime(now);
            uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
            iUocSaleOrderModel.updateSaleStatusAndProCode(uocSaleOrderDo);
        }
        return refuseAll;
    }

    private void validateArg(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }
        if (null == reqBo.getImplOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参执行单ID不能为空");
        }
        if (CollectionUtils.isEmpty(reqBo.getShipOrderIdList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参发货单ID数组不能为空");
		}
		if (null == reqBo.getOpFlag()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参操作不能为空");
		}
		if (!OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) && !OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "操作仅支持到货确认或拒收");
		}
		if (null == reqBo.getUserId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID为空");
		}
		if (!CollectionUtils.isEmpty(reqBo.getExtDeleteList())) {
			reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
				if (null == uocBaseExtParallelDeleteBo.getObjId()) {
					throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性对象ID不能为空");
				}
				if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
					throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性编码不能为空");
				}
			});
		}
		if (!CollectionUtils.isEmpty(reqBo.getExtEditList())) {
			reqBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
				if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
					throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型不能为空");
				}
				if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
					throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型仅支持新增和修改");
				}
				if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
					if (null == uocBaseExtParallelDeleteBo.getObjId()) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，对象ID不能为空");
					}
					if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，属性编码不能为空");
					}
				}
				if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
					if (null == uocBaseExtParallelDeleteBo.getObjId()) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，对象ID不能为空");
					}
					if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性编码不能为空");
					}
					if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldValue())) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性值不能为空");
					}
				}
			});
		}
	}
}
