package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.implorder.IUocImplOrderModel;
import com.tydic.dyc.oc.model.implorder.UocImplOrderDo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplItemMapQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderItemQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderMapQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderQryBo;
import com.tydic.dyc.oc.model.implorder.sub.UocImplItemMap;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:UocEsSyncImpl
 * 说明:执行单同步
 * 时间:2022/3/1 02:25
 * 作者:田桂银
 */
@Component
public class UocEsSyncImpl implements IUocEsSync {

    public static final List<String> pCodeList = ListUtil.list(false);

    static {
        initialize();
    }

    @Override
    public String indexName() {
        return uocIndexConfig.getImplOrderIndex();
    }

    @Autowired
    private IUocImplOrderModel iUocImplOrderModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Autowired
    private UocIndexConfig uocIndexConfig;

    public static final String UOC_IMPL_ORDER_ITEM = "uocImplOrderItemList";

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
        rspBo.setObjId(reqBo.getObjId());
        //查询执行单主体
        UocImplOrderDo implOrderSubject = getImplOrderSubject(reqBo);
        if (Objects.isNull(implOrderSubject)) {
            return rspBo;
        }
        //查询执行单扩展
        List<UocImplOrderMap> implOrderMapList = getImplOrderMapList(reqBo);
        //查询执行单明细
        List<UocImplOrderItem> implOrderItemList = getImplOrderItemList(reqBo);
        //查询执行单明细扩展
        List<UocImplItemMap> implOrderItemMapList = getImplOrderItemMapList(reqBo);
        Map<Long, List<UocImplItemMap>> implItemMap = new HashMap<>();
        if (ObjectUtil.isNotEmpty(implOrderItemMapList)) {
            implItemMap = implOrderItemMapList.stream().collect(Collectors.groupingBy(UocImplItemMap::getImplOrderItemId));
        }
        //封装出参
        //执行单
        JSONObject implObj = JSON.parseObject(JSON.toJSONString(implOrderSubject));
        //执行单扩展
        if (ObjectUtil.isNotEmpty(implOrderMapList)) {
            implOrderMapList.forEach(each -> implObj.put(each.getFieldCode(), each.getFieldValue()));
        }
        //执行单明细
        if (ObjectUtil.isNotEmpty(implOrderItemList)) {
            JSONArray implOrdeItemArray = new JSONArray();
            for (UocImplOrderItem item : implOrderItemList) {
                JSONObject itemObj = JSON.parseObject(JSON.toJSONString(item));
                //执行单明细扩展
                if (ObjectUtil.isNotEmpty(implItemMap) && implItemMap.containsKey(item.getImplOrderItemId())) {
                    List<UocImplItemMap> uocImplItemMapList = implItemMap.get(item.getImplOrderItemId());
                    if (ObjectUtil.isNotEmpty(uocImplItemMapList)) {
                        uocImplItemMapList.forEach(each -> itemObj.put(each.getFieldCode(), each.getFieldValue()));
                    }
                }
                implOrdeItemArray.add(itemObj);
            }
            implObj.put(UOC_IMPL_ORDER_ITEM, implOrdeItemArray);
        }

        rspBo.setJsonObj(implObj);
        translateProperties(rspBo);
        return rspBo;
    }

    /**
     * 初始化pCode集合
     */
    private static void initialize() {
        /*执行单主体*/
        //执行单类型字典
        pCodeList.add(UocDicConstant.IMPL_ORD_TYPE.P_CODE);
        //执行单状态字典
        pCodeList.add(UocDicConstant.IMPL_ORD_STATE.P_CODE);
        //开票标识字典
        pCodeList.add(UocDicConstant.INVOICE_TAG.P_CODE);
        //流转状态字典
        pCodeList.add(UocDicConstant.PROC_STATE.P_CODE);
        //对账状态字典
        pCodeList.add(UocDicConstant.CHECK_STATE.P_CODE);
        //竣工标志字典
        pCodeList.add(UocDicConstant.FINISH_FLAG.P_CODE);
        //撤单标志字典
        pCodeList.add(UocDicConstant.CANCEL_FLAG.P_CODE);
        //结算模式字典
        pCodeList.add(UocDicConstant.MODEL_SETTLE.P_CODE);
        //采购类别字典
        pCodeList.add(UocDicConstant.PURCHASE_TYPE.P_CODE);
        /*执行单明细*/
        //明细类型字典
        pCodeList.add(UocDicConstant.ITEM_TYPE.P_CODE);
        //明细状态字典
        pCodeList.add(UocDicConstant.ITEM_STATE.P_CODE);
    }

    /**
     * 翻译出参数据
     *
     * @param rspBo
     */
    private void translateProperties(IUocEsSyncQryRspBo rspBo) {
        //出参对象
        JSONObject jsonObj = rspBo.getJsonObj();
        //获取字典集合
        Map<String, Map<String, String>> dictionaryMap = iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        if (ObjectUtil.isNotEmpty(dictionaryMap)) {
            /*执行单主体*/
            //执行单状态翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.IMPL_ORD_STATE.P_CODE)) && ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.IMPL_ORD_STATE))) {
                String implOrderStateCode = jsonObj.get(UocConstant.ES_MAIN_OTHER.IMPL_ORD_STATE).toString();
                jsonObj.put(UocConstant.ES_MAIN_OTHER.IMPL_ORD_STATE_STR, dictionaryMap.get(UocDicConstant.IMPL_ORD_STATE.P_CODE).get(implOrderStateCode));
            }
            //执行单类型翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.IMPL_ORD_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.IMPL_ORD_TYPE))) {
                String implOrderTypeCode = jsonObj.get(UocConstant.ES_MAIN_OTHER.IMPL_ORD_TYPE).toString();
                jsonObj.put(UocConstant.ES_MAIN_OTHER.IMPL_ORD_TYPE_STR, dictionaryMap.get(UocDicConstant.IMPL_ORD_TYPE.P_CODE).get(implOrderTypeCode));
            }
            //开票标识翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.INVOICE_TAG.P_CODE)) && ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.INVOICE_TAG))) {
                String invoiceTagCode = jsonObj.get(UocConstant.ES_MAIN_OTHER.INVOICE_TAG).toString();
                jsonObj.put(UocConstant.ES_MAIN_OTHER.INVOICE_TAG_STR, dictionaryMap.get(UocDicConstant.INVOICE_TAG.P_CODE).get(invoiceTagCode));
            }
            //流转状态翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PROC_STATE.P_CODE)) && ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.PROC_STATE))) {
                String procStateCode = jsonObj.get(UocConstant.ES_MAIN_OTHER.PROC_STATE).toString();
                jsonObj.put(UocConstant.ES_MAIN_OTHER.PROC_STATE_STR, dictionaryMap.get(UocDicConstant.PROC_STATE.P_CODE).get(procStateCode));
            }
            //对账状态翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.CHECK_STATE.P_CODE)) && ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.CHECK_STATE))) {
                String checkStateCode = jsonObj.get(UocConstant.ES_MAIN_OTHER.CHECK_STATE).toString();
                jsonObj.put(UocConstant.ES_MAIN_OTHER.PROC_STATE_STR, dictionaryMap.get(UocDicConstant.CHECK_STATE.P_CODE).get(checkStateCode));
            }
            //竣工标志翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.FINISH_FLAG.P_CODE)) && ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.FINISH_FLAG))) {
                String finishFlagCode = jsonObj.get(UocConstant.ES_MAIN_OTHER.FINISH_FLAG).toString();
                jsonObj.put(UocConstant.ES_MAIN_OTHER.FINISH_FLAG_STR, dictionaryMap.get(UocDicConstant.FINISH_FLAG.P_CODE).get(finishFlagCode));
            }
            //撤单标志翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.CANCEL_FLAG.P_CODE)) && ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.CANCEL_FLAG))) {
                String cancelFlagCode = jsonObj.get(UocConstant.ES_MAIN_OTHER.CANCEL_FLAG).toString();
                jsonObj.put(UocConstant.ES_MAIN_OTHER.CANCEL_FLAG_STR, dictionaryMap.get(UocDicConstant.CANCEL_FLAG.P_CODE).get(cancelFlagCode));
            }
            //结算模式翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.MODEL_SETTLE.P_CODE)) && ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.MODEL_SETTLE))) {
                String modelSettleCode = jsonObj.get(UocConstant.ES_MAIN_OTHER.MODEL_SETTLE).toString();
                jsonObj.put(UocConstant.ES_MAIN_OTHER.MODEL_SETTLE_STR, dictionaryMap.get(UocDicConstant.MODEL_SETTLE.P_CODE).get(modelSettleCode));
            }
            //采购类别翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PURCHASE_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.PURCHASE_TYPE))) {
                String purchaseTypeCode = jsonObj.get(UocConstant.ES_MAIN_OTHER.PURCHASE_TYPE).toString();
                jsonObj.put(UocConstant.ES_MAIN_OTHER.PURCHASE_TYPE_STR, dictionaryMap.get(UocDicConstant.PURCHASE_TYPE.P_CODE).get(purchaseTypeCode));
            }
            /*执行单明细*/
            if (ObjectUtil.isNotEmpty(jsonObj.get(UOC_IMPL_ORDER_ITEM))) {
                List<UocImplOrderItem> uocImplOrderItemList = UocRu.jsl(jsonObj.get(UOC_IMPL_ORDER_ITEM), UocImplOrderItem.class);
                if (ObjectUtil.isNotEmpty(uocImplOrderItemList)) {
                    uocImplOrderItemList.forEach(each -> {
                        //明细类型翻译
                        if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.ITEM_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(each.getItemType())) {
                            each.setItemTypeStr(dictionaryMap.get(UocDicConstant.ITEM_TYPE.P_CODE).get(each.getItemType().toString()));
                        }
                        //明细状态翻译
                        if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.ITEM_STATE.P_CODE))) {
                            each.setImplItemStateStr(dictionaryMap.get(UocDicConstant.ITEM_STATE.P_CODE).get(each.getImplItemState()));
                        }
                    });
                    jsonObj.put(UOC_IMPL_ORDER_ITEM, JSON.parseArray(JSON.toJSONString(uocImplOrderItemList)));
                }
            }
        }
    }

    /**
     * 查询执行单主体
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.implorder.UocImplOrderDo
     */
    private UocImplOrderDo getImplOrderSubject(IUocEsSyncQryReqBo reqBo) {
        UocImplOrderQryBo uocImplOrderQryBo = new UocImplOrderQryBo();
        uocImplOrderQryBo.setOrderId(reqBo.getOrderId());
        uocImplOrderQryBo.setImplOrderId(reqBo.getObjId());
        return iUocImplOrderModel.getImplOrderMain(uocImplOrderQryBo);
    }

    /**
     * 查询执行单扩展
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.implorder.sub.UocImplOrderMap
     */
    private List<UocImplOrderMap> getImplOrderMapList(IUocEsSyncQryReqBo reqBo) {
        UocImplOrderMapQryBo uocImplOrderMapQryBo = new UocImplOrderMapQryBo();
        uocImplOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocImplOrderMapQryBo.setImplOrderId(reqBo.getObjId());
        return iUocImplOrderModel.getImplOrderMapList(uocImplOrderMapQryBo);
    }

    /**
     * 查询执行单明细
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem
     */
    private List<UocImplOrderItem> getImplOrderItemList(IUocEsSyncQryReqBo reqBo) {
        UocImplOrderItemQryBo uocImplOrderItemQryBo = new UocImplOrderItemQryBo();
        uocImplOrderItemQryBo.setImplOrderId(reqBo.getObjId());
        uocImplOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return iUocImplOrderModel.getListImplOrderItem(uocImplOrderItemQryBo).getUocImplOrderItemList();
    }

    /**
     * 查询执行单明细扩展
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.implorder.sub.UocImplItemMap
     */
    private List<UocImplItemMap> getImplOrderItemMapList(IUocEsSyncQryReqBo reqBo) {
        UocImplItemMapQryBo uocImplItemMapQryBo = new UocImplItemMapQryBo();
        uocImplItemMapQryBo.setImplOrderId(reqBo.getObjId());
        uocImplItemMapQryBo.setOrderId(reqBo.getOrderId());
        return iUocImplOrderModel.getImpOrderItemMapList(uocImplItemMapQryBo);
    }
}


