package com.tydic.dyc.oc.model.implorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.implorder.IUocImplOrderModel;
import com.tydic.dyc.oc.model.implorder.UocImplOrderDo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplItemMapQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderItemQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderMapQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderQryBo;
import com.tydic.dyc.oc.model.implorder.sub.UocImplItemMap;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderMap;
import com.tydic.dyc.oc.repository.UocImplOrderRepository;
import com.tydic.dyc.oc.utils.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 标题:UocImplOrderModelImpl
 * 说明:执行单方法实现
 * 时间:2022/2/23 16:02
 * 作者:罗有
 */

@Service
public class UocImplOrderModelImpl implements IUocImplOrderModel {

    @Autowired
    private UocImplOrderRepository uocImplOrderRepository;

    @Override
    public void modifyBatchItemSendCount(UocImplOrderDo uocImplOrderDo) {
        valDo(uocImplOrderDo);
        if (null == uocImplOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单ID不能为空");
        }
        if (CollectionUtils.isEmpty(uocImplOrderDo.getUocImplOrderItemList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参执行单明细列表不能为空");
        }
        uocImplOrderDo.getUocImplOrderItemList().forEach(uocImplOrderItem -> {
            if (null == uocImplOrderItem.getImplOrderItemId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参执行单明细ID不能为空");
            }
            if (null == uocImplOrderItem.getSendCount()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参发货数量不能为空");
            }
        });
        uocImplOrderRepository.modifyBatchItemSendCount(uocImplOrderDo);
    }

    @Override
    public void modifyBatchItemArrivaCount(UocImplOrderDo uocImplOrderDo) {
        valDo(uocImplOrderDo);
        if (null == uocImplOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单ID不能为空");
        }
        if (CollectionUtils.isEmpty(uocImplOrderDo.getUocImplOrderItemList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "执行单明细不能为空");
        }
        uocImplOrderDo.getUocImplOrderItemList().forEach(uocImplOrderItem -> {
            if (null == uocImplOrderItem.getImplOrderItemId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参执行单明细ID不能为空");
            }
            if (null == uocImplOrderItem.getArriveCount()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参到货数量不能为空");
            }
        });
        uocImplOrderRepository.modifyArrivaImplOrderItem(uocImplOrderDo);
    }

    @Override
    public void modifyBatchItemRefuseCount(UocImplOrderDo uocImplOrderDo) {
        valDo(uocImplOrderDo);
        if (null == uocImplOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单ID不能为空");
        }
        if (CollectionUtils.isEmpty(uocImplOrderDo.getUocImplOrderItemList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "执行单明细不能为空");
        }
        uocImplOrderDo.getUocImplOrderItemList().forEach(uocImplOrderItem -> {
            if (null == uocImplOrderItem.getImplOrderItemId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参执行单明细ID不能为空");
            }
            if (null == uocImplOrderItem.getRefuseCount()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参拒收数量不能为空");
            }
        });
        uocImplOrderRepository.modifyRefuseImplOrderItem(uocImplOrderDo);
    }

    @Override
    public UocImplOrderDo getListImplOrderItem(UocImplOrderItemQryBo uocImplOrderItemQryBo) {
        if (null == uocImplOrderItemQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocImplOrderRepository.getListImplOrderItem(uocImplOrderItemQryBo);
    }

    @Override
    public List<UocImplItemMap> getImpOrderItemMapList(UocImplItemMapQryBo uocImplItemMapQryBo) {
        if (null == uocImplItemMapQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocImplOrderRepository.getImpOrderItemMapList(uocImplItemMapQryBo);
    }

    @Override
    public UocImplOrderDo createImplOrder(UocImplOrderDo implOrderDo) {
        validateCreateImplArg(implOrderDo);
        //设置执行单
        setImpl(implOrderDo);

        //设置扩展
        setImplExt(implOrderDo);

        //设置明细
        setImplItem(implOrderDo);

        //数据存储
        return uocImplOrderRepository.saveImplOrder(implOrderDo);
    }

    private void validateCreateImplArg(UocImplOrderDo implOrderDo) {
        if(ObjectUtil.isEmpty(implOrderDo)){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR,"入参对象不能为空");
        }
    }

    private void setImplItem(UocImplOrderDo implOrderDo) {
        List<UocImplOrderItem> uocImplOrderItemList = implOrderDo.getUocImplOrderItemList();
        for (UocImplOrderItem uocImplOrderItem : uocImplOrderItemList) {
            uocImplOrderItem.setId(IdUtil.nextId());
            uocImplOrderItem.setImplOrderId(implOrderDo.getImplOrderId());
            uocImplOrderItem.setImplOrderItemId(IdUtil.nextId());
        }
    }

    private void setImplExt(UocImplOrderDo implOrderDo) {
        if (ObjectUtil.isNotEmpty(implOrderDo.getUocImplOrderMapList())) {
            for (UocImplOrderMap uocImplOrderMap : implOrderDo.getUocImplOrderMapList()) {
                uocImplOrderMap.setId(IdUtil.nextId());
            }
        }
    }

    private void setImpl(UocImplOrderDo implOrderDo) {
        implOrderDo.setImplOrderId(IdUtil.nextId());
    }

    @Override
    public UocImplOrderItem qryListImplOrderItemCount(UocImplOrderItemQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocImplOrderRepository.qryListImplOrderItemCount(qryBo);
    }

    @Override
    public void modifyBatchItemInspCount(UocImplOrderDo uocImplOrderDo) {
        valDo(uocImplOrderDo);
        if (null == uocImplOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单ID不能为空");
        }
        if (CollectionUtils.isEmpty(uocImplOrderDo.getUocImplOrderItemList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参执行单明细列表不能为空");
        }
        uocImplOrderDo.getUocImplOrderItemList().forEach(uocImplOrderItem -> {
            if (null == uocImplOrderItem.getImplOrderItemId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参执行单明细ID不能为空");
            }
            if (null == uocImplOrderItem.getAcceptanceCount()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参验收数量不能为空");
            }
        });
        uocImplOrderRepository.modifyBatchItemInspCount(uocImplOrderDo);
    }

    @Override
    public UocImplOrderDo getImplOrderMain(UocImplOrderQryBo uocImplOrderQryBo) {
        return uocImplOrderRepository.getImplOrderMain(uocImplOrderQryBo);
    }

    @Override
    public List<UocImplOrderMap> getImplOrderMapList(UocImplOrderMapQryBo uocImplOrderMapQryBo) {
        if (null == uocImplOrderMapQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocImplOrderRepository.getImplOrderMapList(uocImplOrderMapQryBo);
    }

    @Override
    public UocImplOrderDo getCollectCountImplOrderItem(UocImplOrderItemQryBo uocImplOrderItemQryBo) {
        if (null == uocImplOrderItemQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocImplOrderItemQryBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == uocImplOrderItemQryBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }
        return uocImplOrderRepository.getCollectCount(uocImplOrderItemQryBo);
    }

    @Override
    public List<UocImplOrderDo> getListImplOrder(UocImplOrderQryBo uocImplOrderQryBo) {

        return uocImplOrderRepository.getListImplOrder(uocImplOrderQryBo);
    }

    @Override
    public void modifyBatchItemChngingCount(UocImplOrderDo uocImplOrderDo) {
        valDo(uocImplOrderDo);
        if (CollectionUtils.isEmpty(uocImplOrderDo.getUocImplOrderItemList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "执行单明细为空");
        }
        uocImplOrderDo.getUocImplOrderItemList().forEach(uocImplOrderItem -> {
            if (null == uocImplOrderItem.getImplOrderItemId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "执行单明细ID为空");
            }
            if (null == uocImplOrderItem.getChngingCount()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参异常在途变更数量不能为空");
            }
        });
        uocImplOrderRepository.modifyBatchItemChngingCount(uocImplOrderDo);
    }

    @Override
    public void modifyBatchItemReturnCountConfirm(UocImplOrderDo uocImplOrderDo) {
        if (null == uocImplOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        if(CollectionUtils.isEmpty(uocImplOrderDo.getOrderIdList())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "方法订单id集合不能为空");
        }
        if(CollectionUtils.isEmpty(uocImplOrderDo.getImplOrderItemIdList())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "方法执行单明细id集合不能为空");
        }
        uocImplOrderRepository.modifyBatchItemReturnCountConfirm(uocImplOrderDo);
    }

    @Override
    public void modifyBatchItemChngCountRefuse(UocImplOrderDo uocImplOrderDo) {
        if (null == uocImplOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        if(CollectionUtils.isEmpty(uocImplOrderDo.getOrderIdList())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "方法订单id集合不能为空");
        }
        if(CollectionUtils.isEmpty(uocImplOrderDo.getImplOrderItemIdList())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "方法执行单明细id集合不能为空");
        }
        uocImplOrderRepository.modifyBatchItemChngCountRefuse(uocImplOrderDo);
    }

    private void valDo(UocImplOrderDo uocImplOrderDo) {
        if (null == uocImplOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        if (null == uocImplOrderDo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参订单ID不能为空");
        }
    }
}
