package com.tydic.dyc.oc.model.implorder.qrybo;

import com.tydic.dyc.base.bo.BasePageReqBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocImplOrderQryBo
 * 说明:执行单
 * 时间:2022-02-21 19:08
 * 作者:罗有
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class UocImplOrderQryBo extends BasePageReqBo {
	private static final long serialVersionUID =  2190970989652183733L;

	@DocField(value = "执行单id")
	private Long implOrderId;

	@DocField(value = "销售单id")
	private Long saleOrderId;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "执行单编码")
	private String implOrderNo;

	@DocField(value = "外部执行单编码")
	private String implOrderNoExt;

	@DocField(value = "执行单名称")
	private String implOrderName;

	@DocField(value = "执行单类型")
	private Integer implOrderType;

	@DocField(value = "执行单状态")
	private String implOrderState;

	@DocField(value = "执行单说明")
	private String implOrderDesc;

	@DocField(value = "开票标识 0未开票 1已开票")
	private Integer invoiceTag;

	@DocField(value = "销售金额")
	private BigDecimal totalSaleFee;

	@DocField(value = "采购金额")
	private BigDecimal totalPurchaseFee;

	@DocField(value = "优惠金额")
	private BigDecimal totalActShareFee;

	@DocField(value = "运费")
	private BigDecimal totalTransFee;

	@DocField(value = "实付金额")
	private BigDecimal usedFee;

	@DocField(value = "实付积分")
	private BigDecimal usedIntegral;

	@DocField(value = "协议编号")
	private String agreementNo;

	@DocField(value = "合同编号")
	private String contractNo;

	@DocField(value = "流转状态")
	private String procState;

	@DocField(value = "对账状态")
	private String checkState;

	@DocField(value = "税率")
	private String taxRate;

	@DocField(value = "竣工标志             1 竣工             0 在途")
	private Integer finishFlag;

	@DocField(value = "租户ID")
	private String tenantId;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新时间 开始")
	private Date updateTimeStart;

	@DocField(value = "更新时间 结束")
	private Date updateTimeEnd;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "撤单时间")
	private Date cancelTime;

	@DocField(value = "撤单时间 开始")
	private Date cancelTimeStart;

	@DocField(value = "撤单时间 结束")
	private Date cancelTimeEnd;

	@DocField(value = "撤单工号")
	private String cancelOperId;

	@DocField(value = "撤单原因")
	private String cancelReason;

	@DocField(value = "撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "竣工时间")
	private Date finishTime;

	@DocField(value = "竣工时间 开始")
	private Date finishTimeStart;

	@DocField(value = "竣工时间 结束")
	private Date finishTimeEnd;

	@DocField(value = "逾期时间")
	private Date expTime;

	@DocField(value = "逾期时间 开始")
	private Date expTimeStart;

	@DocField(value = "逾期时间 结束")
	private Date expTimeEnd;

	@DocField(value = "结算模式 2:撮合 1:贸易")
	private Integer modelSettle;

	@DocField(value = "采购类别             1 物资             2 施工             3 服务             ")
	private Integer purchaseType;

	@DocField(value = "排序")
	private String orderBy;

}
