package com.tydic.dyc.oc.model.insporder.qrybo;

import com.tydic.dyc.base.bo.BasePageReqBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocInspOrderQryBo
 * 说明:验收单
 * 时间:2022-02-21 19:09
 * 作者:罗有
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class UocInspOrderQryBo extends BasePageReqBo {
	private static final long serialVersionUID =  -1500135445095031880L;

	@DocField(value = "验收单id")
	private Long inspOrderId;

	@DocField(value = "执行单id")
	private Long implOrderId;

	@DocField(value = "执行明细id")
	private Long implOrderItemId;

	@DocField(value = "销售单id")
	private Long saleOrderId;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "发货单编码")
	private String inspOrderNo;

	@DocField(value = "外部发货单编码")
	private String inspOrderNoExt;

	@DocField(value = "验收单名称")
	private String inspOrderName;

	@DocField(value = "验收单类型")
	private Integer inspOrderType;

	@DocField(value = "验收单状态")
	private String inspOrderState;

	@DocField(value = "销售金额")
	private BigDecimal totalSaleFee;

	@DocField(value = "采购金额")
	private BigDecimal totalPurchaseFee;

	@DocField(value = "实付金额")
	private BigDecimal usedFee;

	@DocField(value = "开票标识 0未开票 1已开票")
	private Integer invoiceTag;

	@DocField(value = "流转状态")
	private String procState;

	@DocField(value = "对账状态")
	private String checkState;

	@DocField(value = "租户ID")
	private String tenantId;

	@DocField(value = "竣工标志             1 竣工             0 在途")
	private Integer finishFlag;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "验收人电话")
	private String inspOperPhone;

	@DocField(value = "验收人名字")
	private String inspOper;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新时间 开始")
	private Date updateTimeStart;

	@DocField(value = "更新时间 结束")
	private Date updateTimeEnd;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "撤单时间")
	private Date cancelTime;

	@DocField(value = "撤单时间 开始")
	private Date cancelTimeStart;

	@DocField(value = "撤单时间 结束")
	private Date cancelTimeEnd;

	@DocField(value = "撤单工号")
	private String cancelOperId;

	@DocField(value = "撤单原因")
	private String cancelReason;

	@DocField(value = "撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "竣工时间")
	private Date finishTime;

	@DocField(value = "竣工时间 开始")
	private Date finishTimeStart;

	@DocField(value = "竣工时间 结束")
	private Date finishTimeEnd;

	@DocField(value = "逾期时间")
	private Date expTime;

	@DocField(value = "逾期时间 开始")
	private Date expTimeStart;

	@DocField(value = "逾期时间 结束")
	private Date expTimeEnd;

	

	@DocField(value = "删除标志1已删除")
	private Integer delTag;

	@DocField(value = "排序")
	private String orderBy;

}
