package com.tydic.dyc.oc.model.aforder.qrybo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocAfOrderItemQryBo
 * 说明:售后服务明细
 * 时间:2022-02-23 20:57
 * 作者:罗有
 **/
@Data
public class UocAfOrderItemQryBo implements Serializable {
	private static final long serialVersionUID = -7431342959366381039L;

	@DocField(value = "服务明细id")
	private Long afOrderItemId;

	@DocField(value = "售后服务单id")
	private Long afOrderId;

	@DocField(value = "验收明细id")
	private Long inspItemId;

	@DocField(value = "发货明细id")
	private Long shipItemId;

	@DocField(value = "销售明细id")
	private Long orderItemId;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "外部售后服务单号")
	private String extAfId;

	@DocField(value = "外部订单编号")
	private String extOrderId;

	@DocField(value = "执行单id")
	private Long implOrderId;

	@DocField(value = "销售单id")
	private Long saleOrderId;

	@DocField(value = "单品id")
	private Long skuId;

	@DocField(value = "计量单位")
	private String unitName;

	@DocField(value = "采购数量")
	private BigDecimal purchaseCount;

	@DocField(value = "售后服务量")
	private BigDecimal returnCount;

	@DocField(value = "币种")
	private String currencyType;

	@DocField(value = "销售退款金额")
	private BigDecimal retSaleFee;

	@DocField(value = "采购退款金额")
	private BigDecimal retPurchaseFee;

	@DocField(value = "是否有包装")
	private Integer ishaspackage;

	@DocField(value = "包装描述             0 无包装              10 包装完整              20 包装破损             暂不需要             ")
	private Integer packageDesc;

	@DocField(value = "问题描述")
	private String questionDesc;

	@DocField(value = "是否需要检测报告")
	private Integer isNeedDetectionReport;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新时间 开始")
	private Date updateTimeStart;

	@DocField(value = "更新时间 结束")
	private Date updateTimeEnd;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "删除标志1已删除")
	private Integer delTag;

	@DocField(value = "扩展字段1")
	private String extField1;

	@DocField(value = "扩展字段2")
	private String extField2;

	@DocField(value = "扩展字段3")
	private String extField3;

	@DocField(value = "扩展字段4")
	private String extField4;

	@DocField(value = "扩展字段5")
	private String extField5;

	@DocField(value = "排序")
	private String orderBy;
}
