package com.tydic.dyc.oc.model.implorder;

import com.tydic.dyc.oc.model.implorder.qrybo.UocImplItemMapQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderItemQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderMapQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderQryBo;
import com.tydic.dyc.oc.model.implorder.sub.UocImplItemMap;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderMap;

import java.util.List;

/**
 * 标题:IUocImplOrderModel
 * 说明:执行单方法
 * 时间:2022/2/23 16:01
 * 作者:罗有
 */

public interface IUocImplOrderModel {
    /**
     * 批量更新执行单明细发货数量
     * @param uocImplOrderDo
     */
    void modifyBatchItemSendCount(UocImplOrderDo uocImplOrderDo);
    /**
     * 批量更新执行单明细到货数量
     * @param uocImplOrderDo
     */
    void modifyBatchItemArrivaCount(UocImplOrderDo uocImplOrderDo);
    /**
     * 批量更新执行单明细拒收数量
     * @param uocImplOrderDo
     */
    void modifyBatchItemRefuseCount(UocImplOrderDo uocImplOrderDo);

    /**
     * 查询执行单明细
     * @param uocImplOrderItemQryBo
     * @return
     */
    UocImplOrderDo getListImplOrderItem(UocImplOrderItemQryBo uocImplOrderItemQryBo);

    /**
     * 查询执行单明细扩展
     * @param uocImplItemMapQryBo
     * @return com.tydic.dyc.oc.model.implorder.UocImplOrderDo
     */
    List<UocImplItemMap> getImpOrderItemMapList(UocImplItemMapQryBo uocImplItemMapQryBo);

    /**
     * 描述:创建执行单
     * @param implOrderDo 入参
     * @return com.tydic.dyc.oc.model.implorder.UocImplOrderDo
     * @author tgy
     * @date 2022/2/24 18:47
     */
    UocImplOrderDo createImplOrder(UocImplOrderDo implOrderDo);
    /**
     * 执行单明细数量汇总查询
     * @param qryBo
     * @return com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem
     */
    UocImplOrderItem qryListImplOrderItemCount(UocImplOrderItemQryBo qryBo);

    /**
     * 更新执行明细验收数量
     *
     * @param implOrderDo
     */
    void modifyBatchItemInspCount(UocImplOrderDo implOrderDo);

    /**
     * 查询执行单主体信息
     *
     * @param uocImplOrderQryBo
     * @return
     */
    UocImplOrderDo getImplOrderMain(UocImplOrderQryBo uocImplOrderQryBo);

    /**
     * 查询执行单扩展
     *
     * @param uocImplOrderMapQryBo
     * @return com.tydic.dyc.oc.model.implorder.UocImplOrderDo
     */
    List<UocImplOrderMap> getImplOrderMapList(UocImplOrderMapQryBo uocImplOrderMapQryBo);

    /**
     * 查询明细各种数量汇总
     *
     * @param uocImplOrderItemQryBo
     * @return
     */
    UocImplOrderDo getCollectCountImplOrderItem(UocImplOrderItemQryBo uocImplOrderItemQryBo);

    /**
     * 查询执行单列表
     *
     * @param uocImplOrderQryBo
     * @return
     */
    List<UocImplOrderDo> getListImplOrder(UocImplOrderQryBo uocImplOrderQryBo);

    /**
     * 修改执行单明细异常变更在途数量
     *
     * @param convertImplOrderDo
     */
    void modifyBatchItemChngingCount(UocImplOrderDo convertImplOrderDo);

    /**
     * 修改执行单明细退货数量 依据变更在途数量更新
     * @param convertImplOrderDo
     */
    void modifyBatchItemReturnCountConfirm(UocImplOrderDo convertImplOrderDo);

    /**
     * 修改执行单明细异常变更在途数量为0 变更拒绝
     * @param convertImplOrderDo
     */
    void modifyBatchItemChngCountRefuse(UocImplOrderDo convertImplOrderDo);
}
