package com.tydic.dyc.oc.repository;

import com.tydic.dyc.oc.model.implorder.UocImplOrderDo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplItemMapQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderItemQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderMapQryBo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderQryBo;
import com.tydic.dyc.oc.model.implorder.sub.UocImplItemMap;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderMap;

import java.util.List;

/**
 * 标题:UocImplOrderRepository
 * 说明:执行单
 * 时间:2022-02-21 14:29
 * 作者:罗有
 **/
public interface UocImplOrderRepository {

    /**
     * 更改执行明细的发货数量
     * @param uocImplOrderDo
     */
    void modifyBatchItemSendCount(UocImplOrderDo uocImplOrderDo);

    /**
     * 更改执行明细的到货数量
     * @param uocImplOrderDo
     */
    void modifyArrivaImplOrderItem(UocImplOrderDo uocImplOrderDo);

    /**
     * 更改执行明细的拒收数量
     * @param uocImplOrderDo
     */
    void modifyRefuseImplOrderItem(UocImplOrderDo uocImplOrderDo);

    /**
     * 查询执行明细
     * @param uocImplOrderItemQryBo
     * @return
     */
    UocImplOrderDo getListImplOrderItem(UocImplOrderItemQryBo uocImplOrderItemQryBo);

    /**
     * 查询执行单明细扩展
     * @param uocImplItemMapQryBo
     * @return com.tydic.dyc.oc.model.implorder.UocImplOrderDo
     */
    List<UocImplItemMap> getImpOrderItemMapList(UocImplItemMapQryBo uocImplItemMapQryBo);

    /**
     * 保存执行单
     * @param implOrderDo
     * @return
     */
    UocImplOrderDo saveImplOrder(UocImplOrderDo implOrderDo);

    /**
     * 更新执行单明细验收数量
     * @param implOrderDo
     */
    void modifyBatchItemInspCount(UocImplOrderDo implOrderDo);

    /**
     * 描述:执行单明细数量汇总查询
     *
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem
     * @author tkl
     * @date 2022/2/25 17:29
     */
    UocImplOrderItem qryListImplOrderItemCount(UocImplOrderItemQryBo qryBo);

    /**
     * 查询执行单主体信息
     *
     * @param uocImplOrderQryBo
     * @return
     */
    UocImplOrderDo getImplOrderMain(UocImplOrderQryBo uocImplOrderQryBo);

    /**
     * 查询执行单扩展
     *
     * @param uocImplOrderMapQryBo
     * @return com.tydic.dyc.oc.model.implorder.UocImplOrderDo
     */
    List<UocImplOrderMap> getImplOrderMapList(UocImplOrderMapQryBo uocImplOrderMapQryBo);

    /**
     * 查询汇执行单总数量
     *
     * @param uocImplOrderItemQryBo
     * @return
     */
    UocImplOrderDo getCollectCount(UocImplOrderItemQryBo uocImplOrderItemQryBo);

    /**
     * 查询执行单列表
     *
     * @param uocImplOrderQryBo
     * @return
     */
    List<UocImplOrderDo> getListImplOrder(UocImplOrderQryBo uocImplOrderQryBo);

    /**
     * 修改执行单明细在途数量
     *
     * @param uocImplOrderDo
     */
    void modifyBatchItemChngingCount(UocImplOrderDo uocImplOrderDo);

    /**
     * 更新执行单明细退货数量 依据变更在途数量更新
     * @param uocImplOrderDo
     */
    void modifyBatchItemReturnCountConfirm(UocImplOrderDo uocImplOrderDo);

    /**
     * 修改执行单明细异常变更在途数量为0，变更拒绝
     * @param uocImplOrderDo
     */
    void modifyBatchItemChngCountRefuse(UocImplOrderDo uocImplOrderDo);
}
