package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocPasteCancelApplySaleOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocPasteCancelApplySaleOrderRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * 标题:UocPasteCancelApplySaleOrderServiceImpl
 * 说明:销售单撤销取消申请
 * 时间:2022/3/15 12:21
 * 作者:罗有
 */

@HTServiceImpl
public class UocPasteCancelApplySaleOrderServiceImpl implements UocPasteCancelApplySaleOrderService {

	@Autowired
	private IUocSaleOrderModel iUocSaleOrderModel;

	@Autowired
	private IUocChngOrderModel iUocChngOrderModel;

	@Override
	public UocPasteCancelApplySaleOrderRspBo dealPasteCancelApply(UocPasteCancelApplySaleOrderReqBo reqBo) {
		val(reqBo);
		Date now = new Date();
		String operId = reqBo.getUserId().toString();

		UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
		uocChngOrderObjQryBo.setOrderId(reqBo.getOrderId());
		uocChngOrderObjQryBo.setChngOrderId(reqBo.getChngOrderId());
		List<UocChngOrderObj> chngOrderObjList = iUocChngOrderModel.getListChngOrderObj(uocChngOrderObjQryBo);
		if (CollectionUtils.isEmpty(chngOrderObjList)) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_PASTE_CANCEL_APPLY_ERROR, "查询变更对象为空");
		}
		UocChngOrderObj uocChngOrderObj = chngOrderObjList.get(0);

		UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
		uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
		uocSaleOrderDo.setOrderId(reqBo.getOrderId());
		uocSaleOrderDo.setSaleOrderState(uocChngOrderObj.getOtherChngValue());
		uocSaleOrderDo.setUpdateOperId(operId);
		uocSaleOrderDo.setUpdateTime(now);
		uocSaleOrderDo.setUpdateOperName(reqBo.getName());
		iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);

		UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
		uocChngOrderDo.setOrderId(reqBo.getOrderId());
		uocChngOrderDo.setChngOrderState(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.CHNG_XS_YCX);
		uocChngOrderDo.setChngOrderId(reqBo.getChngOrderId());
		uocChngOrderDo.setUpdateOperId(operId);
		uocChngOrderDo.setUpdateTime(now);
		uocChngOrderDo.setUpdateOperName(reqBo.getName());
		iUocChngOrderModel.updateChngOrderMain(uocChngOrderDo);

		return UocRu.success(UocPasteCancelApplySaleOrderRspBo.class);
	}

	private void val(UocPasteCancelApplySaleOrderReqBo reqBo) {
		if (null == reqBo) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
		}
		if (null == reqBo.getOrderId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
		}
		if (null == reqBo.getSaleOrderId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
		}
		if (null == reqBo.getChngOrderId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更单ID不能为空");
		}
		if (null == reqBo.getUserId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID不能为空");
		}

	}
}
