package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleItemMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryDetailBo;
import com.tydic.dyc.oc.service.saleorder.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:UocGetSaleOrderDetailServiceImpl
 * 说明:
 * 时间:2022/2/25 10:29
 * 作者:田坤林
 */
@HTServiceImpl
public class UocGetSaleOrderDetailServiceImpl implements UocGetSaleOrderDetailService {

    public static final List<String> pCodeList = ListUtil.list(false);

    static {
        initialize();
    }

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Override
    public UocGetSaleOrderDetailServiceRspBo getSaleOrderDetail(UocGetSaleOrderDetailServiceReqBo reqBo) {
        //入参校验
        validateParam(reqBo);
        //销售单附件
        List<UocBaseOrderAccessoryTypeDetailBo> accessoryDetailBoList = new ArrayList<>();
        //销售单纵向扩展
        List<UocBaseExtParallelBo> uocBaseExtParallelBoList = new ArrayList<>();
        //销售单明细
        List<UocGetSaleOrderDetailServiceRspItemBo> uocGetSaleOrderDetailServiceRspItemBos = new ArrayList<>();

        //查询销售单主体
        UocSaleOrderQryBo uocSaleOrderQryBo = UocRu.js(reqBo, UocSaleOrderQryBo.class);
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        if (Objects.isNull(uocSaleOrderDo)) {
            return UocRu.success(UocGetSaleOrderDetailServiceRspBo.class);
        }
        UocGetSaleOrderDetailServiceRspBo rspBo = UocRu.js(uocSaleOrderDo, UocGetSaleOrderDetailServiceRspBo.class);
        //三方信息
        rspBo.setUocGetSaleOrderDetailServiceRspStakeholderBo(ObjectUtil.isNotEmpty(uocSaleOrderDo.getStakeholder()) ?
                UocRu.js(uocSaleOrderDo.getStakeholder(), UocGetSaleOrderDetailServiceRspStakeholderBo.class) : new UocGetSaleOrderDetailServiceRspStakeholderBo());
        //查询流程
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        procInstQryBo.setObjId(uocSaleOrderDo.getSaleOrderId());
        procInstQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            taskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });
            }
            procInst.setTaskList(taskBoList);
        }
        rspBo.setProcInst(procInst);
        //查询订单主体
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        uocOrderDo = iUocOrderModel.qryOrderBy(uocOrderDo);
        if (ObjectUtil.isNotNull(uocOrderDo)) {
            rspBo.setOrderNo(uocOrderDo.getOrderNo());
            rspBo.setOrderTime(uocOrderDo.getCreateTime());
        }
        //查询协议信息
        UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
        uocOrderAgreementQryBo.setOrderId(reqBo.getOrderId());
        uocOrderAgreementQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocOrderAgreement> agreementOrderList = iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);
        if (ObjectUtil.isNotEmpty(agreementOrderList)) {
            rspBo.setAgreementInfo(new UocGetSaleOrderDetailServiceRspAgreementInfoBo());
            rspBo.getAgreementInfo().setAgreementCode(agreementOrderList.get(0).getAgreementCode());
            rspBo.getAgreementInfo().setPlaAgreementCode(agreementOrderList.get(0).getPlaAgreementCode());
            rspBo.getAgreementInfo().setAgreementName(agreementOrderList.get(0).getAgreementName());
            rspBo.getAgreementInfo().setAdjustPrice(agreementOrderList.get(0).getAdjustPrice());
        }
        //查询订单核实信息
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setOrderId(reqBo.getOrderId());
        uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.ADJUST_PRICE);
        List<UocChngOrderDo> listChngOrder = iUocChngOrderModel.getListChngOrder(uocChngOrderQryBo);
        if (ObjectUtil.isNotEmpty(listChngOrder)) {
            rspBo.setOrderVerifyInfo(new UocGetSaleOrderDetailServiceRspVerifyInfoBo());
            rspBo.getOrderVerifyInfo().setAdjustName(listChngOrder.get(0).getCreateOperName());
            rspBo.getOrderVerifyInfo().setAdjustTime(listChngOrder.get(0).getCreateTime());
            rspBo.getOrderVerifyInfo().setRemark(listChngOrder.get(0).getRemark());
        }
        //查询收获人地址信息
        UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
        relaQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        UocOrdLogisticsRela uocOrdLogisticsRela = iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        rspBo.setReceiverAddressBo(UocRu.js(uocOrdLogisticsRela, UocGetSaleOrderDetailServiceRspReceiverAddressBo.class));
        //查询发票信息
        UocOrdInvoiceQryBo invoiceQryBo = new UocOrdInvoiceQryBo();
        invoiceQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        UocOrdInvoice uocOrdInvoice = iUocOrderModel.qryOrderInvoice(invoiceQryBo);
        rspBo.setInvoiceBo(UocRu.js(uocOrdInvoice, UocGetSaleOrderDetailServiceRspInvoiceBo.class));
        //查询发票邮寄信息
        UocGetSaleOrderDetailServiceRspReceiverAddressBo invoiceAddressBo = new UocGetSaleOrderDetailServiceRspReceiverAddressBo();
        if (ObjectUtil.isNotEmpty(uocOrdInvoice)) {
            relaQryBo = new UocOrdLogisticsRelaQryBo();
            relaQryBo.setContactId(uocOrdInvoice.getContactId());
            relaQryBo.setOrderId(uocOrdInvoice.getOrderId());
            invoiceAddressBo = UocRu.js(iUocOrderModel.qryOrderLogisticsRela(relaQryBo), UocGetSaleOrderDetailServiceRspReceiverAddressBo.class);
        }
        rspBo.setInvoiceAddressBo(invoiceAddressBo);
        //查询销售单附件
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
        uocOrderAccessoryQryBo.setObjId(uocSaleOrderDo.getSaleOrderId());
        uocOrderAccessoryQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        uocOrderAccessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        List<UocOrderAccessory> saleOrderAccessoryList = iUocSaleOrderModel.getSaleOrderAccessoryList(uocOrderAccessoryQryBo).getSaleOrderAccessoryList();
        if (ObjectUtil.isNotEmpty(saleOrderAccessoryList)) {
            List<UocBaseOrderAccessoryDetailBo> accessoryDetailBos = UocRu.jsl(saleOrderAccessoryList, UocBaseOrderAccessoryDetailBo.class);
            Map<Integer, List<UocBaseOrderAccessoryDetailBo>> accessoryDetailMap =
                    accessoryDetailBos.stream().collect(Collectors.groupingBy(UocBaseOrderAccessoryDetailBo::getAttachmentType));
            Iterator<Integer> iterator = accessoryDetailMap.keySet().iterator();
            while (iterator.hasNext()) {
                UocBaseOrderAccessoryTypeDetailBo accessoryTypeDetailBo = new UocBaseOrderAccessoryTypeDetailBo();
                Integer attachmentType = iterator.next();
                accessoryTypeDetailBo.setAttachmentType(attachmentType);
                accessoryTypeDetailBo.setAttchList(accessoryDetailMap.get(attachmentType));
                accessoryDetailBoList.add(accessoryTypeDetailBo);
            }
        }
        //查询销售单主体扩展
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = UocRu.js(reqBo, UocSaleOrderMapQryBo.class);
        List<UocSaleOrderMap> saleOrderExpandList = iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderExpandList)) {
            uocBaseExtParallelBoList = UocRu.jsl(saleOrderExpandList, UocBaseExtParallelBo.class);
        }
        //查询销售单明细
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = UocRu.js(reqBo, UocSaleOrderItemQryBo.class);
        List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            for (UocSaleOrderItem item : saleOrderItemList) {
                UocGetSaleOrderDetailServiceRspItemBo rspItemBo = UocRu.js(item, UocGetSaleOrderDetailServiceRspItemBo.class);
                //查询销售单明细扩展
                UocSaleItemMapQryBo uocSaleItemMapQryBo = new UocSaleItemMapQryBo();
                uocSaleItemMapQryBo.setSaleOrderItemId(item.getSaleOrderItemId());
                List<UocSaleItemMap> saleOrderItemMapList = iUocSaleOrderModel.getSaleOrderItemMapList(uocSaleItemMapQryBo);
                if (ObjectUtil.isNotEmpty(saleOrderItemMapList)) {
                    List<UocBaseExtParallelBo> uocBaseExtParallelBos = UocRu.jsl(saleOrderItemMapList, UocBaseExtParallelBo.class);
                    rspItemBo.setItemExtParallelBos(uocBaseExtParallelBos);
                    if (ObjectUtil.equal(rspItemBo.getItemType(), UocDicConstant.ITEM_TYPE.COMMODITY_SKU)) {
                        rspItemBo.setCommExtParallelBos(uocBaseExtParallelBos);
                    }
                }
                uocGetSaleOrderDetailServiceRspItemBos.add(rspItemBo);
            }
        }

        rspBo.setAccessoryDetailBoList(accessoryDetailBoList);
        rspBo.setSaleOrderDetailServiceRspExtBoList(uocBaseExtParallelBoList);
        rspBo.setSaleOrderDetailServiceRspItemBoList(uocGetSaleOrderDetailServiceRspItemBos);
        //字段翻译
        translateProperties(rspBo);

        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBo;
    }

    /**
     * 初始化pCode集合
     */
    private static void initialize() {
        /*销售单主体*/
        //销售单状态字典
        pCodeList.add(UocDicConstant.SALE_ORD_STATE.P_CODE);
        //订单来源字典
        pCodeList.add(UocDicConstant.ORDER_SOURCE.P_CODE);
        //付款方式字典
        pCodeList.add(UocDicConstant.PAY_TYPE.P_CODE);
        //支付状态字典
        pCodeList.add(UocDicConstant.PAY_STATE.P_CODE);
        //竣工标志字典
        pCodeList.add(UocDicConstant.FINISH_FLAG.P_CODE);
        //结算模式字典
        pCodeList.add(UocDicConstant.MODEL_SETTLE.P_CODE);
        //采购类别字典
        pCodeList.add(UocDicConstant.PURCHASE_TYPE.P_CODE);
        //采购模式字典
        pCodeList.add(UocDicConstant.PURCHASE_MODE.P_CODE);
        /*发票信息*/
        //发票类型字典
        pCodeList.add(UocDicConstant.INVOICE_TYPE.P_CODE);
        //发票类别字典
        pCodeList.add(UocDicConstant.INVOICE_CATEGORY.P_CODE);
        /*附件信息*/
        //附件类型字典
        pCodeList.add(UocDicConstant.ATTACHMENT_TYPE.P_CODE);
        //单据类型字典
        pCodeList.add(UocDicConstant.OBJ_TYPE.P_CODE);
        /*销售单明细信息*/
        //明细类型字典
        pCodeList.add(UocDicConstant.ITEM_TYPE.P_CODE);
        /*任务处理信息*/
        //处理对象类型字典
        pCodeList.add(UocDicConstant.DEAL_TYPE.P_CODE);
        //处理分类字典
        pCodeList.add(UocDicConstant.DEAL_CLASS.P_CODE);
        /*协议信息*/
        //协议模式字典
        pCodeList.add(UocDicConstant.AGREEMENT_MODE.P_CODE);
        //调价机制字典
        pCodeList.add(UocDicConstant.ADJUST_PRICE.P_CODE);
    }

    /**
     * 翻译出参数据
     *
     * @param rspBo
     */
    private void translateProperties(UocGetSaleOrderDetailServiceRspBo rspBo) {
        //获取字典集合
        Map<String, Map<String, String>> dictionaryMap = iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        if (ObjectUtil.isNotEmpty(dictionaryMap)) {
            /*销售单主体*/
            //销售单状态翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE))) {
                rspBo.setSaleOrderStateStr(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE).get(rspBo.getSaleOrderState()));
            }
            //订单来源翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.ORDER_SOURCE.P_CODE)) && ObjectUtil.isNotEmpty(rspBo.getOrderSource())) {
                rspBo.setOrderSourceStr(dictionaryMap.get(UocDicConstant.ORDER_SOURCE.P_CODE).get(rspBo.getOrderSource().toString()));
            }
            //付款方式翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PAY_TYPE.P_CODE))) {
                rspBo.setPayTypeStr(dictionaryMap.get(UocDicConstant.PAY_TYPE.P_CODE).get(rspBo.getPayType()));
            }
            //支付状态翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PAY_STATE.P_CODE)) && ObjectUtil.isNotEmpty(rspBo.getPayState())) {
                rspBo.setPayStateStr(dictionaryMap.get(UocDicConstant.PAY_STATE.P_CODE).get(rspBo.getPayState().toString()));
            }
            //竣工标志翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.FINISH_FLAG.P_CODE)) && ObjectUtil.isNotEmpty(rspBo.getFinishFlag())) {
                rspBo.setFinishFlagStr(dictionaryMap.get(UocDicConstant.FINISH_FLAG.P_CODE).get(rspBo.getFinishFlag().toString()));
            }
            //结算模式翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.MODEL_SETTLE.P_CODE)) && ObjectUtil.isNotEmpty(rspBo.getModelSettle())) {
                rspBo.setModelSettleStr(dictionaryMap.get(UocDicConstant.MODEL_SETTLE.P_CODE).get(rspBo.getModelSettle().toString()));
            }
            //采购类别翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PURCHASE_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(rspBo.getPurchaseType())) {
                rspBo.setPurchaseTypeStr(dictionaryMap.get(UocDicConstant.PURCHASE_TYPE.P_CODE).get(rspBo.getPurchaseType().toString()));
            }
            //采购模式翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PURCHASE_MODE.P_CODE)) && ObjectUtil.isNotEmpty(rspBo.getPurchaseMode())) {
                rspBo.setPurchaseModeStr(dictionaryMap.get(UocDicConstant.PURCHASE_MODE.P_CODE).get(rspBo.getPurchaseMode().toString()));
            }
            /*发票信息*/
            if (ObjectUtil.isNotEmpty(rspBo.getInvoiceBo())) {
                UocGetSaleOrderDetailServiceRspInvoiceBo invoiceBo = rspBo.getInvoiceBo();
                //发票类型翻译
                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.INVOICE_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(invoiceBo.getInvoiceType())) {
                    invoiceBo.setInvoiceTypeStr(dictionaryMap.get(UocDicConstant.INVOICE_TYPE.P_CODE).get(invoiceBo.getInvoiceType().toString()));
                }
                //发票类别翻译
                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.INVOICE_CATEGORY.P_CODE)) && ObjectUtil.isNotEmpty(invoiceBo.getInvoceCategory())) {
                    invoiceBo.setInvoceCategoryStr(dictionaryMap.get(UocDicConstant.INVOICE_CATEGORY.P_CODE).get(invoiceBo.getInvoceCategory().toString()));
                }
            }
            /*附件信息*/
            if (ObjectUtil.isNotEmpty(rspBo.getAccessoryDetailBoList())) {
                rspBo.getAccessoryDetailBoList().forEach(each -> {
                    //附件类型翻译
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.ATTACHMENT_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(each.getAttachmentType())) {
                        each.setAttachmentTypeStr(dictionaryMap.get(UocDicConstant.ATTACHMENT_TYPE.P_CODE).get(each.getAttachmentType().toString()));
                    }
                    if (ObjectUtil.isNotEmpty(each.getAttchList())) {
                        for (UocBaseOrderAccessoryDetailBo accessoryDetailBo : each.getAttchList()) {
                            //单据类型翻译
                            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(accessoryDetailBo.getObjType())) {
                                accessoryDetailBo.setObjTypeStr(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE).get(accessoryDetailBo.getObjType().toString()));
                            }
                            //附件类型翻译
                            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.ATTACHMENT_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(accessoryDetailBo.getAttachmentType())) {
                                accessoryDetailBo.setAttachmentTypeStr(dictionaryMap.get(UocDicConstant.ATTACHMENT_TYPE.P_CODE).get(accessoryDetailBo.getAttachmentType().toString()));
                            }
                        }
                    }
                });
            }
            /*销售单明细信息*/
            if (ObjectUtil.isNotEmpty(rspBo.getSaleOrderDetailServiceRspItemBoList())) {
                rspBo.getSaleOrderDetailServiceRspItemBoList().forEach(each -> {
                    //明细类型翻译
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.ITEM_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(each.getItemType())) {
                        each.setItemTypeStr(dictionaryMap.get(UocDicConstant.ITEM_TYPE.P_CODE).get(each.getItemType().toString()));
                    }
                });
            }
            /*协议信息*/
            if (ObjectUtil.isNotNull(rspBo.getAgreementInfo())) {
                UocGetSaleOrderDetailServiceRspAgreementInfoBo agreementInfo = rspBo.getAgreementInfo();
                //协议模式翻译
                if (null != agreementInfo.getAgreementCode()) {
                    agreementInfo.setAgreementCodeStr(dictionaryMap.get(UocDicConstant.AGREEMENT_MODE.P_CODE).get(agreementInfo.getAgreementCode().toString()));
                }
                //调价机制翻译
                if (null != agreementInfo.getAdjustPrice()) {
                    agreementInfo.setAdjustPriceStr(dictionaryMap.get(UocDicConstant.ADJUST_PRICE.P_CODE).get(agreementInfo.getAdjustPrice().toString()));
                }
            }
            /*流程数据*/
            if (ObjectUtil.isNotEmpty(rspBo.getProcInst())) {
                UocGetSaleOrderDetailServiceRspPorcBo procInst = rspBo.getProcInst();
                //流程单据类型翻译
                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(procInst.getObjType())) {
                    procInst.setObjTypeStr(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE).get(procInst.getObjType().toString()));
                }
                if (ObjectUtil.isNotEmpty(procInst.getTaskList())) {
                    procInst.getTaskList().forEach(each -> {
                        //任务单据类型翻译
                        if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(each.getObjType())) {
                            each.setObjTypeStr(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE).get(each.getObjType().toString()));
                        }
                        if (ObjectUtil.isNotEmpty(each.getTaskDealBo())) {
                            for (UocGetSaleOrderDetailServiceRspTaskDealBo taskDealBo : each.getTaskDealBo()) {
                                //任务处理单据类型翻译
                                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(taskDealBo.getObjType())) {
                                    taskDealBo.setObjTypeStr(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE).get(taskDealBo.getObjType().toString()));
                                }
                                //处理对象类型翻译
                                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.DEAL_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(taskDealBo.getDealType())) {
                                    taskDealBo.setDealTypeStr(dictionaryMap.get(UocDicConstant.DEAL_TYPE.P_CODE).get(taskDealBo.getDealType().toString()));
                                }
                                //处理分类翻译
                                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.DEAL_CLASS.P_CODE))) {
                                    taskDealBo.setDealClassStr(dictionaryMap.get(UocDicConstant.DEAL_CLASS.P_CODE).get(taskDealBo.getDealClass()));
                                }
                            }
                        }
                    });
                }
            }
        }
    }

    private void validateParam(UocGetSaleOrderDetailServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参不能为空");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单ID不能为空");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单ID不能为空");
        }
    }
}


